/* Interface for the gcalc scanner and parser to interact with the 
   GENERIC generation functions
   Copyright (C) 2010
   Free Software Foundation, Inc.

   This file is part of GCC.

   GCC is free software; you can redistribute it and/or modify it under
   the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 3, or (at your option) any later
   version.

   GCC is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with GCC; see the file COPYING3.  If not see
   <http://www.gnu.org/licenses/>.  
*/

#ifndef _CALC_LANG_H__
#define _CALC_LANG_H__

#include "calc_location.h"

typedef struct symtab_entry
{
  tree name;
  tree decl;
} symtab_entry_t;

extern htab_t calc_sym_table;
extern tree main_stmts;

extern VEC(tree,gc) * main_block_decls;
extern VEC(tree,gc) * global_decls_vec;

extern int calc_htab_trav (void **, void*);

extern int init_sym_tbl (void);
extern int fini_sym_tbl (void);

extern tree build_add_expr (tree, calc_location_t *, tree, calc_location_t *);
extern tree build_sub_expr (tree, calc_location_t *, tree, calc_location_t *);
extern tree build_mult_expr (tree, calc_location_t *, tree, calc_location_t *);
extern tree build_div_expr (tree, calc_location_t *, tree, calc_location_t *);

extern tree build_assign_expr (tree, calc_location_t *, tree, calc_location_t*);
extern tree build_print_expr (location_t, int, VEC(tree,gc) *);

extern tree verify_and_convert_lhs(tree, calc_location_t*);
extern tree verify_and_convert_rhs(tree, calc_location_t*);

#endif /*_CALC_LANG_H__*/
