/* gcalc front-end language hooks and GCC middle-end interface prototypes
   Copyright (C) 2010
   Free Software Foundation, Inc.

   This file is part of GCC.

   GCC is free software; you can redistribute it and/or modify it under
   the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 3, or (at your option) any later
   version.

   GCC is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with GCC; see the file COPYING3.  If not see
   <http://www.gnu.org/licenses/>.  
*/

#ifndef _CALC_H__
#define _CALC_H__

/* Language hook prototypes */
extern void calc_finish (void);
extern bool calc_init (void);
extern void calc_init_options (unsigned int, struct cl_decoded_option *);
extern bool calc_handle_option (size_t, const char *, int, int,
			       const struct cl_option_handlers *);
extern void calc_parse_file (int);
extern bool calc_post_options (const char **);
extern unsigned int calc_option_lang_mask(void);

extern bool calc_mark_addressable (tree);
extern tree calc_type_for_size (unsigned, int);
extern tree calc_type_for_mode (enum machine_mode, int);
extern void calc_write_globals (void);

extern tree calc_pushdecl (tree);
extern void insert_block (tree);

extern tree calc_getdecls (void);
extern int calc_global_bindings_p (void);
extern void insert_block (tree);

/* The front end language hooks (addresses of code for this front
   end).  These are not really very language-dependent, i.e.
   treelang, C, Mercury, etc. can all use almost the same definitions.  */

#undef LANG_HOOKS_MARK_ADDRESSABLE
#define LANG_HOOKS_MARK_ADDRESSABLE calc_mark_addressable

#undef LANG_HOOKS_TYPE_FOR_MODE
#define LANG_HOOKS_TYPE_FOR_MODE calc_type_for_mode

#undef LANG_HOOKS_TYPE_FOR_SIZE
#define LANG_HOOKS_TYPE_FOR_SIZE calc_type_for_size

#undef LANG_HOOKS_PUSHDECL
#define LANG_HOOKS_PUSHDECL calc_pushdecl

#undef LANG_HOOKS_GLOBAL_BINDINGS_P
#define LANG_HOOKS_GLOBAL_BINDINGS_P calc_global_bindings_p

#undef LANG_HOOKS_GETDECLS
#define LANG_HOOKS_GETDECLS calc_getdecls

#undef LANG_HOOKS_PARSE_FILE
#define LANG_HOOKS_PARSE_FILE calc_parse_file

#undef LANG_HOOKS_ATTRIBUTE_TABLE
#define LANG_HOOKS_ATTRIBUTE_TABLE calc_attribute_table

#undef LANG_HOOKS_INIT
#define LANG_HOOKS_INIT sensorc_init

#undef LANG_HOOKS_NAME
#define LANG_HOOKS_NAME	"GNU Calc Frontend"

#undef LANG_HOOKS_FINISH
#define LANG_HOOKS_FINISH sensorc_finish

#undef LANG_HOOKS_INIT_OPTIONS
#define LANG_HOOKS_INIT_OPTIONS  calc_init_options

#undef LANG_HOOKS_HANDLE_OPTION
#define LANG_HOOKS_HANDLE_OPTION calc_handle_option

#undef LANG_HOOKS_WRITE_GLOBALS
#define LANG_HOOKS_WRITE_GLOBALS calc_write_globals

#undef LANG_HOOKS_POST_OPTIONS
#define LANG_HOOKS_POST_OPTIONS calc_post_options

#undef LANG_HOOKS_OPTION_LANG_MASK
#define LANG_HOOKS_OPTION_LANG_MASK calc_option_lang_mask

#endif /*_CALC_H__*/
