/* gcalc front-end language hooks and GCC middle-end interface 
   Copyright (C) 2010
   Free Software Foundation, Inc.

   This file is part of GCC.

   GCC is free software; you can redistribute it and/or modify it under
   the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 3, or (at your option) any later
   version.

   GCC is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with GCC; see the file COPYING3.  If not see
   <http://www.gnu.org/licenses/>.  
*/

#include "config.h"
#include "system.h"
#include "ansidecl.h"
#include "coretypes.h"
#include "tm.h"
#include "opts.h"
#include "tree.h"
#include "tree-iterator.h"
#include "tree-pass.h"
#include "gimple.h"
#include "toplev.h"
#include "debug.h"
#include "options.h"
#include "flags.h"
#include "convert.h"
#include "diagnostic-core.h"
#include "langhooks.h"
#include "langhooks-def.h"
#include "target.h"
#include "cgraph.h"
#include "c-family/c-pragma.h"
#include "c-family/c-objc.h"
#include "output.h"

#include <gmp.h>
#include <mpfr.h>

#include "vec.h"
#include "hashtab.h"

#include "calc1.h"
#include "calc_lang.h"

VEC(tree,gc) * global_decls_vec;

/* bison symbols */
extern FILE *calc_in;
extern int calc_parse(void);

struct GTY(()) lang_identifier 
{
  struct tree_identifier common;
};

/* Data structures required by the GCC middle-end  */

/*
union GTY((desc ("0"),
     chain_next ("(union lang_tree_node *) TREE_CHAIN (&%h.generic)")))
lang_tree_node
{
  union tree_node GTY((tag ("0"),
         desc ("tree_node_structure (&%h)"))) generic;
  int GTY((tag("1"), desc("1"))) andi;
};
*/

union GTY((desc ("0"),
	   chain_next ("(union lang_tree_node *) TREE_CHAIN (&%h.generic)")))
lang_tree_node
{
  union tree_node GTY((tag ("0"),
		       desc ("tree_node_structure (&%h)"))) generic;
};

struct GTY(()) lang_type
{
  char dummy; 
};

/* Language-specific declaration information.  */

struct GTY(()) lang_decl
{
  char dummy; 
};

struct GTY(()) language_function
{
  char dummy;
};


/* Initialization routine for the calc1 (compiler) options */
void
calc_init_options (unsigned int decoded_options_count ATTRIBUTE_UNUSED,
		   struct cl_decoded_option *decoded_options ATTRIBUTE_UNUSED)
{
  /* CL_gcalc is automatically generated by the GCC build process */
  return;
}

/* Handle specific option - called by opts.c */
bool
calc_handle_option (size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED,
		    int value ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,
		    const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED)
{
  return 1;
}

/* Initialization routine of the SENSORC front-end  */
bool
calc_init (void)
{
  location_t saved_loc;
  unsigned int i;
  static const enum tree_code stmt_codes[] = {
    CTOR_INITIALIZER,TRY_BLOCK,HANDLER,
    EH_SPEC_BLOCK,USING_STMT,TAG_DEFN,
    IF_STMT,CLEANUP_STMT,FOR_STMT,
    RANGE_FOR_STMT,WHILE_STMT,DO_STMT,
    BREAK_STMT,CONTINUE_STMT,SWITCH_STMT,
   EXPR_STMT
  };

  memset (&statement_code_p, 0, sizeof (statement_code_p));
  for (i = 0; i < ARRAY_SIZE (stmt_codes); i++)
    statement_code_p[stmt_codes[i]] = true;

  saved_loc = input_location;
  input_location = BUILTINS_LOCATION;

  init_reswords ();
  init_tree ();
  init_cp_semantics ();
  init_operators ();
  init_method ();
  init_error ();

  current_function_decl = NULL;

  class_type_node = ridpointers[(int) RID_CLASS];

  cxx_init_decl_processing ();

  if (c_common_init () == false)
    {
      input_location = saved_loc;
      return false;
    }

  init_cp_pragma ();

  init_repo ();

  input_location = saved_loc;
  return true;
}

/* Finalization routine of the GCC front-end  */
void 
calc_finish (void)
{
  /* Drop the gcalc symbol table */
  fini_sym_tbl ();
}

tree create_operation(tree class_t, tree operation )
{
 
 // set argument manually

 tree __func_param = NULL_TREE;
 tree parm_type = build_pointer_type(class_t);
 tree parm = build_decl (BUILTINS_LOCATION, PARM_DECL, get_identifier("this"), 
 parm_type);
 TREE_CONSTANT (parm) = true; 
 TREE_READONLY (parm) = true;

 //parm->andi = 0;


 DECL_CHAIN (parm) = __func_param;
 __func_param = parm;
 DECL_ARGUMENTS(operation)=(__func_param);


 // return type preparation 
 tree __func_result = build_decl(BUILTINS_LOCATION, RESULT_DECL, NULL_TREE, 
 TREE_TYPE(operation));
 DECL_CONTEXT(__func_result) = operation;
 DECL_ARTIFICIAL(__func_result) = true;
 DECL_IGNORED_P(__func_result) = true;
 DECL_RESULT(operation) = __func_result;

 // debug tree needed for bind exp 
 tree __func_art_block = build_block(NULL_TREE, NULL_TREE, NULL_TREE, NULL_TREE);
 DECL_INITIAL(operation) = __func_art_block;

 tree func_stmts = alloc_stmt_list ();

 //set the body


 tree t = TREE_TYPE(TREE_TYPE(parm));

 tree ref = build1 (INDIRECT_REF, t, parm);

 tree __struct_field0 = TYPE_FIELDS(TREE_TYPE(ref));
                 
 tree __struct_access_0 = build3(COMPONENT_REF, TREE_TYPE(__struct_field0), 
                     ref, __struct_field0, NULL_TREE);
 tree modify_att_tree = build2(MODIFY_EXPR, TREE_TYPE(__struct_field0), 
                         __struct_access_0, build_int_cst(integer_type_node, 10));

 append_to_statement_list(modify_att_tree, &func_stmts);

 /********************************add the final return statement 
                         *********************************/

 tree func_ret_expr = build1(RETURN_EXPR, void_type_node, NULL_TREE); 
                             
 append_to_statement_list(func_ret_expr, &func_stmts);


 // bind and gimplification 
 DECL_SAVED_TREE(operation) = build3(BIND_EXPR, void_type_node, NULL_TREE, 
 func_stmts, __func_art_block);

                             // pass to middle end
 gimplify_function_tree(operation);
 cgraph_node(operation);
 cgraph_finalize_function(operation,false);

 return operation;
}


/* Parsing language hook */
void
calc_parse_file (int debug_flag ATTRIBUTE_UNUSED)
{
   tree myClass_type = make_node(RECORD_TYPE);
       TYPE_PACKED(myClass_type) = false;
           TYPE_NAME(myClass_type) = get_identifier("MyClass");

           //properties:

               tree myAttribute1_type = integer_type_node;
                   tree myAttribute1_tree = build_decl(BUILTINS_LOCATION, FIELD_DECL, 
                   get_identifier("MyAttribute1"), myAttribute1_type);
                       DECL_CONTEXT(myAttribute1_tree) = myClass_type;
                           DECL_PACKED(myAttribute1_tree) = false;
                               TYPE_FIELDS(myClass_type) = myAttribute1_tree;

                               layout_type(myClass_type);
                               //operations:     

                                   tree myOperation2_type = build_function_type_list(void_type_node, 
                                   NULL_TREE);    

                                       tree myOperation2_decl = build_decl(BUILTINS_LOCATION, FUNCTION_DECL, 
                                       get_identifier("MyOperation2"), myOperation2_type);
                                           tree myOperation2_tree = create_operation(myClass_type, myOperation2_decl); 

                                           DECL_CONTEXT(myOperation2_tree) = myClass_type;
                                               //DECL_PACKED(myOperation2_tree) = false;
                                                   TYPE_METHODS(myClass_type) =  myOperation2_tree;

                                                           rest_of_type_compilation(myClass_type, 1);






  /* Open the file for reading */
  calc_in = fopen(in_fnames[0], "r");
  if (calc_in == NULL)
    error("Can't open input file %s", in_fnames[0]);

  /* Add the initial line map */
  linemap_add(line_table, LC_ENTER, 0, in_fnames[0], 1);

  /* Create the main function as base frame. gcalc doesn't
   * allow to define functions; all it knows about is a 
   * simple stream of instructions. But the gcc middle-end
   * only knows about functions, and to get a runnable executable
   * by the front-end, this main function should be called
   * 'main'
   */
  tree main_fn_type = build_function_type_list(integer_type_node, NULL_TREE);
  tree main_fn_decl = build_decl(BUILTINS_LOCATION, FUNCTION_DECL,
				 get_identifier("main"), main_fn_type);

  DECL_CONTEXT(main_fn_decl) = NULL_TREE;
  TREE_STATIC(main_fn_decl) = true;
  TREE_PUBLIC(main_fn_decl) = true;
  DECL_ARGUMENTS(main_fn_decl) = NULL_TREE;
  
  /* Define the return type (represented by RESULT_DECL) for the main functin */
  tree main_ret = build_decl(BUILTINS_LOCATION, RESULT_DECL,
			     NULL_TREE, TREE_TYPE(main_fn_type));
  DECL_CONTEXT(main_ret) = main_fn_decl;
  DECL_ARTIFICIAL(main_ret) = true;
  DECL_IGNORED_P(main_ret) = true;

  DECL_RESULT(main_fn_decl) = main_ret;

  /* This is usually used for debugging purpose. this is currently unused */
  tree main_art_block = build_block(NULL_TREE, NULL_TREE, NULL_TREE, NULL_TREE);
  DECL_INITIAL(main_fn_decl) = main_art_block;

  main_stmts = alloc_stmt_list ();
  main_block_decls = VEC_alloc (tree,gc,0);

  /* Call the bison parser */
  calc_parse ();

  /* After we finished parsing, we need to add the final return statement,
   * basically just a 'return 0'. This is not perfect because optimization
   * would then optimize away all instructions */
  tree main_set_ret = build2(MODIFY_EXPR, TREE_TYPE(main_ret),
			     main_ret, build_int_cst(integer_type_node, 0));
  TREE_USED(main_set_ret) = true;
  tree main_ret_expr = build1(RETURN_EXPR, void_type_node, main_set_ret);
  append_to_statement_list(main_ret_expr, &main_stmts);

  tree declare_vars = NULL_TREE;

  int idx; tree x = NULL_TREE;
  if (VEC_length (tree,main_block_decls) > 0)
    {
      for( idx=0; VEC_iterate(tree,main_block_decls,idx,x); ++idx )
	{
	  TREE_CHAIN( x ) = declare_vars;
	  declare_vars = x;
	}
    }
  else
    declare_vars = main_ret;

  tree bind = NULL_TREE;
	tree bl = build_block(declare_vars, NULL_TREE, main_fn_decl, NULL_TREE);
  DECL_INITIAL(main_fn_decl) = bl;
  TREE_USED(bl) = 1;

  bind = build3( BIND_EXPR, void_type_node, BLOCK_VARS(bl),
	       NULL_TREE, bl );
  TREE_SIDE_EFFECTS(bind) = 1;

  /* Finalize the main function */
  BIND_EXPR_BODY(bind) = main_stmts;
  main_stmts = bind;
  DECL_SAVED_TREE(main_fn_decl) = main_stmts;

  /* Dump out the translation unit */
  FILE *tu_stream = dump_begin (TDI_tu, NULL);
  if (tu_stream)
    {
      dump_node(main_fn_decl, 0, tu_stream);
      dump_end(TDI_tu, tu_stream);
    }

  /* Prepare the function for the GCC middle-end */
  gimplify_function_tree(main_fn_decl);
  cgraph_finalize_function(main_fn_decl, false);

  VEC_safe_push( tree, gc, global_decls_vec, main_fn_decl );

  fclose(calc_in);
}

/* Currently unused language hooks. Whenever these hooks get called, the
 * compiler (calc1) will crash with an ICE 
 */
bool
calc_mark_addressable (tree exp ATTRIBUTE_UNUSED)
{
  gcc_unreachable ();
}
  
tree
calc_type_for_size (unsigned precision ATTRIBUTE_UNUSED,
		    int unsignedp ATTRIBUTE_UNUSED)
{
  gcc_unreachable ();
}

tree
calc_type_for_mode (enum machine_mode mode ATTRIBUTE_UNUSED,
		    int unsignedp ATTRIBUTE_UNUSED)
{
  gcc_unreachable ();
}

tree
calc_pushdecl (tree decl ATTRIBUTE_UNUSED)
{
  gcc_unreachable ();
}

int
calc_global_bindings_p (void)
{
  gcc_unreachable ();
}

void
insert_block (tree block ATTRIBUTE_UNUSED)
{
  gcc_unreachable ();
}

void
calc_write_globals (void)
{
  int idx, idy=0, len= VEC_length(tree,global_decls_vec);
  tree itx = NULL_TREE;
  tree * vec = XNEWVEC( tree, len );

  for( idx=0; VEC_iterate(tree,global_decls_vec,idx,itx); ++idx )
    {
      vec[ idy ] = itx;
      idy++;
    }

  wrapup_global_declarations( vec, len );
  
  check_global_declarations( vec, len );
  emit_debug_global_declarations( vec, len );

  cgraph_finalize_compilation_unit( );

  free( vec );
}

tree
convert (tree type ATTRIBUTE_UNUSED, tree expr ATTRIBUTE_UNUSED)
{
  return NULL;
}

/* The language hook getdecls is determined to return a 
 * list (chained via TREE_LIST) of global declarations.
 * This is for example called by write_global_declarations 
 * which is a default language hook
 */
tree
calc_getdecls (void)
{
  tree global_decls = NULL_TREE;

  /* There might be better implementations of this, but the purpose
   * of this is to show the interface of the GCC/libiberty hash table.
   * htab_traverse runs through the entries of the hash table and calls
   * back the function 'calc_htab_trav' which itsself chains the
   * global declarations using the global_decls
   */
  htab_traverse(calc_sym_table, calc_htab_trav, &global_decls);

  return global_decls;
}


/* The language hooks gets called whenever all options and arguments are
 * parsed/read in the by options sub-component. This might be used for
 * further validation checks 
 *
 * If this function returns NOT 0, the middle-end/back-end of GCC WON'T
 * be called (this is for example used to emit pre-processing code only in
 * the C/C++ front-end)
 */
bool
calc_post_options (const char **argv ATTRIBUTE_UNUSED)
{
  flag_excess_precision_cmdline = EXCESS_PRECISION_FAST;

  if (num_in_fnames != 1)
    warning(0, "Multiple input file names. Only file %s will be parsed.", in_fnames[0]);

  return 0;
}

/* This language hook gets called in decode_options to determine the front-end language mask. 
 * It should return the corresponding CL_*, in this case CL_GCALC.
 */
unsigned int
calc_option_lang_mask(void)
{
  return CL_gcalc;
}

/* The attribute table might be used for the GCC attribute syntax, e.g.
 * __attribute__((unused)), but this feature isn't yet used in gcalc
 */ 
const struct attribute_spec calc_attribute_table[] =
{
  { NULL, 0, 0, false, false, false, NULL }
};

/* The language hooks data structure. This is the main interface between the GCC front-end
 * and the GCC middle-end/back-end. A list of language hooks could be found in
 * <gcc>/langhooks.h
 */
struct lang_hooks lang_hooks = LANG_HOOKS_INITIALIZER;

#include "debug.h" 
#include "gt-gcalc-calc1.h"
#include "gtype-gcalc.h"
