#include "gimple.h"
#include "cgraph.h"
#include "bitmap.h"
#define ONLY_BT4 false
#define USE_LIST_NODE true
enum bootstrap_mode {CALLEE_OFF_CALLER_OFF = 1, CALLEE_ON_CALLER_OFF = 2, CALLEE_OFF_CALLER_ON = 3, CALLEE_ON_CALLER_ON = 4};
enum answerby {ANDERSON = 0, BOOTSTRAP1 = 1, BOOTSTRAP2 = 2, BOOTSTRAP3 = 3, BOOTSTRAP4 = 4};
typedef enum {SCALAR, DEREF, ADDRESSOF} constraint_expr_type;
enum alias_result {MUST_NOT_ALIAS, MUST_ALIAS, MAY_ALIAS};
typedef struct cgraph_node *cgraph_node_t;
DEF_VEC_P(cgraph_node_t);
DEF_VEC_ALLOC_P(cgraph_node_t,heap);

/* Static IDs for the special variables.  */
enum { nothing_id = 0, anything_id = 1, readonly_id = 2,
       escaped_id = 3, nonlocal_id = 4,
       storedanything_id = 5, integer_id = 6 };

/* Use 0x8000... as special unknown offset.  */
#define UNKNOWN_OFFSET ((HOST_WIDE_INT)-1 << (HOST_BITS_PER_WIDE_INT-1))

/* In IPA mode there are varinfos for different aspects of reach
   function designator.  One for the points-to set of the return
   value, one for the variables that are clobbered by the function,
   one for its uses and one for each parameter (including a single
   glob for remaining variadic arguments).  */
enum func_var { fi_clobbers = 1, fi_uses = 2,
       fi_static_chain = 3, fi_result = 4, fi_parm_base = 5 };

struct CheckPoint {
	struct cgraph_node *node;
	gimple_stmt_iterator gsi;
//	gimple stmt;
	unsigned int id;
};

struct CheckPointTest {
	struct cgraph_node *node;
	gimple_stmt_iterator gsi;
	unsigned int id;
};

struct CheckAmongVar {
	int num;
	struct CheckPoint *p;
	enum alias_result **answer;
};

struct CheckPairVar {
	int num;
	struct CheckPoint *p1;
	struct CheckPoint *p2;
	enum alias_result *answer;
};

struct TraceVar {
	struct cgraph_node *node;
	gimple stmt;
	gimple_stmt_iterator gsi;
	unsigned int id;
	bitmap workVar;
	bitmap UpdatedTo;
	//unsigned int mustAlias;
	struct CheckPoint mustAlias;
	int mustPointsTo;
	bool mustAliasFlag;
	bool weakUpdateFlag;
	bool unknownFlag;
	unsigned int level;
    VEC(gimple, heap) *list_node;
};

/* An expression that appears in a constraint.  */
struct constraint_expr {
  /* Constraint type.  */
  constraint_expr_type type;

  /* Variable we are referring to in the constraint.  */
  unsigned int var;

  /* Offset, in bits, of this constraint from the beginning of
     variables it ends up referring to.

     IOW, in a deref constraint, we would deref, get the result set,
     then add OFFSET to each member.   */
  HOST_WIDE_INT offset;
};

/* Our set constraints are made up of two constraint expressions, one
   LHS, and one RHS.

   As described in the introduction, our set constraints each represent an
   operation between set valued variables.
*/
struct constraint
{
  struct constraint_expr lhs;
  struct constraint_expr rhs;
};

struct bootstrap_varinfo{
  /* Name of this variable */
  const char *name;
  /* Points-to set for this variable.  */
  bitmap solution;
};
/*
typedef struct constraint *constraint_t;

#ifndef DEF_VEC_CONSTRAINT_T
#define DEF_VEC_CONSTRAINT_T
DEF_VEC_P(constraint_t);
DEF_VEC_ALLOC_P(constraint_t,heap);
#endif
*/

struct variable_info
{
  /* ID of this variable  */
  unsigned int id;

  /* True if this is a variable created by the constraint analysis, such as
     heap variables and constraints we had to break up.  */
  unsigned int is_artificial_var : 1;

  /* True if this is a special variable whose solution set should not be
     changed.  */
  unsigned int is_special_var : 1;

  /* True for variables whose size is not known or variable.  */
  unsigned int is_unknown_size_var : 1;

  /* True for (sub-)fields that represent a whole variable.  */
  unsigned int is_full_var : 1;

  /* True if this is a heap variable.  */
  unsigned int is_heap_var : 1;

  /* True if this is a variable tracking a restrict pointer source.  */
  unsigned int is_restrict_var : 1;

  /* True if this field may contain pointers.  */
  unsigned int may_have_pointers : 1;

  /* True if this field has only restrict qualified pointers.  */
  unsigned int only_restrict_pointers : 1;

  /* True if this represents a global variable.  */
  unsigned int is_global_var : 1;

  /* True if this represents a IPA function info.  */
  unsigned int is_fn_info : 1;

  /* A link to the variable for the next field in this structure.  */
  struct variable_info *next;

  /* Offset of this variable, in bits, from the base variable  */
  unsigned HOST_WIDE_INT offset;

  /* Size of the variable, in bits.  */
  unsigned HOST_WIDE_INT size;

  /* Full size of the base variable, in bits.  */
  unsigned HOST_WIDE_INT fullsize;

  /* Name of this variable */
  const char *name;

  /* Tree that this variable is associated with.  */
  tree decl;

  /* Points-to set for this variable.  */
  bitmap solution;

  /* Old points-to set for this variable.  */
  bitmap oldsolution;
};

typedef struct variable_info *varinfo_t;


#ifndef DEF_VEC_VARINFO_T
#define DEF_VEC_VARINFO_T
DEF_VEC_P(varinfo_t);
DEF_VEC_ALLOC_P(varinfo_t, heap);
#endif

#define EXECUTE_IF_IN_NONNULL_BITMAP(a, b, c, d)    \
  if (a)                        \
    EXECUTE_IF_SET_IN_BITMAP (a, b, c, d)

#define TB_prepare(A, B)			\
  typedef A B;					\
  typedef A *B##_t;		


#define TB_eq(STRUCT, EQ_FUNC)				\
  static int						\
  trans_eq_##STRUCT(const void *p1, const void *p2){	\
    const STRUCT *ve1 = (const STRUCT *) p1;		\
    const STRUCT *ve2 = (const STRUCT *) p2;		\
    return EQ_FUNC(ve1, ve2);				\
  }

#define TB_hash(STRUCT, HASH)				\
  static hashval_t					\
  trans_hash_##STRUCT (const void *p) {			\
    const STRUCT *ve = (const STRUCT *) p;		\
    return htab_hash_pointer ((void *) ve->HASH);	\
  }

#define TB_lookup(STRUCT)					\
  static inline STRUCT *					\
  lookup_##STRUCT(STRUCT *p) {					\
    void **slot;						\
    slot = htab_find_slot (Tab_##STRUCT, p, NO_INSERT);		\
    if (!slot)							\
      return NULL;						\
    return ((STRUCT *)*slot);					\
  }

#define TB_alloc(STRUCT)					\
  static inline STRUCT *					\
  alloc_##STRUCT(STRUCT *p) {					\
    void **slot;						\
    STRUCT *var;						\
    var = lookup_##STRUCT(p);					\
    if(var == NULL){						\
      var = XNEW(STRUCT);					\
      *var = *p;						\
      slot = htab_find_slot (Tab_##STRUCT, var, INSERT);	\
      VEC_safe_push(STRUCT##_t, heap, LIST_##STRUCT, var);	\
      *slot = var;						\
    }else{							\
      *var = *p;						\
    }								\
    return var;							\
  }			

#define TB_declare(STRUCT)			\
htab_t Tab_##STRUCT = NULL;	                \		
DEF_VEC_P(STRUCT##_t);				\
DEF_VEC_ALLOC_P(STRUCT##_t,heap);		\
VEC(STRUCT##_t, heap) *LIST_##STRUCT = NULL;

#define TB_create(STRUCT)						\
  if(!Tab_##STRUCT)							\
    Tab_##STRUCT = htab_create (0, trans_hash_##STRUCT, trans_eq_##STRUCT, NULL);

#define TB_free(STRUCT)							\
  if(Tab_##STRUCT){							\
    int i;								\
    STRUCT##_t var;							\
    for (i = 0; VEC_iterate(STRUCT##_t, LIST_##STRUCT, i, var); i++){	\
      free(var);							\
    }									\
    VEC_free(STRUCT##_t, heap, LIST_##STRUCT);				\
    LIST_##STRUCT = NULL;						\
    htab_delete (Tab_##STRUCT);						\
    Tab_##STRUCT = NULL;						\
  }

#define TB_define(STRUCT, EQ_FUNC, HASH)			\
  TB_declare(STRUCT)						\
  TB_eq(STRUCT, EQ_FUNC)					\
  TB_hash(STRUCT, HASH)						\
  TB_lookup(STRUCT)						\
  TB_alloc(STRUCT)


struct pta_statistics{
	unsigned int may_alias;
	unsigned int must_alias;
	unsigned int must_not_alias;
	unsigned int anderson;
	unsigned int bootstrap_cnt[5];
	
}; 
extern struct pta_statistics statistics;

extern struct constraint *all_constraints;
extern int constraints_cnt;
extern struct bootstrap_varinfo *bsvars;
extern unsigned int var_range;
extern long timer[5];
extern unsigned int cnt[5];
extern bool bootstrap_flag;

extern void dump_bitmap_var(FILE *file, bitmap bmap); 
extern const char *get_pta_name(unsigned int id);
extern bitmap get_pta_solution(unsigned int id);
extern enum answerby ipa_pta_pair_bootstrapping (struct CheckPairVar * pairs, int memop1, int memop2);
extern struct variable_info *lookup_vi_for_tree (tree);

extern struct variable_info *first_vi_for_offset (struct variable_info *, unsigned HOST_WIDE_INT);
inline varinfo_t get_varinfo (unsigned int n);
extern void print_tree_code(FILE *file, tree node);
extern int varcnt;
