
#ifndef __CTHREAD
#define __CTHREAD
#include <vector>
#include <string>
#include <pthread.h>
#include <string>
#include <iostream>

using namespace std;

#define CPUNUM  1


class CTask
{
protected:
  void *m_ptrData;		// the data to be processed by task
public:
    virtual int Run () = 0;

  virtual void print_task () = 0;
};



typedef
  std::list <
CTask * >
  TASK_POOL;

/** 
  worker thread
**/
class Thread
{
private:
  TASK_POOL     m_vecTaskList;
  TASK_POOL     m_vecWorkingList;
  pthread_mutex_t     m_pthreadMutex;		// lock for task list 
  pthread_spinlock_t  m_spinlock;

  static void *  Run (void *threadData);	// thread body 

public:

  int
    add_count;
  int
    do_count;
  bool
    no_lock;

  Thread ():
  m_vecTaskList (),
  m_vecWorkingList ()
  {
    add_count = 0;
    do_count = 0;
    no_lock = false;
    pthread_mutex_init (&m_pthreadMutex, NULL);
    pthread_spin_init (&m_spinlock, 0);
    pthread_t *
      tid = new pthread_t;
    pthread_create (tid, NULL, Run, this);
  }

  void
  AddTask (CTask * task)
  {
    pthread_spin_lock (&m_spinlock);
    m_vecTaskList.push_back (task);
    pthread_spin_unlock (&m_spinlock);
    ++add_count;
  }

  int
  Task_size () const;
  bool
  Task_empty () const
  {
    return
      m_vecTaskList.
    empty ();
  }
};


int
Thread::Task_size () const 
{
  return m_vecTaskList.size ();
}


void *
Thread::Run (void *threadData)
{
  pthread_t tid = pthread_self ();
  TASK_POOL & taskList = ((Thread *) threadData)->m_vecTaskList;
  TASK_POOL & workingList = ((Thread *) threadData)->m_vecWorkingList;
  pthread_mutex_t & pthreadMutex = ((Thread *) threadData)->m_pthreadMutex;	// lock for task list 
  pthread_spinlock_t & spinlock = ((Thread *) threadData)->m_spinlock;;
  int &count1 = ((Thread *) threadData)->do_count;
  int &count2 = ((Thread *) threadData)->add_count;
  bool & not_lock = ((Thread *) threadData)->no_lock;

  while (1)
    {

      //get task      
      if (!taskList.empty ())
	{
	  pthread_spin_lock (&spinlock);
	  workingList.splice (workingList.end (), taskList);
	  pthread_spin_unlock (&spinlock);
	}

      TASK_POOL::iterator iter = workingList.begin ();
      while (iter != workingList.end ())
	{
	  CTask *task = *iter;
	  task->Run ();
	  iter = workingList.erase (iter);
	  delete task;
	  ++count1;
	}

    }
  return (void *) 0;
}





#endif
