
//#define SHADOW_PROFILING 1

#define ID_BIT_WIDTH   32
#define SHADOW_PROFILING_SHADOW_LENGTH  20 

struct ushort_struct
{
 	unsigned short int data;
	char info[SHADOW_PROFILING_SHADOW_LENGTH];
};

struct char_p_struct
{
 	char *data;
	char info[SHADOW_PROFILING_SHADOW_LENGTH] ;
};

struct char_pp_struct
{	
	struct char_p_struct *data;
	char info[SHADOW_PROFILING_SHADOW_LENGTH];
};


/* /usr/include/ctype.h
 These are defined in ctype-info.c.
 66    The declarations here must match those in localeinfo.h.
 67 
 68    In the thread-specific locale model (see `uselocale' in <locale.h>)
 69    we cannot use global variables for these as was done in the past.
 70    Instead, the following accessor functions return the address of
 71    each variable, which is local to the current thread if multithreaded.
 72 
 73    These point into arrays of 384, so they can be indexed by any `unsigned
 74    char' value [0,255]; by EOF (-1); or by any `signed char' value
 75    [-128,-1).  ISO C requires that the ctype functions work for `unsigned
 76    char' values and for EOF; we also support negative `signed char' values
 77    for broken old programs.  The case conversion arrays are of `int's
 78    rather than `unsigned char's because tolower (EOF) must be EOF, which
 79    doesn't fit into an `unsigned char'.  But today more important is that
 80    the arrays are also used for multi-byte character sets.  */

extern "C" const unsigned short int **__ctype_b_loc (void) __THROW __attribute__ ((const));

static ushort_struct __ctype_b_loc_array[384];
static const ushort_struct *__ctype_b_loc_base = __ctype_b_loc_array;
static bool __ctype_b_loc_initialized = false;

static void __ctype_b_loc_initialize()
{
	const unsigned short int *tmp = *__ctype_b_loc();
	for ( int i=0; i<384; i++)
	{
		__ctype_b_loc_array[i].data = tmp[i];
		for ( int j=0; j<SHADOW_PROFILING_SHADOW_LENGTH; j++)
			__ctype_b_loc_array[i].info[j] = 0;
	}
		
	__ctype_b_loc_initialized = true;

}

extern "C" const ushort_struct** __ctype_b_loc_wrapper (void)
{
	if ( !__ctype_b_loc_initialized )
		__ctype_b_loc_initialize();
	return &__ctype_b_loc_base;	
}



#ifdef SHADOW_PROFILING
extern "C" 	int exec_main(int argc, struct char_p_struct *argv);
int main(int argc,char **argv)
{
	char_pp_struct tmpargv;
	tmpargv.data = (struct char_p_struct *)calloc(argc, sizeof(struct char_p_struct));
	for (int i=0; i<argc; i++)
		tmpargv.data[i].data = argv[i];

	exec_main(argc, tmpargv.data);
}
#endif


