#include "libprofile.h"

#include <boost/icl/interval.hpp>
#include <boost/icl/interval_set.hpp>
#include "bitvector.cxx"


std::set<int> privatizable_set;
std::set<int> non_privatizable_set;
SPARSE_BV       non_privatizable_set2;  


using namespace boost::icl;

typedef  interval_set<PTR> INTERVAL_TREE;
INTERVAL_TREE  interval_tree;


/*structured for storing currently open loops and its iteration numbers */
class   LOOP
{
public:
  int     loop_id;
  INTERVAL_TREE  interval_tree;

	
  LOOP (int id) :
    loop_id(id)
	 { } 

};



static std::vector<LOOP> stack;




// interval_map<time, guests> party; 

/* addr - address;
   size - the bit size of memory to be accessed
   flag - read/write, if address read (0) or written (1) ; 
   id - memory operation id or slice id; */

extern "C" void
__privatize_print_store (PTR addr, int size, int id)
{

  interval<char*>::type range = interval<char*>::closed(addr, addr+size-1);
  interval_tree.insert(range);
}


extern "C" void
__privatize_print_load (PTR addr, int size, int id)
{
 
  interval<char*>::type range = interval<char*>::closed(addr, addr+size-1);
  if (interval_tree.find(range) == interval_tree.end() )
  {
    // report not-privatizable
    non_privatizable_set.insert(id);
  }
}





/* entry-loop enter/exit; loc - loop global id; s-
*/

extern "C" void
__privatize_print_entry (int loop_id)
{
  return;
  interval_tree.clear();
}






/* entry-loop enter/exit; loc - loop global id; s-
*/

extern "C" void
__privatize_print_exit (int loop_id)
{
  //stack.pop_back();
}







extern "C" void
__privatize_profile_finalize (void)
{

  generate_memory_op_table ("loopmemop.info");

  for (MEMOP_INFO_HASH::iterator iter = mem_info_hash.begin ();
       iter != mem_info_hash.end (); ++iter)
  {
    MEMORY_OPERATION_INFO *info = iter->second;
    if (info->read)
    {
      if (non_privatizable_set.find(info->id) == non_privatizable_set.end())
        privatizable_set.insert(info->id);
    }

  }

  FILE *fp = fopen("privatize.info", "w");
  for ( std::set<int>::iterator iter = privatizable_set.begin(); iter != privatizable_set.end(); ++iter)
    fprintf( fp, "MEMOP %d is privatizable\n", *iter );

  fclose(fp);
  
}

