
// A pair-wise dependence profiler

#include "libprofile.h"



static struct dep_hash_entry *hashdep=NULL;

/* Record dependence a depends on b */
void 
pairwise_record_dependence( const DEPENDENCY &new_dep )
{
	if (new_dep.type() == dep_RAR )
		return;

	struct dep_hash_entry *entry;

	HASH_FIND_INT (hashdep, &(new_dep._a), entry );

	if (entry) 
	{
		DEPENDENCY_VEC &dep_set = entry->dependencies;
		if ( !dep_set.Find(new_dep) )
		{
			new_dep.print(depname);
			dep_set.push_back(new_dep);
		}			
	}
	else
	{	
		entry = new dep_hash_entry;
		entry->memop_id= new_dep.a();
		entry->dependencies.push_back (new_dep);
		HASH_ADD_INT (hashdep, memop_id, entry );	
		new_dep.print(depname);
	}
}


static void
pairwise_check_dependence(lentry *loop, MEMORY_OPERATION_LIST &stmts, MEMORY_OPERATION &new_stmt)
{

	MEMORY_OPERATION &succ = new_stmt;

	for (MEMORY_OPERATION_LIST::reverse_iterator iter1 = stmts.rbegin(); iter1 != stmts.rend(); ++iter1 )
	{
		MEMORY_OPERATION &pred = *iter1;

		/* record dependence */
		enum dep_type type;
		
		if ( pred.rwflag() == 1 && succ.rwflag() == 0 )
			type = dep_RAW;
		
		else if ( pred.rwflag() == 0 && succ.rwflag() == 1 )
			type = dep_WAR;
		
		else if ( pred.rwflag() == 1 && succ.rwflag() == 1 )
			type = dep_WAW; 

		else
			type = dep_RAR; 
			

		enum dep_kind kind;
		
		if ( pred.iterno() == succ.iterno() )	/* loop-independent */
			kind = LOOP_INDEPENDENT;
		else
			kind = LOOP_CARRIED;
		
    DEPENDENCY new_dep (succ.id (), pred.id (), kind, type, loop->loop_id);
		pairwise_record_dependence ( new_dep );

		if (kind == LOOP_INDEPENDENT && type == dep_RAW )
			return;
		
	}
}



void pairwise_address_hash_insert(lentry *loop, PTR addr, MEMORY_OPERATION &stmt)
{


	/* hash into address table */

	struct pair_hash_entry *s;

	HASH_FIND_PTR(loop->pair_hash, &addr,s);

	if (s) 
	{
		MEMORY_OPERATION_LIST	&stmts = s->memops;
		/* check dependence */
		pairwise_check_dependence (loop, stmts, stmt );
		stmts.push_back (stmt);
	}
	else
	{
		s = new pair_hash_entry;
		s->addr = addr;
		MEMORY_OPERATION_LIST	&stmts = s->memops;
		stmts.push_back (stmt);
		HASH_ADD_PTR(loop->pair_hash, addr, s ); 	
	}	
}



/* 	addr 	- address;
		size	- the bit size of memory to be accessed
		flag	-	read/write, if address read (0) or written (1) ; 
		id		- memory operation id or slice id;
*/
extern "C"
void __pairwise_print_address  (PTR   addr, 
														int		size,
														char 	flag,  
														int 	id)
{

	if ( !initialized ) 
		profile_initialize();

	if ( Top()->kind == pk_not_profile )
		return ;

	/*	perform hash operation and check dependence */
	MEMORY_OPERATION 	memop(id, Top()->iter_no, flag );
	pairwise_address_hash_insert ( Top(), addr, memop);

}


void pairwise_address_hash_insert(lentry *loop, PTR addr, MEMORY_OPERATION_LIST	 &new_stmts)
{


	/* hash into address table */
	
	struct pair_hash_entry *s;

	HASH_FIND_PTR(loop->pair_hash, &addr,s);

	if(s) 
	{
		MEMORY_OPERATION_LIST	&stmts = s->memops;
		for (MEMORY_OPERATION_LIST::iterator iter = new_stmts.begin(); iter != new_stmts.end(); ++iter )
		{
			MEMORY_OPERATION &stmt = *iter;
			/* check dependence */
  		pairwise_check_dependence (loop, stmts, stmt );
		}	
		
		stmts.insert (stmts.end(), new_stmts.begin(), new_stmts.end());
	}
	else
	{
		s = new pair_hash_entry;
		s->addr = addr;
		MEMORY_OPERATION_LIST	&stmts = s->memops;
		stmts.assign (new_stmts.begin(), new_stmts.end());
		HASH_ADD_PTR(loop->pair_hash, addr, s ); 	
	}

}



void pairwise_transfer_addr_hash(lentry *father, lentry *loop, pair_hash_entry *iter)
{
	PTR addr = iter->addr;
	MEMORY_OPERATION_LIST &stmts = iter->memops;
	MEMORY_OPERATION_LIST new_stmts;
	MEMORY_OPERATION_LIST::iterator siter = stmts.begin();
	while ( siter != stmts.end() )
	{
		siter->set_iterno(father->iter_no);
		new_stmts.push_back (*siter);
		++siter;
	}
	
	pairwise_address_hash_insert ( father, addr, new_stmts);		
}



static void pairwise_transfer_loop(lentry *father, lentry *loop ) 
{

	/* Transfer address hash table */
	struct pair_hash_entry *child_addr_hash = loop->pair_hash; 
	struct pair_hash_entry *iter;

	for ( iter = child_addr_hash; iter != NULL; iter = (pair_hash_entry*)(iter->hh.next)) 
	{	
		pairwise_transfer_addr_hash ( father, loop, iter);
	}

}


static void clear_pairwise_hash(lentry *loop) 
{

	struct pair_hash_entry *cur_addr=NULL;
	struct pair_hash_entry *hashaddr=loop->pair_hash;

  while (hashaddr) 
	{
    cur_addr = hashaddr;         /* copy pointer to first item     */
		cur_addr->memops.clear();
    HASH_DEL (hashaddr, cur_addr); /* delete; hashaddr advances to next */
    delete cur_addr;          
  }
}

static void
pairwise_clear_loop (lentry * loop)
{
  clear_pairwise_hash (loop);
}


/*entry-loop enter/exit; loc - loop global id; s -  */
extern "C" void
__pairwise_print_edge (int loop_id,	/* The global loop id */
          	      int entry		/* 1- loop entry , 0- loop exit */
                  )
{
  if (!initialized)
    profile_initialize ();

  if (entry)
  {
    if (loop_stack_capacity <= Length ())
    {
      loop_stack_capacity = (loop_stack_capacity << 1) - 1;
      loop_stack = (lentry **) realloc (loop_stack, sizeof (lentry*) * loop_stack_capacity);
    }

    if (Empty () || Top ()->loop_id != loop_id)
    {

      lentry *loop = new lentry;
      loop->loop_id = loop_id;
      loop->iter_no = 1;

      if (Empty ())
      {
        if (not_profile_loops.find (loop_id) !=   	  not_profile_loops.end ())
        	loop->kind = pk_not_profile;

        stmt_count = 0;
        ave_dep_num = 0;
        fprintf (fp,
  	       "\n\n\n ======================== Entering LOOP NEST %d==========================\n",
  	       loop_id);
      }
      else
      {
        if (Top ()->kind == pk_not_profile)
        	loop->kind = pk_not_profile;
        else if (not_profile_loops.find (loop_id) != not_profile_loops.end ())
      	{
      	  if (Top ()->kind == pk_not_profile)
      	    loop->kind = pk_not_profile;
      	  else
      	    loop->kind = pk_profile;	// profile but not need checking dependence                                             
      	}
      }

      Push (loop);
    }
    else
    {
      Top ()->iter_no++;
    }
  }
  else
  {

    lentry *loop = Top ();

    if (loop->loop_id == loop_id)
  	{
      // loop_infos[loop_id].itercount += loop->iter_no;

  	  /* transfer hash table */
  	  if (Length () > 1)
  	    pairwise_transfer_loop (Elem (Length () - 1), loop);

  	  pairwise_clear_loop (loop);
  	  Pop ();


  	  if (0 && Empty ())
	    {

	      fprintf (fp,
		       "\n ========================Exiting of LOOP NEST %d==========================\n",
		       loop_id);
	      fprintf (fp, "max_dep_num = %d\n", max_dep_num);
	      fprintf (fp, "ave_dep_num = %d\n", ave_dep_num);
	      fprintf (fp, "addr count = %lld\n", addr_count);
	      fprintf (fp, "stmt count = %lld\n", stmt_count);


	      fprintf (fp, "profile_count=%lld\n", profile_count);
	      fprintf (fp, "time for print range is : %7.4f sec\n",
		       Time_Profile[0] / (double) clktck);
	      fprintf (fp, "time for insert_and_merge is : %7.4f sec\n",
		       Time_Profile[1] / (double) clktck);
	      fprintf (fp, "time for transfer loop is : %7.4f sec\n",
		       Time_Profile[2] / (double) clktck);
	      fprintf (fp, "time for check dependence is : %7.4f sec\n",
		       Time_Profile[3] / (double) clktck);
	    }
  	}
  }

}



extern "C" void
__pairwise_print_exit ()
{
  print_dependencies ();
}

