


#ifndef mempool_INCLUDED
#define mempool_INCLUDED



struct MEM_POOL_BLOCK
{
	char	*ptr;
	MEM_POOL_BLOCK	*prev;
	MEM_POOL_BLOCK	*next;
	size_t  size;
};

#define MEM_BLOCK_OVERHEAD sizeof(MEM_POOL_BLOCK)


struct MEM_POOL
{
  MEM_POOL_BLOCK  *block;          /* Current top of allocation
                                     * stack.  This changes when the
                                     * pool is pushed or popped.
                                     */

	MEM_POOL() 
	{ 	
		block = new MEM_POOL_BLOCK;
		block->prev = NULL;
		block->next = NULL;
	}
																	 
																		 
	 
	~MEM_POOL( )
	{
		 while (block)
		 {
			 MEM_POOL_BLOCK* next = block->next;
			 free(block);
			 block = next;
		 }
	 }
																		 
};



#define MEM_STAT_ARGS(line,file) ,INT32 line, const char *file




void*
MEM_POOL_malloc(  MEM_POOL *mempool,  size_t  size)
{
	char *p = (char*) malloc(size + MEM_BLOCK_OVERHEAD);
	memset(p, 0, size + MEM_BLOCK_OVERHEAD);
	MEM_POOL_BLOCK *block = (MEM_POOL_BLOCK*)p;
	block->ptr =  p + MEM_BLOCK_OVERHEAD;
	block->prev = NULL;
	block->next = mempool->block;
	block->size = size;
	mempool->block->prev = block;
	mempool->block = block;	
	return block->ptr;
}


void*
MEM_POOL_calloc( MEM_POOL *mempool,  size_t num, size_t size )
{
	char *p = (char*) malloc(num*size + MEM_BLOCK_OVERHEAD);
	memset(p, 0, num*size + MEM_BLOCK_OVERHEAD);
	MEM_POOL_BLOCK *block = (MEM_POOL_BLOCK*)p;
	block->ptr =  p + MEM_BLOCK_OVERHEAD;
	block->prev = NULL;
	block->next = mempool->block;
	block->size = num*size;
	mempool->block->prev = block;
	mempool->block = block;	
	return block->ptr;	
}


void*
MEM_POOL_realloc(MEM_POOL *mempool,  void *ptr, size_t  new_size)
{
  MEM_POOL_BLOCK *block = (MEM_POOL_BLOCK*)((char *)ptr - MEM_BLOCK_OVERHEAD);
  assert(block->ptr == ptr); 

	size_t old_size = block->size;

	if ( old_size >= new_size )
		return ptr;
	
  MEM_POOL_BLOCK *new_block = (MEM_POOL_BLOCK *)realloc(block, new_size + MEM_BLOCK_OVERHEAD);
  
  new_block->ptr = (char *)new_block + MEM_BLOCK_OVERHEAD;	
	memset (new_block->ptr + old_size, 0, new_size - old_size);

	if (new_block->prev)
		new_block->prev->next = new_block;
	if (new_block->next)
		new_block->next->prev = new_block;
	new_block->size = new_size;

	if (mempool->block == block)
		mempool->block = new_block;
	
  return new_block->ptr;
}


void
MEM_POOL_free( MEM_POOL *mempool,  void *ptr)
{
	if (!ptr)
		return;
  MEM_POOL_BLOCK *block = (MEM_POOL_BLOCK*)((char *)ptr - MEM_BLOCK_OVERHEAD);
  assert(block->ptr == ptr); 
	if (mempool->block == block)
		mempool->block = block->next;
	if (block->prev)
		block->prev->next = block->next;
	if (block->next)
		block->next->prev = block->prev;
	free(block);
}






#endif /* mempool_INCLUDED */

