
#include "libprofile.h"
#include <tr1/unordered_set>

/* Instruction count profiling */  

#define COUNTINFO "count.info"
#define HEAVYLOOPRAW "heavyloop.raw"

struct COUNT_INFO
{
  long long instruction_count;  // instruction count;
  long long address_count;  // memory accessed count
};

typedef  std::tr1::unordered_map < int, COUNT_INFO > MEMOP_COUNT_HASH;
typedef  std::tr1::unordered_set < PTR > ALIAS_CLASS_ADDR_HASH;

MEMOP_COUNT_HASH  memop_count_hash;
ALIAS_CLASS_ADDR_HASH memop_addr_hash;

static int count_memop_num=0;

typedef unsigned long long UINT64;
typedef long double FLOAT128;
static FLOAT128 *count_memop_vec = NULL;

static unsigned long long count_memop_iterno=0;
/* 	 
		id		- memory operation id or slice id;
*/ 
extern  "C"   
void __count_memop_print_memop (int class_id) 
{
  if ( count_memop_iterno )
    count_memop_vec[class_id] += 1.0/100000;
}


extern "C" void
__count_memop_print_entry (int loop_id)
{
  count_memop_iterno++;

}

#include "libdefs.h"

extern "C" void
__count_memop_print_exit (int loop_id)
{
  count_memop_iterno = 0;
}


extern "C" void
__count_memop_initialize (int mem_num)
{
  count_memop_num = mem_num +1;
  count_memop_vec = new FLOAT128[count_memop_num];
}



extern "C" void
__count_memop_finalize ()
{
 
  FILE * fp = fopen (COUNTINFO, "w");

  for (int i=1; i < count_memop_num ; i++)
  {
    fprintf (fp, "CLASS %d   COUNT %Lf\n", i, count_memop_vec[i]);
  }

  fclose(fp);

  delete count_memop_vec;
}

/*structured for storing currently open loops and its iteration numbers */
class   COUNT_LOOP
{
public:
  int        loop_id;  
  FLOAT128     execution_count;  // how many times the loop is executed
  FLOAT128     iteration_count;  // The total iteration number of all executions 
  FLOAT128     instruction_count;  // The total load/store number of all executions 
  FLOAT128     current_instruction_count;   // instruction count in current execution instance

	
  COUNT_LOOP () :
    loop_id(0),
    execution_count(0),
    iteration_count(0),
    instruction_count(0),
    current_instruction_count(0)
	 { } 
    
  COUNT_LOOP (int id) :
      loop_id(id),
    execution_count(0),
    iteration_count(0),
    instruction_count(0),
    current_instruction_count(0)
	 { } 

};

static int count_loop_num;

static std::vector<COUNT_LOOP*> count_loop_stack;
static COUNT_LOOP* count_loop_vec;
static COUNT_LOOP* count_current_loop;

/* entry-loop enter/exit; loc - loop global id; s-
*/

extern "C" void
__count_loop_print_entry (int loop_id)
{
  if (count_current_loop->loop_id != loop_id)
  {
    count_loop_stack.push_back(&count_loop_vec[loop_id]);
    count_current_loop = count_loop_stack.back();
    count_current_loop->execution_count++;
    count_current_loop->iteration_count++;    
    count_current_loop->current_instruction_count = 0;
  }
  else
  {
    count_current_loop->iteration_count++;
  }

}

#include "libdefs.h"

extern "C" void
__count_loop_print_exit (int loop_id)
{
  if ( count_current_loop->loop_id == loop_id )
  { 
    // accumulate to loop info
    int inst_num = count_current_loop->current_instruction_count;    
    count_current_loop->current_instruction_count = 0;
    count_current_loop->instruction_count += inst_num;
    count_loop_stack.pop_back();
    count_current_loop = count_loop_stack.back(); 
    count_current_loop->current_instruction_count += inst_num;
  }
}


/* 	 
		id		- memory operation id or slice id;
*/ 
extern  "C"   
void __count_loop_print_instruction () 
{
  count_current_loop->current_instruction_count += 1.0/100000;
}



extern "C" void
__count_loop_initialize (int loop_num)
{
  count_loop_num = loop_num +1;
  count_loop_vec = new COUNT_LOOP[count_loop_num];

  for (int i=0; i < count_loop_num; i++)
    count_loop_vec[i].loop_id = i;

  count_loop_stack.push_back( &count_loop_vec[0] );
  count_current_loop = count_loop_stack.back();
}


extern "C" void
__count_loop_finalize ()
{

  
  FILE *fp = fopen(HEAVYLOOPRAW, "w");

  fprintf(fp, "INDEPENDENT\n");
  for (int i=1; i < count_loop_num; i++)
  {
    fprintf(fp, "LOOP %d   EXECUTION %Lf   ITERATION %Lf   INSTRUCTION %Lf\n", i, count_loop_vec[i].execution_count, 
                count_loop_vec[i].iteration_count, count_loop_vec[i].instruction_count);
  }

  fclose(fp);

  delete count_loop_vec;
}


