

#include "libprofile.h"
/* Alias profiling */  
const char *aliasname = "alias.info";
  
// the same key means overlapping
// map block the latest memory operation accessed this block
typedef  std::map <MEMORY_BLOCK, int >  ALIAS_BLOCK_MAP;
typedef	 std::pair < int, int >   ALIAS_PAIR;
typedef  std::set < ALIAS_PAIR >  ALIAS_SET;

typedef  std::tr1::unordered_map < unsigned long long, int > AILAS_ADDRESS_HASH;

typedef  std::tr1::unordered_map < int, MEMORY_BLOCK > MEMOP_ALIAS_HASH;

AILAS_ADDRESS_HASH	alias_address_hash;
ALIAS_BLOCK_MAP alias_block_map;
ALIAS_SET alias_set;

MEMOP_ALIAS_HASH  memop_alias_hash;

    
static int max_block_size = 0;
static int hash_span = 1;


int compute_bit_number( unsigned long long n )
{
  int i = 0;
  while ( n != 0 )
  {
    n = n >> 1;
    i++;
  }

  return i;
}

static void
alias_profile_initialize (void)
{

  initialized = 1;
  loop_stack_capacity = SIZE - 1;
  loop_stack = (lentry **) malloc (sizeof (lentry) * loop_stack_capacity);
  loop_stack[0] = new lentry;
  loop_stack[0]->kind = pk_not_profile;

}


/* 	addr 	- address;
		size	- the byte size of memory malloced
		flag	-	0 -- malloc ; 1 -- realloc;	2 -- free
*/

extern "C" void
__alias_print_malloc (PTR old_addr, PTR new_addr, int size, int flag)
{

  if (!initialized)
    alias_profile_initialize ();

  switch (flag)
  {
    case 0:			// malloc
    {
      MEMORY_BLOCK block (new_addr, new_addr + size - 1, 0);
      alias_block_map[block] = 0;
      if ( max_block_size < size )
      {
        max_block_size = size;
        hash_span = compute_bit_number (max_block_size);
      }
      break;
    }

    case 1:			// realloc
    {
      MEMORY_BLOCK old_block (old_addr, old_addr, 0);
      alias_block_map.erase (old_block);
      MEMORY_BLOCK new_block (new_addr, new_addr + size - 1, 0);
      alias_block_map[new_block] = 0;
      if ( max_block_size < size )
      {
        max_block_size = size;
        hash_span = compute_bit_number (max_block_size);
      }
      break;
    }

    case 2:			// free
    {
      MEMORY_BLOCK old_block (old_addr, old_addr, 0);
      alias_block_map.erase (old_block);
      break;
    }

    default:
      assert (false);
      break;
  }

}


   
/* 	addr 	- address;
		size	- the bit size of memory to be accessed
		flag	-	read/write, if address read (0) or written (1) ; 
		id		- memory operation id or slice id;
		inv   - variant loops. -1 means must profiled, 0 means profile only once
		iter  - last iteration number		
*/ 
extern  "C"   
void __alias_print_address (PTR addr, int memop) 
{

  MEMORY_BLOCK &block = memop_alias_hash[memop];

  if (block.low==0 && block.high == 0)
  {
    block.low = addr;
    block.high = addr;  
  }
  else if ( block.low > addr )
    block.low = addr;
  else if ( block.high < addr )
    block.high = addr;  
}


extern "C"
void __alias_print_exit () 
{
  FILE * aliasfp = fopen (aliasname, "w");
  for (MEMOP_ALIAS_HASH::iterator iter = memop_alias_hash.begin (); iter != memop_alias_hash.end (); ++iter)
    fprintf (aliasfp, "MEMOP %d   [%lld  %lld]\n", iter->first, iter->second.low, iter->second.high);
  fclose (aliasfp);
}

 
 
 
 
 
 /*entry-loop enter/exit; loc - loop global id; s -  */
 extern "C" void
 __alias_print_edge (int loop_id,  /* The global loop id */
                          int entry   /* 1- loop entry , 0- loop exit */
                         )
 {
   if (!initialized)
     alias_profile_initialize ();
 
   if (entry)
   {
     if (loop_stack_capacity <= Length ())
     {
       loop_stack_capacity = (loop_stack_capacity << 1) - 1;
       loop_stack = (lentry **) realloc (loop_stack, sizeof (lentry) * loop_stack_capacity);
     }

     if (Empty () || Top ()->loop_id != loop_id)
     {

       lentry *loop = new lentry;
       loop->loop_id = loop_id;
       loop->iter_no = 1;
       Push (loop);
     }
     else
     {
       Top ()->iter_no++;
     }
   }
   else
   {

     lentry *loop = Top ();
     if (loop->loop_id == loop_id)
     {
       Pop ();         
     }
   }
 
 }
 
