/*
 * Copyright 2003, 2004, 2005, 2006 PathScale, Inc.  All Rights Reserved.
 */

/*

  Copyright (C) 2000, 2001 Silicon Graphics, Inc.  All Rights Reserved.

  This program is free software; you can redistribute it and/or modify it
  under the terms of version 2 of the GNU General Public License as
  published by the Free Software Foundation.

  This program is distributed in the hope that it would be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

  Further, this software is distributed without any warranty that it is
  free of the rightful claim of any third person regarding infringement 
  or the like.  Any license provided herein, whether implied or 
  otherwise, applies only to this software file.  Patent licenses, if 
  any, provided herein do not apply to combinations of this program with 
  other software, or any other product whatsoever.  

  You should have received a copy of the GNU General Public License along
  with this program; if not, write the Free Software Foundation, Inc., 59
  Temple Place - Suite 330, Boston MA 02111-1307, USA.

  Contact information:  Silicon Graphics, Inc., 1600 Amphitheatre Pky,
  Mountain View, CA 94043, or:

  http://www.sgi.com

  For further information regarding this notice, see:

  http://oss.sgi.com/projects/GenInfo/NoticeExplan

*/


#include "bitvector.h"

void
SPARSE_BV::Set_Bit (UINT32 index)
{
  if (buffer == NULL) {
  	buffer = new SPARSE_BV_BUFFER;
	  data = new SPARSE_BV_DATA;
	  data->push_back (0LL);		// reserve 0th entry
  }

  if (index >= buffer->size () * mUINT64_BIT) {
    INT n = ((index + mUINT64_BIT) / mUINT64_BIT) - buffer->size ();
    buffer->insert (buffer->end (), n, 0);
  }

  UINT32 idx = index / mUINT64_BIT;

//    Is_True (idx < buffer->size (), ("Bit vector index out of range"));
    
  if ((*buffer)[idx] == 0 ) {
	(*buffer)[idx] = data->size();
	data->push_back (1LL << (index % mUINT64_BIT));
    } else 
	(*data)[(*buffer)[idx]] |= 1LL << (index % mUINT64_BIT);

} // SPARSE_BV::Set_Bit


void
SPARSE_BV::Union_2_Core (const SPARSE_BV& vec, BUFFER_ITER vec_iter,
			 BUFFER_ITER iter)
{
    while (vec_iter != vec.buffer->end ()) {
	//Is_True (iter != buffer->end (), ("bit vector buffer too short"));

	if (*vec_iter != 0) {
	    if (*iter == 0) {
		// copy over this entry
		*iter = data->size ();
		data->push_back ((*vec.data)[*vec_iter]);
	    } else {
		(*data)[*iter] |= (*vec.data)[*vec_iter];
	    }
	}

	++vec_iter;
	++iter;
    }

} // Union_2_Core


void
SPARSE_BV::Union_2 (const SPARSE_BV& vec)
{
    if (vec.buffer == NULL)
	return;

    if (buffer == NULL) {
	buffer = new SPARSE_BV_BUFFER;
	buffer->reserve (vec.buffer->size ());
	data = new SPARSE_BV_DATA;
	data->reserve (vec.data->size ());
	data->push_back (0LL);
    }

    // check if need to extend the vector at the end
    if (vec.buffer->size () > buffer->size ()) {
	buffer->insert (buffer->end (),
			vec.buffer->size() - buffer->size (), 0);
    }
    
    Union_2_Core (vec, vec.buffer->begin (), buffer->begin ());
    
} // Union_2


BOOL
SPARSE_BV::Union_2_Diff_Core (const SPARSE_BV& vec)
{
    BOOL modified = FALSE;

    // check if need to extend the vector at the end
    if (vec.buffer->size () > buffer->size ()) {
	buffer->insert (buffer->end (),
			vec.buffer->size() - buffer->size (), 0);
	modified = TRUE;
    }

    BUFFER_ITER vec_iter (vec.buffer->begin ());
    BUFFER_ITER iter (buffer->begin ());
    
    if (!modified) {
	// check for differences before modifying the vector
	
	while (!modified && vec_iter != vec.buffer->end ()) {
	    if (*vec_iter != 0) {
		if (*iter == 0) {
		    modified = TRUE;
		    break;
		}
		mUINT64& data_word = (*data)[*iter];
		mUINT64 xword = data_word | (*vec.data)[*vec_iter];
		if (xword != data_word) {
		    modified = TRUE;
		    data_word = xword;
		}
	    }

	    ++vec_iter;
	    ++iter;
	}

    }

    if (modified)
	Union_2_Core (vec, vec_iter, iter);

    return modified;
    
} // Union_2_Diff_Core

// Modified by cmchen 2009-06-08

// Compare two BVs, return true if they are equal, otherwise return false
BOOL
SPARSE_BV::BV_Equal (const SPARSE_BV& vec)
{

   if(buffer==NULL && vec.buffer==NULL)
   	return TRUE;
   if(buffer==NULL || vec.buffer==NULL)
   	return FALSE;

    // check if need to extend the vector at the end
    if (vec.buffer->size () != buffer->size ()) {
	return FALSE;
    }

    BUFFER_ITER vec_iter (vec.buffer->begin ());
    BUFFER_ITER iter (buffer->begin ());
    
	
	while (iter!=buffer->end()) {
	    Is_True (vec_iter != vec.buffer->end (),
		     ("Inconsisten bit vector comparison"));
	    if (*vec_iter != 0) {
		if (*iter == 0) {
			return FALSE;
		}
		mUINT64& data_word = (*data)[*iter];
		mUINT64 xword = (*vec.data)[*vec_iter];		
		if (xword != data_word) {
		    return FALSE;
		}
	    }

	    ++vec_iter;
	    ++iter;
	}

    return TRUE;
} // Union_2_Diff_Core


// if a bit is set, then unset it
void
SPARSE_BV::Unset(UINT32 index)
{
	UINT32 idx;
	idx=index /mUINT64_BIT;
//	Is_True( idx<(buffer->size()) , ("Unset index over flow!"));
	if( idx<(buffer->size()) )
		(*data)[(*buffer)[idx]] &= ~(1LL<<(index%mUINT64_BIT));
}

 //if vec has some same elements with this one
BOOL 
SPARSE_BV::Has_Common_Set(const SPARSE_BV& vec)
{
		if(buffer==NULL || vec.buffer==NULL)
			return FALSE;
		
		BUFFER_ITER iter(buffer->begin());
		BUFFER_ITER vec_iter(vec.buffer->begin());
		mUINT64 xword;
		
		while(iter!=buffer->end() || vec_iter!=vec.buffer->end()){
			if(*iter!=0 && *vec_iter!=0)
			{
				xword=0;
				xword=(*data)[*iter] & (*vec.data)[*vec_iter];
				if(xword)
					return TRUE;
			}
			iter++;
			vec_iter++;
		}
}

// Get the compare intersec set of two BVs:  A = B ^ ~C
// The process is just like Intersec_2(), but the temple result will be stored in the new bv: A 
// In this situation, we make sure that elements in B is more than which in C
SPARSE_BV* 
SPARSE_BV::Intersec_and_Comp(const SPARSE_BV& bv)       
{
	SPARSE_BV* new_bv=new SPARSE_BV(*this);

	if(bv.buffer==NULL){
		new_bv->Union_2(*this);
	}else{
	
		BUFFER_ITER iter(buffer->begin());
		BUFFER_ITER vec_iter(bv.buffer->begin());
		BUFFER_ITER new_iter(new_bv->buffer->begin());
		
		mUINT64 xword;
		while(vec_iter!=bv.buffer->end()){

			if(*iter==0 || *vec_iter==0){
				*new_iter=*iter;
				if(*iter!=0)
					(*(new_bv->data))[*new_iter]=(*data)[*iter];
			}else{
				xword = 0;
				xword = (*data)[*iter] & ~((*bv.data)[*vec_iter]);
				(*(new_bv->data))[*new_iter]=xword;
			}
			
			iter++;
			vec_iter++;
			new_iter++;
		}
		
		while(iter!=buffer->end()){
			*new_iter=*iter;
			(*(new_bv->data))[*new_iter] = (*data)[*iter];
			new_iter++;
			iter++;
		}
	}
	return new_bv;
}

// how many elements in this vec
UINT32
SPARSE_BV::BV_size()
{
		if(buffer==NULL)
			return 0;

		UINT32 total=0;
		UINT32 indx;
		
  		BUFFER_ITER iter(buffer->begin ());
		while(iter!=buffer->end()){
			if(*iter!=0){
				mUINT64 data_long=(*data)[*iter];
				mUINT64 data_test;
				indx=0;
				for(; indx<64; indx++){
					data_test=0;
					data_test=data_long & (1LL<<indx);
					if(data_test)
						total++;
				}
			}
		iter++;
		}
	return total;
}

// clear all the contents in current SPARSE_BV
void SPARSE_BV::BV_clear()
{
	if(buffer==NULL)
		return;

	delete buffer;
	delete data;
  buffer == NULL;
  data == NULL;
}


   // Dump BV to a specified file fp
 void 
 SPARSE_BV::Dump_BV(FILE* fp)
 {
 	if(!buffer)
		return;
	
	BUFFER_ITER iter(buffer->begin());
	UINT indx=0, buffer_indx=0;
	mUINT64 data_long, data_test;

	fprintf(fp, "sparse bv elements:	");
	while(iter!=buffer->end()){
		if(*iter!=0){
			data_long=(*data)[*iter];
			for(indx=0; indx<64; indx++){
				data_test=0;
				data_test = data_long & (1LL<<indx);
				if(data_test)
					fprintf(fp, "%d    ", (buffer_indx*mUINT64_BIT + indx) );
			}
		}
		iter++;
		buffer_indx++;
	}
	fprintf(fp, "\n");

 }

// Put all the elements in SPARSE_BV  to std::vector
void 
SPARSE_BV::Trans_BV_To_Vec(std::vector<UINT32> &vec )
{
	if(!buffer)
		return;
	
	BUFFER_ITER iter(buffer->begin());
	UINT indx=0, buffer_indx=0;
	mUINT64 data_long, data_test;

	while(iter!=buffer->end()){
		if(*iter!=0){
			data_long=(*data)[*iter];
			for(indx=0; indx<64; indx++){
				data_test=0;
				data_test = data_long & (1LL<<indx);
				if(data_test){
					vec.push_back((buffer_indx*mUINT64_BIT + indx));
				}
			}
		}
		iter++;
		buffer_indx++;
	}
}

// end 2009-06-08


