

#include "ipa-check-dependence.h"

extern "C" 
{
  void dump_struct_declaration_c(FILE *dumpfile);  
}

static FILE *dumpfile;

#define INDENT(SPACE)							\
  do { int i; for (i = 0; i < SPACE; i++) pp_space (buffer); } while (0)

static pretty_printer buffer;

static void source_to_c_init_dump()
{
  char outputfile[100];
  if (input_filename)
  {
    strcpy(outputfile,input_filename);
    strcat(outputfile, "_source.c");
  }
  else
  {
    outputfile[0]=0;
    strcat(outputfile, "c_source.c");
  }    
  
  dumpfile = fopen(outputfile,"w");

  
}

#define SOURCE_TO_C 0
#if SOURCE_TO_C
static bool initialized = false;

static void
maybe_init_pretty_print (FILE *file)
{
  if (!initialized)
    {
      pp_construct (&buffer, /* prefix */NULL, /* line-width */0);
      pp_needs_newline (&buffer) = true;
      pp_translate_identifiers (&buffer) = false;
      initialized = 1;
    }

  buffer.buffer->stream = file;
}


static void
print_necessary_local_decls(FILE *file, cgraph_node_ptr node)
{

}

class source_c_scope
{


};


static std::vector<basic_block> scope_stack;

static std::map<basic_block, bool> printed_out;
static std::map<basic_block, tree> bb_label;

static bool
is_do_while_loop_header (basic_block bb)
{
  if (bb == (bb->loop_father)->header)
    return true;
  gcc_checking_assert (EDGE_COUNT (bb->preds) == 1);
  return false;
}



/* Dump the gimple conditional GS.  BUFFER, SPC and FLAGS are as in
   dump_gimple_stmt_c.  */

static void
source_c_dump_gimple_cond (pretty_printer *buffer, gimple gs, int indent)
{
  INDENT (indent)
	pp_string (buffer, "if (");
  dump_generic_node_c (buffer, gimple_cond_lhs (gs), 0, 0, false);
  pp_space (buffer);
  pp_string (buffer, op_symbol_code (gimple_cond_code (gs)));
  pp_space (buffer);
  dump_generic_node_c (buffer, gimple_cond_rhs (gs), 0, 0, false);	  
  pp_character (buffer, ')');
}



/* Dump the gimple assignment GS.  BUFFER, SPC and FLAGS are as in
   dump_gimple_stmt_c.  */

static void
source_c_dump_gimple_assign (pretty_printer *buffer, gimple gs, int indent)
{
 
  INDENT (indent)
  dump_generic_node_c (buffer, gimple_assign_lhs (gs), 0, 0, false);
  pp_space (buffer);
  pp_character (buffer, '=');
  
  if (gimple_assign_nontemporal_move_p (gs))
    pp_string (buffer, "{nt}");
  
  if (gimple_has_volatile_ops (gs))
    pp_string (buffer, "{v}");
  
  pp_space (buffer);
  
  if (gimple_num_ops (gs) == 2)
    dump_unary_rhs (buffer, gs, 0, 0);
  else if (gimple_num_ops (gs) == 3)
    dump_binary_rhs (buffer, gs, 0, 0);
  else if (gimple_num_ops (gs) == 4)
    dump_ternary_rhs (buffer, gs, 0, 0);
  else
    gcc_unreachable ();
	pp_semicolon (buffer);
    
}



/* Dump the call statement GS.  BUFFER, SPC and FLAGS are as in
   dump_gimple_stmt_c.  */

static void
source_c_dump_gimple_call (pretty_printer *buffer, gimple gs, int indent)
{

  INDENT (indent)

  tree lhs = gimple_call_lhs (gs);

  dump_generic_node_c (buffer, lhs, 0, 0, false);
  pp_string (buffer, " =");
  if (gimple_has_volatile_ops (gs))
    pp_string (buffer, "{v}");
  
  pp_space (buffer);
  print_call_name_c (buffer, gimple_call_fn (gs), 0, 0);
  pp_string (buffer, " (");
  dump_gimple_call_args (buffer, gs, 0);
  pp_character (buffer, ')');
	pp_semicolon (buffer);

}


/* Dump the return statement GS.  BUFFER, SPC and FLAGS are as in
   dump_gimple_stmt.  */

static void
source_c_dump_gimple_return (pretty_printer *buffer, gimple gs, int indent)
{
  tree t;

  t = gimple_return_retval (gs);

  
  INDENT (indent)
  pp_string (buffer, "return");
  if (t)
	{
	  pp_space (buffer);
	  dump_generic_node (buffer, t, 0, 0, false);
	}
  pp_semicolon (buffer);
}


/* Dump a GIMPLE_LABEL tuple on the pretty_printer BUFFER, SPC
   spaces of indent.  FLAGS specifies details to show in the dump (see
   TDF_* in tree-pass.h).  */

static void
source_c_dump_gimple_label (pretty_printer *buffer, gimple gs, int indent)
{
  tree label = gimple_label_label (gs); 
  dump_generic_node_c (buffer, label, 0, 0, false);
  pp_string (buffer, ":\n");
}


/* Dump a GIMPLE_GOTO tuple on the pretty_printer BUFFER, SPC
   spaces of indent.  FLAGS specifies details to show in the dump (see
   TDF_* in tree-pass.h).  */

static void
source_c_dump_gimple_goto (pretty_printer *buffer, gimple gs, int indent)
{
  tree label = gimple_goto_dest (gs);
  INDENT (indent)
  dump_gimple_fmt (buffer, 0, 0, "goto %T;", label);
}



/**********************/
/* Dumps basic block BB to buffer BUFFER with details described by FLAGS and
   indented by INDENT spaces.  */

static void
source_c_dump_bb_buff (pretty_printer *buffer, basic_block bb, int indent)
{
  gimple_stmt_iterator gsi;
  gimple stmt,tempstmt;
  int flag = 0;
  int label_indent = indent - 2;
  enum gimple_code stmt_code;

  
  for (gsi = gsi_start_bb (bb); !gsi_end_p (gsi); gsi_next (&gsi))
  {   

    stmt = gsi_stmt (gsi);     
    stmt_code = gimple_code(stmt);

    switch (stmt_code)
    {
    
      case GIMPLE_ASSIGN:
        source_c_dump_gimple_assign (buffer, stmt, indent);
        break;    
    
      case GIMPLE_CALL:
        source_c_dump_gimple_call (buffer, stmt, indent);
        break;
    
      case GIMPLE_COND:
        source_c_dump_gimple_cond (buffer, stmt, indent);
        break;
    
      case GIMPLE_LABEL:
        source_c_dump_gimple_label (buffer, stmt, indent);
        break;
    
      case GIMPLE_GOTO:
        source_c_dump_gimple_goto (buffer, stmt, indent);
        break;
        
      case GIMPLE_RETURN:
        source_c_dump_gimple_return (buffer, stmt, indent);
        break;
    
   
      default:
        break;
      }

    
    
    pp_newline(buffer);
  }


}



static void
print_loop_header(basic_block bb, FILE *file, int indent)
{

}


// Do not print the last goto statement
static void
print_basic_block(basic_block bb, FILE *file, int indent)
{


  if ( is_loop_header_bb_p(bb) )
  {
    print_loop_header (bb, file, indent);
    return ;
  }


  
  maybe_init_pretty_print (file);
  source_c_dump_bb_buff (&buffer, bb, indent);
  pp_flush (&buffer);

  

  printed_out[bb] = true;

}

static bool
in_the_same_scope(basic_block bb1, basic_block bb2)
{
  return dominated_by_p(CDI_DOMINATORS, bb1, bb2) && dominated_by_p(CDI_POST_DOMINATORS, bb2, bb1) || 
         dominated_by_p(CDI_DOMINATORS, bb2, bb1) && dominated_by_p(CDI_POST_DOMINATORS, bb1, bb2);
}


/* Print a scope started (dominated) by bb */ 
static void
print_scope(FILE *file, basic_block bb, int indent)
{

  if (!bb)
    return;

  print_basic_block (bb, file, indent);


  gimple_stmt_iterator gsi = gsi_last_bb (bb);
  gimple stmt = gsi_stmt (gsi);


  // if (OP1 COND_CODE OP2) goto TRUE_LABEL else goto FALSE_LABEL
  if (stmt && gimple_code (stmt) == GIMPLE_COND) 
  {
    edge true_edge, false_edge;
    extract_true_false_edges_from_block (bb, &true_edge, &false_edge);    
    basic_block then_bb = true_edge->dest;
    basic_block else_bb = false_edge->dest;
    
    // print then_bb
    {
      scope_stack.push_back(then_bb);
      print_indents (dumpfile, indent);
      fprintf(dumpfile,"{\n");      
      print_scope (then_bb, file, indent+2);
      print_indents (dumpfile, indent);
      fprintf(dumpfile,"}\n");
    }

    
    if ( !is_loop_header_bb_p(bb) )
    {
      // print else_bb    
      scope_stack.push_back(then_bb);
      print_indents (dumpfile, indent);
      fprintf(dumpfile,"else {\n");      
      print_scope (then_bb, file, indent+2);
      print_indents (dumpfile, indent);
      fprintf(dumpfile,"}\n");
    }

    // loop exit node must post-dominate loop header    
  }

  else if (stmt && gimple_code (stmt) == GIMPLE_GOTO) 
  {
    gcc_assert (single_succ_p (bb));
    basic_block succ = single_succ (bb);
    {
      // print goto       
      INDENT (indent);
      dump_gimple_statement(buffer, stmt);
      pp_flush (&buffer);
    }
  }

  else
  {
    gcc_assert (single_succ_p (bb));
    basic_block succ = single_succ (bb);
    if ( in_the_same_scope (bb, succ) )        
      print_scope (succ, file, indent);
  }
  

 
  basic_block ipdom = get_immediate_dominator (CDI_POST_DOMINATORS, bb);

  while ( !dominated_by_p(CDI_DOMINATORS, ipdom, bb) )
    ipdom = get_immediate_dominator (CDI_POST_DOMINATORS, bb);

  print_scope (ipdom, file, indent);

}


static void
print_function_body(FILE *file, cgraph_node_ptr node, int indent)
{

  calculate_dominance_info (CDI_POST_DOMINATORS);

  scope_stack.clear();
  printed_out.clear();

  basic_block root = ENTRY_BLOCK_PTR;

  
  scope_stack.push_back(root);
  print_scope (file, root, indent + 2);  

  print_indents (dumpfile, indent);
  fprintf(dumpfile,"}\n\n");
}


void
print_function(FILE *file, cgraph_node_ptr node)
{
  if (!valid_function_node_p (node))
    return;

  maybe_init_pretty_print (dumpfile);


}

void
debug_function(cgraph_node_ptr node)
{
  print_function (STDERR, node);
}

#endif 

unsigned int
source_to_c()
{

  struct cgraph_node *node;
  struct cgraph_node *node_end;

  printedtypelist = NULL;
  source_to_c_init_dump();
  
  /* dump type declarations: struct,union */
  dump_struct_declaration_c(dumpfile);
  /* dump the global variables*/
  dump_varpool_c(dumpfile);


  struct cgraph_node **order = XCNEWVEC (struct cgraph_node *, cgraph_n_nodes);
  int order_pos = ipa_utils_reduced_inorder (order, false, true, NULL);
  for (int i = order_pos -1; i >= 0 ; i--)
  {
    struct cgraph_node *node = order[i];
    if (!valid_function_node_p (node))
      continue;
  
    switch_to_context (node->decl);

    dump_function_decl_c(node->decl, dumpfile);

    /* Print function header (declaration) */
    
    //print_function_header_c (dumpfile, node->decl, 0);

    /* Decide which delaration of local variables to be printed */
    //print_necessary_local_decls (dumpfile, node); 
    
    pre_check_bb_edge(node->decl, dumpfile);
    basic_block bb;
    FOR_EACH_BB (bb)
      //dump_bb_new(bb);
      gimple_dump_bb_c(bb,dumpfile,2,0);
    fprintf(dumpfile,"}\n\n");

    switch_off_context();
  
  }



  fclose(dumpfile);

  
  /* Cleanup. */
  for (struct cgraph_node *node = cgraph_nodes; node; node = node->next)
  {
    /* Get rid of the aux information.      */
    if (node->aux)
    {
      free (node->aux);
      node->aux = NULL;
    }
  }

  return 0;
}



static bool
gate_source_to_c (void)
{
  return flag_source_to_c ;
}


struct simple_ipa_opt_pass pass_source_to_c = 
{
  {
    SIMPLE_IPA_PASS,
    "source-to-c",  /* name */
    gate_source_to_c,  /* gate */
    source_to_c, /* execute */
    NULL,     /* sub */
    NULL,     /* next */
    0,        /* static_pass_number */
    TV_TREE_PROFILE_DEPENDENCE, /* tv_id */
    PROP_ssa,     /* properties_required */
    0,        /* properties_provided */
    0,        /* properties_destroyed */
    0,        /* todo_flags_start */
    0         /* todo_flags_finish */
  }
};
  

