
#include <tr1/unordered_set>
#include <tr1/unordered_map>
#include "ipa-check-dependence.h"
#include <string>


static const char *memop_memop_profiler_name = "__count_memop_print_memop";
static const char *memop_begin_profiler_name = "__count_memop_initialize";
static const char *memop_end_profiler_name = "__count_memop_finalize";
static const char *memop_enter_profiler_name = "__count_memop_print_entry";
static const char *memop_exit_profiler_name = "__count_memop_print_exit";


static const char *loop_stmt_profiler_name = "__count_loop_print_instruction";
static const char *loop_begin_profiler_name = "__count_loop_initialize";
static const char *loop_end_profiler_name = "__count_loop_finalize";
static const char *loop_enter_profiler_name = "__count_loop_print_entry";
static const char *loop_exit_profiler_name = "__count_loop_print_exit";

static GTY (()) tree memop_memop_profiler_fn_type;
static GTY (()) tree memop_enter_profiler_fn_type;
static GTY (()) tree memop_exit_profiler_fn_type;
static GTY (()) tree memop_begin_profiler_fn_type;
static GTY (()) tree memop_end_profiler_fn_type;

static GTY (()) tree loop_stmt_profiler_fn_type;
static GTY (()) tree loop_enter_profiler_fn_type;
static GTY (()) tree loop_exit_profiler_fn_type;
static GTY (()) tree loop_begin_profiler_fn_type;
static GTY (()) tree loop_end_profiler_fn_type;


void  read_count_information()
{
  FILE *fp = fopen ("count.info", "r");

  if (!fp)
    return ;

  char *line = NULL;
  size_t len = 0;
  int bytes_read;
  int a;
  long long b;
  long long c;
  char str[100];

  // CLASS 1  COUNT 50  ADDRESS 80
  while ((bytes_read = getline (&line, &len, fp)) != -1)
  {
    sscanf (line, "%s", str);
    if (strcmp (str, "CLASS") == 0)
    {
      sscanf (line, "%*s %d %*s %lld %*s %lld", &a, &b, &c); 
      ALIAS_CLASS_INFO &count = alias_class_map[a];
      count.instruction_count = b;
      count.address_count = c;
      
    }
  }




  fclose (fp);
}

int
compute_invalid (void **slot, void *data )
{

  dr_hash_entry *dr_entry = *(dr_hash_entry **) slot;
  std::tr1::unordered_set < int >  *memop_hash = (std::tr1::unordered_set<int>*) data;
  ipa_data_reference *dr = dr_entry->dr;

  if ( memop_hash->find(dr->uid()) == memop_hash->end() )
    dr->set_invalid();
  
  return 1;
}

int
compute_invalid_bb (void **slot, void *data )
{

  dr_hash_entry *dr_entry = *(dr_hash_entry **) slot;
  ipa_data_reference *dr = dr_entry->dr;

  basic_block  bb = gimple_bb (DR_STMT(dr) );

  if ( bb_invalid(bb) )
    dr->set_invalid();
  
  return 1;
}

extern "C" void remove_bb (basic_block);
extern "C" bool bb_invalid_c(basic_block bb)
{
  return bb_invalid(bb);
}

extern "C" bool valid_function_node_p_c(cgraph_node_ptr node)
{
  return valid_function_node_p(node);
}

void  read_count_infor_and_remove_bb()
{

  std::tr1::unordered_set < int >  bb_hash;  // executed

  FILE *countfp = fopen ("count.info", "r");

  if (!countfp)
    return;
  { 
    char *line = NULL;
    size_t len = 0;
    int bytes_read;
    int a;
    long double b;
    char str[100];

    // CLASS 1  COUNT 50  ADDRESS 80
    while ((bytes_read = getline (&line, &len, countfp)) != -1)
    {
      sscanf (line, "%s", str);
      if (strcmp (str, "CLASS") == 0)
      {
        sscanf (line, "%*s %d %*s %Lf", &a, &b); 
        ALIAS_CLASS_INFO &count = alias_class_map[a];
        count.instruction_count = b;
      }
    }
    
    fclose (countfp);
  }

  /* remove bb */
  struct cgraph_node *node;
  basic_block bb;

  for (node = cgraph_nodes; node; node = node->next)
  {
    if ( !valid_function_node_p(node) )
      continue;
    switch_to_context (node->decl);
    FOR_EACH_BB (bb)
    {    
      gimple_seq seq = bb_seq (bb);
      if ( gimple_seq_empty_p(seq) )
        continue;      
      if ( alias_class_map[bb_uid(bb)].instruction_count <= 0 )
      {
        bb_set_invalid(bb);        
      }      
      else
      {
        set_bb_count(bb, alias_class_map[bb_uid(bb)].instruction_count);
      }
    }
    switch_off_context ();
  }

  alias_class_map.clear();
}


void  read_count_infor_and_invalidate_dr()
{
  FILE *fp = fopen ("count.info", "r");

  if (!fp)
    return ;

  char *line = NULL;
  size_t len = 0;
  int bytes_read;
  int a;
  long long b;
  long long c;
  char str[100];
  std::tr1::unordered_set < int >  memop_hash;  // executed

  // CLASS 1  COUNT 50  ADDRESS 80
  while ((bytes_read = getline (&line, &len, fp)) != -1)
  {
    sscanf (line, "%s", str);
    if (strcmp (str, "CLASS") == 0)
    {
      sscanf (line, "%*s %d %*s %lld %*s %lld", &a, &b, &c); 
      ALIAS_CLASS_INFO &count = alias_class_map[a];
      count.instruction_count = b;
      count.address_count = c;
      
      if (b>0)
        memop_hash.insert(a);
            
    }
  }


	htab_traverse (dr_hash, compute_invalid, &memop_hash);


  fclose (fp);
}

  
/*
	see also in libcount.cxx

  void __count_print_address	(PTR addr, int class_id) ;
	void __count_print_exit();
*/ 
static void initialize_profile_prototype () 
{

  memop_memop_profiler_fn_type = build_function_type_list (void_type_node, 
                              integer_type_node,  /* int memop_id */
                              NULL_TREE);


  memop_enter_profiler_fn_type = build_function_type_list (void_type_node, 
            						        integer_type_node,	/* int loop_id */
            						        NULL_TREE);

  memop_exit_profiler_fn_type = build_function_type_list (void_type_node, 
            						        integer_type_node,	/* int loop_id */
            						        NULL_TREE);

  memop_begin_profiler_fn_type = build_function_type_list (void_type_node, 
                              integer_type_node,  /* int memop_num */
                              NULL_TREE);

  memop_end_profiler_fn_type = build_function_type_list ( void_type_node,  NULL_TREE);


  loop_stmt_profiler_fn_type = build_function_type_list ( void_type_node,  NULL_TREE);

  loop_enter_profiler_fn_type = build_function_type_list (void_type_node, 
            						        integer_type_node,	/* int loop_id */
            						        NULL_TREE);
  
  loop_exit_profiler_fn_type = build_function_type_list (void_type_node, 
            						        integer_type_node,	/* int loop_id */
            						        NULL_TREE);

  loop_begin_profiler_fn_type = build_function_type_list (void_type_node, 
                              integer_type_node,  /* int loop_num */
                              NULL_TREE);

  loop_end_profiler_fn_type = build_function_type_list ( void_type_node,  NULL_TREE);
  
}




const char *filename(tree decl)
{
 return DECL_SOURCE_FILE (decl);
}


using namespace std;
static set<string> library_functions;



void
find_library_calls(FILE *fp)
{

  for (cgraph_node_ptr node = cgraph_nodes; node; node = node->next)      
  {
    if (!valid_function_node_p (node))
     continue;

      
    switch_to_context (node->decl);

    string filename = ExtractFilename( DECL_SOURCE_FILE (node->decl));
    if ( is_profiling_library(filename.c_str()) )
    {
      switch_off_context ();
      continue;     
    }

    basic_block bb;
    FOR_EACH_BB (bb)
    {

      gimple_seq seq = bb_seq (bb);
      for (gimple_stmt_iterator gsi = gsi_start_bb (bb); !gsi_end_p (gsi); gsi_next (&gsi))
      {

        int flag;
        tree size;
        tree old_addr;
        tree new_addr;
        gimple stmt = gsi_stmt (gsi);

        switch (gimple_code (stmt))
        {

          case GIMPLE_CALL: 
          {
            /* the arguments are to be profiled!!! */
            tree decl = gimple_call_fndecl (stmt);

            if (decl)
          	{
              const char* name = fn_decl_name (decl);
              
              if ( !gimple_has_body_p (decl) && !is_replaced_function(name) )
              {
                if ( library_functions.find(name) == library_functions.end() )
                {
                  library_functions.insert(name);   
                  if (fp)
                  {
                    fprintf(fp, "call to ");
                    print_generic_expr (fp, decl, 0);
                    fprintf(fp, "  ");
                    print_generic_expr (fp, TREE_TYPE(decl), 0);                
                    fprintf (fp, "\n In FILE %s    FUNCTION %s    LINE %d  \n\n",
                                   DECL_SOURCE_FILE (node->decl),
                                   lang_hooks.decl_printable_name (node->decl, 2),
                                   gimple_lineno (stmt) );
                  }
                }
                

              }
              
               

          	}


            break;

          }

        default:
          break;
        }

      }				// gsi

    }  

    switch_off_context ();
  }


}








/* Clear profile information attached to gimple
	 If DEFUSE=1, then REF is a write. */ 
static void 
insert_stmt_loop(gimple_stmt_iterator * gsi) 
{
  gimple call;
  tree tree_printf_profiler_fn;

  /*
     see also in libprofile.cxx   
     void __print_address (PTR     addr,  int     size,   char    flag,  int      id) ;
   */
  

  tree_printf_profiler_fn =  build_fn_decl (loop_stmt_profiler_name, loop_stmt_profiler_fn_type);


   /*
     see also in libcount.cxx   
     void  __count_print_instruction () ;
   */ 
   
  call = gimple_build_call (tree_printf_profiler_fn, 0, NULL_TREE);

  gsi_insert_before (gsi, call, GSI_SAME_STMT);
  ipa_add_abnormal_goto_call_edges (*gsi);
}



static void
insert_edge_loop  (int entry, int loop_id, edge e)
{

  tree tree_printf_profiler_fn;

  switch (flag_profiling_type)
  {
    case PROFILING_HEAVYLOOP :
      if (flag_profile_loop_srcinfo)
        if (loop_id != *(loop_set.begin()))
          return;
      if (entry)
        tree_printf_profiler_fn =  build_fn_decl (loop_enter_profiler_name, loop_enter_profiler_fn_type);
      else  
        tree_printf_profiler_fn =  build_fn_decl (loop_exit_profiler_name, loop_exit_profiler_fn_type);
      break;

    case PROFILING_INSTCOUNT :
      
      if (loop_id != *(loop_set.begin()))
        return;
      
      if (entry)
        tree_printf_profiler_fn =  build_fn_decl (memop_enter_profiler_name, memop_enter_profiler_fn_type);
      else  
        tree_printf_profiler_fn =  build_fn_decl (memop_exit_profiler_name, memop_exit_profiler_fn_type);
      break;

    default:
      return;
  }



  tree lnum = build_int_cst_type (unsigned_type_node, loop_id);

  gimple_seq seq = gimple_seq_alloc ();

  gimple call = gimple_build_call (tree_printf_profiler_fn, 1, lnum, NULL_TREE);
  
  gimple_seq_add_stmt (&seq, call);
    
  gsi_insert_seq_on_edge (e, seq);

}




static void
insert_begin_loop (gimple_stmt_iterator * gsi)
{

  /*
     see also in libprivatize.cxx   
     void __privatize_profile_finalize  ();
   */

  tree tree_printf_profiler_fn =  build_fn_decl (loop_begin_profiler_name, loop_begin_profiler_fn_type);

  tree lnum = build_int_cst_type (unsigned_type_node, loop_num);

  gimple call = gimple_build_call (tree_printf_profiler_fn, 1, lnum, NULL_TREE);
  gimple_set_block (call, gimple_block(gsi_stmt(*gsi)));
  gsi_insert_before (gsi, call, GSI_SAME_STMT);
  ipa_add_abnormal_goto_call_edges (*gsi);

}





static void
insert_end_loop (gimple_stmt_iterator * gsi)
{

  /*
     see also in libprivatize.cxx   
     void __privatize_profile_finalize  ();
   */

  tree tree_printf_profiler_fn =  build_fn_decl (loop_end_profiler_name, loop_end_profiler_fn_type);

  gimple call = gimple_build_call (tree_printf_profiler_fn, 0, NULL_TREE);
  gimple_set_block (call, gimple_block(gsi_stmt(*gsi)));
  gsi_insert_before (gsi, call, GSI_SAME_STMT);
  ipa_add_abnormal_goto_call_edges (*gsi);

}


  
/* Function executed by the pass for each function.  */ 
static unsigned int 
ipa_profile_count_loop (void) 
{

  find_library_calls (NULL);


  /* Construct data structure and SSA form for each loop */
  {
    FILE *fp = fopen ("loop.info", "w");
    ipa_ssa_loop_init (fp);
    fclose (fp);
  }

  if (flag_profile_loop_srcinfo)
    specify_loops_to_profile ();

  {
    FILE *fp = fopen ("malloc.info", "w");
    recognize_mem_allocate_functions(fp);
  }

  /* Instrument to each procedure */ 
    
  printf ("start instrumenting for dependence count \n");
  initialize_profile_prototype ();
  for (cgraph_node_ptr node = cgraph_nodes; node; node = node->next)      
  {
    if (!valid_function_node_p (node))
     continue;
    switch_to_context (node->decl);

    /* Insert profiling statements to collect memory address read/write */ 
    profile_stmt (node, insert_stmt_loop);

    /* Inserting loop entry/exit on edges */
    profile_edge (node, insert_edge_loop);    
    
    profile_begin (node, insert_begin_loop);
    
    profile_exit (node, insert_end_loop);

    switch_off_context ();
  }
     

  ipa_ssa_loop_done ();

  /* Cleanup. */
  for (cgraph_node_ptr node = cgraph_nodes; node; node = node->next)
  {
    /* Get rid of the aux information.      */
    if (node->aux)
    {
      free (node->aux);
      node->aux = NULL;
    }
  }

  printf ("ipa profile count done\n");
  htab_delete (loop_hash);

  return 0;
}









/* Clear profile information attached to gimple
	 If DEFUSE=1, then REF is a write. */ 
static void 
insert_bb (basic_block bb) 
{

  gimple_stmt_iterator gsi = gsi_start_bb (bb);
  tree tree_printf_profiler_fn = build_fn_decl (memop_memop_profiler_name, memop_memop_profiler_fn_type);

  tree loc = build_int_cst_type (integer_type_node, bb_uid(bb));  
  gimple call = gimple_build_call (tree_printf_profiler_fn, 1, loc, NULL_TREE);
  
	gimple stmt = gsi_stmt (gsi);

  for (gsi = gsi_start_bb (bb); !gsi_end_p (gsi); gsi_next (&gsi))
  {
    stmt = gsi_stmt (gsi);
    if (gimple_code (stmt)!= GIMPLE_LABEL)
      break;
  }
    
  if (!gsi_end_p (gsi))
  {
    gsi_insert_before(&gsi, call, GSI_SAME_STMT); 
    ipa_add_abnormal_goto_call_edges (gsi);
  }

}


static void
insert_begin_memop (gimple_stmt_iterator * gsi)
{

  tree tree_printf_profiler_fn =  build_fn_decl (memop_begin_profiler_name, memop_begin_profiler_fn_type);

  tree lnum = build_int_cst_type (unsigned_type_node, bb_num);

  gimple call = gimple_build_call (tree_printf_profiler_fn, 1, lnum, NULL_TREE);
  gimple_set_block (call, gimple_block(gsi_stmt(*gsi)));
  gsi_insert_before (gsi, call, GSI_SAME_STMT);
  ipa_add_abnormal_goto_call_edges (*gsi);

}





static void
insert_end_memop (gimple_stmt_iterator * gsi)
{


  tree tree_printf_profiler_fn =  build_fn_decl (memop_end_profiler_name, memop_end_profiler_fn_type);

  gimple call = gimple_build_call (tree_printf_profiler_fn, 0, NULL_TREE);
  gimple_set_block (call, gimple_block(gsi_stmt(*gsi)));
  gsi_insert_before (gsi, call, GSI_SAME_STMT);
  ipa_add_abnormal_goto_call_edges (*gsi);

}


  
/* Function executed by the pass for each function.  */ 
static unsigned int 
ipa_profile_count_memop (void) 
{

  {
    FILE *fp = fopen ("libfunc.info", "w");
    find_library_calls (fp);
    fclose (fp);
  }


  /* Construct data structure and SSA form for each loop */
  {
    FILE *fp = fopen ("loop.info", "w");
    ipa_ssa_loop_init (fp);
    fclose (fp);
  }

  /* Assign an ID to each gimple statement */
  {
    FILE *fp = fopen ("stmt.info", "w");
    ipa_gimple_id_assignment (fp);
    fclose (fp);
  }

  specify_loops_to_profile ();
   
  /* Create data references to record each memory access */ 
  dr_hash = htab_create (100, hash_dr_id, eq_dr_id, hash_dr_del);
  ipa_create_data_references (NULL);


  /* Instrument to each procedure */ 
    
  printf ("start instrumenting for dependence count \n");
  initialize_profile_prototype ();
  for (cgraph_node_ptr node = cgraph_nodes; node; node = node->next)      
  {
    if (!valid_function_node_p (node))
     continue;
    switch_to_context (node->decl);

    /* Insert profiling statements to collect memory address read/write */ 
    profile_bb (node, insert_bb);
    
    /* Inserting loop entry/exit on edges */
    profile_edge (node, insert_edge_loop);    

    profile_begin (node, insert_begin_memop);
    
    profile_exit (node, insert_end_memop);
    switch_off_context ();
  }
     
  htab_delete (dr_hash);

  ipa_ssa_loop_done ();

  /* Cleanup. */
  for (cgraph_node_ptr node = cgraph_nodes; node; node = node->next)
  {
    /* Get rid of the aux information.      */
    if (node->aux)
    {
      free (node->aux);
      node->aux = NULL;
    }
  }

  printf ("ipa profile count done\n");

  return 0;
}



/* Function executed by the pass for each function.  */ 
static unsigned int 
ipa_profile_count (void) 
{
  switch (flag_profiling_type)
  {
    case PROFILING_HEAVYLOOP :
      ipa_profile_count_loop ();
      break;

    case PROFILING_INSTCOUNT :
      ipa_profile_count_memop();
      break;
      
    default:
      break;
  }

  return 0;

}


static bool
gate_ipa_profile_count (void)
{
  return flag_profiling_type == PROFILING_HEAVYLOOP  || 
         flag_profiling_type == PROFILING_INSTCOUNT ;
}



struct simple_ipa_opt_pass pass_profile_count = 
{  
  { 
    SIMPLE_IPA_PASS,  
    "profile-count", /* name */ 
    gate_ipa_profile_count, /* gate */ 
    ipa_profile_count, /* execute */ 
    NULL, /* sub */ 
    NULL, /* next */ 
    0, /* static_pass_number */ 
    TV_TREE_PROFILE_DEPENDENCE, /* tv_id */ 
    PROP_ssa, /* properties_required */ 
    0, /* properties_provided */ 
    0, /* properties_destroyed */ 
    0, /* todo_flags_start */ 
    TODO_dump_func  
    |TODO_update_ssa /* todo_flags_finish */  
  } 
};






