
#include "ipa-check-dependence.h"

static GTY (()) tree malloc_profiler_fn_type;
static GTY (()) tree address_profiler_fn_type;
static GTY (()) tree exit_profiler_fn_type; 
static GTY (()) tree edge_profiler_fn_type;

static const char *malloc_profiler_name = "__alias_print_malloc";
static const char *address_profiler_name = "__alias_print_address";
static const char *exit_profiler_name = "__alias_print_exit";
static const char *edge_profiler_name = "__alias_print_edge";

static bitmap loop_checked;




  
/*
	see also in alias.h

	void __alias_print_malloc  (PTR 	old_addr, PTR new_addr,	int 	size,  	char	flag);
	void __alias_print_address	(PTR	 addr, 	int 	size,  	int 	id) ;
	void __print_exit();
*/ 
static void initialize_profile_prototype () 
{

  malloc_profiler_fn_type = build_function_type_list ( void_type_node, 
                                ptr_type_node, /* void *old_addr */ 
                                ptr_type_node, /* void *new_addr */ 
                                integer_type_node, /* int size */ 
                                char_type_node, /* char flag */ 
                                NULL_TREE);
  
  address_profiler_fn_type = build_function_type_list ( void_type_node, 
                                ptr_type_node,  /* void *addr */ 
                                integer_type_node, /* int size */ 
                                integer_type_node,  NULL_TREE);
  

  edge_profiler_fn_type = build_function_type_list (void_type_node, char_type_node,	/* char flag */
						    integer_type_node,	/* int entry */
						    NULL_TREE);
  
  exit_profiler_fn_type = build_function_type_list ( void_type_node,  NULL_TREE);
}




static void insert_exit (gimple_stmt_iterator * gsi) 
{
  tree tree_printf_profiler_fn = build_fn_decl (exit_profiler_name, exit_profiler_fn_type);
  gimple call = gimple_build_call (tree_printf_profiler_fn, 0, NULL_TREE);
  gsi_insert_before (gsi, call, GSI_SAME_STMT);
  ipa_add_abnormal_goto_call_edges (*gsi);
} 





static void
insert_malloc (gimple_stmt_iterator * gsi, tree old_addr, tree new_addr, tree size, int flag)
{

  /*
     see also in libprofile.cxx   
     void __alias_print_malloc  (PTR    old_addr, PTR new_addr, int     size,   char    flag);
   */

  tree tree_printf_profiler_fn = build_fn_decl (malloc_profiler_name, malloc_profiler_fn_type);

  tree flag_t = build_int_cst_type (char_type_node, flag);
  gimple call = gimple_build_call (tree_printf_profiler_fn, 4, old_addr, new_addr, size, flag_t, NULL_TREE);

  gsi_insert_after (gsi, call, GSI_NEW_STMT);
  ipa_add_abnormal_goto_call_edges (*gsi);

}

// find the most inner loop containing dr in which the base address of dr may changed
// return variant loops. return 0 if invariant in all loops, -1 means variant in all loops
int  find_variant_loop(tree ref, gimple stmt, loop_p loop)
{

  if ( bitmap_bit_p(loop_checked, loop_uid(loop) ))
    return 0;

  bitmap_set_bit(loop_checked, loop_uid(loop) );

  tree func = loop_func_decl(loop);

  if ( loop->num > 0 )
  {
    switch_to_context (func);
    bool inv = ipa_ref_contains_symbols_defined_in_loop (loop, ref, stmt) ;    
    switch_off_context();
    if ( !inv  )
      return loop_uid(loop);
    else
    {
      loop = VEC_last (loop_p, loop->superloops);      
      return find_variant_loop (ref, stmt, loop) ;
    }
  }
  else
  {
    cgraph_node_ptr node = cgraph_get_node (func);
    std::set<loop_p>  &inner_loops = func_extra_info (node)->inner_loops;
    int loop_id = 0;
    for ( std::set<loop_p>::iterator iter = inner_loops.begin(); iter != inner_loops.end(); ++iter )
    {
      int tmp = find_variant_loop (ref, stmt, *iter) ;
      if ( loop_id == 0 )
        loop_id = tmp;
      else if ( tmp != loop_id )
        return -1;        
    }

    return loop_id;

  }


}

// find the most inner loop containing dr in which the base address of dr may changed
int  find_variant_loop(ipa_data_reference * dr)
{

  tree  ref = DR_ORIG_FORM (dr);
  tree  base = get_base_pointer (ref);
  gimple stmt = DR_STMT(dr);
  loop_p loop  = loop_containing_stmt (stmt);
  
  return find_variant_loop (base, stmt, loop);  
}


/* Clear profile information attached to gimple
	 If DEFUSE=1, then REF is a write. */ 
static void 
insert_address (gimple_stmt_iterator * gsi, tree ref, int opnd, int defuse) 
{
  gimple call;
  tree addr, size, loc, flag;
  tree tree_printf_profiler_fn;

  /* Do not need to profile temporary variables */ 
  if (TREE_CODE (ref) == VAR_DECL && DECL_ARTIFICIAL (ref))
    return;

  if (TREE_CODE (ref) == SSA_NAME)
    return;

  gimple stmt = gsi_stmt (*gsi);
  ipa_data_reference * dr = tree_data_reference (stmt, opnd);
  if (!dr)
    return;

  loc = build_int_cst_type (integer_type_node, dr->uid ());

  tree_printf_profiler_fn =  build_fn_decl (address_profiler_name, address_profiler_fn_type);



  /* check loop invariant */
  int var_loop = dr->variant_loop();
  tree inv = build_int_cst_type (integer_type_node, var_loop);

  
  tree iter_var = ipa_add_new_external_global (integer_type_node, dr_var_name (dr, "iter"));
  add_referenced_var (iter_var);
  DECL_INITIAL (iter_var) = build_int_cst_type (integer_type_node, 0);
  TREE_STATIC (iter_var) = 1;
  insert_global_to_varpool (iter_var);
  iter_var = gimplify_build1 (gsi, ADDR_EXPR, build_pointer_type (integer_type_node), iter_var);

  /*
     see also in alias.h  
     void __alias_print_address (PTR addr, int size, int memop, int inv, int *iter) 
   */ 
   
  switch (TREE_CODE (ref))  
  {
  
    case COMPONENT_REF:
    case ARRAY_REF:
    case INDIRECT_REF:
    case MEM_REF:
    case VAR_DECL:
      addr = gimple_build_addr_expr (gsi, ref);
      break;
    default:
      return;
      break;
   }
  
  gcc_assert (addr);
  size = TYPE_SIZE (TREE_TYPE (ref));
  call = gimple_build_call (tree_printf_profiler_fn, 2, addr, loc, NULL_TREE);

  gsi_insert_before (gsi, call, GSI_SAME_STMT);
  ipa_add_abnormal_goto_call_edges (*gsi);
}

static void
insert_edge (int entry, int loop_id, edge e)
{

  tree ent = build_int_cst_type (integer_type_node, entry);
  tree lnum = build_int_cst_type (unsigned_type_node, loop_id);


  /* see also in libalias.cxx
     void __alias_print_edge( int loop_id,      // The global loop id 
     int entry            // 1- loop entry , 0- loop exit 
     )                                                    */

  tree tree_printf_profiler_fn = build_fn_decl (edge_profiler_name, edge_profiler_fn_type);

  gimple call = gimple_build_call (tree_printf_profiler_fn, 2, lnum, ent, NULL_TREE);

  gimple_seq seq = gimple_seq_alloc ();
  gimple_seq_add_stmt (&seq, call);
  gsi_insert_seq_on_edge (e, seq);

}


int
find_base_variant_loop (void **slot, void *data )
{

  bitmap loop_checked = (bitmap)data;

  bitmap_clear(loop_checked);

  dr_hash_entry *dr_entry = *(dr_hash_entry **) slot;

  ipa_data_reference *dr = dr_entry->dr;

  int loop_id = find_variant_loop (dr);

  dr->set_variant_loop (loop_id);    

  return 1;
}

  
/* Function executed by the pass for each function.  */ 
 static unsigned int 
ipa_profile_alias (void) 
{

  /* Construct data structure and SSA form for each loop */
  {
    FILE *fp = fopen ("loop.info", "w");
    ipa_ssa_loop_init (fp);
    fclose (fp);
  }

  /* Assign an ID to each gimple statement */
  {
    FILE *fp = fopen ("stmt.info", "w");
    ipa_gimple_id_assignment (fp);
    fclose (fp);
  }

   
  /* Create data references to record each memory access */ 
  formal_checked = BITMAP_ALLOC (NULL);
  formal_checking = BITMAP_ALLOC (NULL);
  dr_hash = htab_create (100, hash_dr_id, eq_dr_id, hash_dr_del);
  ipa_create_data_references (NULL);

  /* Use points-to result to complement indirect call edges  */
  cgraph_resolve_indirect_edges ();


  /* Perform interprocedural mod-ref analysis */
  ipa_mod_ref_analysis ();


  /* check loop invariant */
//  loop_checked = BITMAP_ALLOC (NULL);
//  htab_traverse (dr_hash, find_base_variant_loop, loop_checked);
//  BITMAP_FREE(loop_checked);

   
  /* Instrument to each procedure */ 
    
  printf ("start instrumenting for dependence profiling \n");
  initialize_profile_prototype ();
  struct cgraph_node *node;
  for (node = cgraph_nodes; node; node = node->next)      
  {
    if (!valid_function_node_p (node))
     continue;
    switch_to_context (node->decl);

    /* Inserting loop entry/exit on edges */
//    profile_edge (node, insert_edge);
    /* Insert profiling statements to collect memory address read/write */ 
    profile_memop (node, insert_address);
//    profile_malloc (node, insert_malloc);
    profile_exit (node, insert_exit);
    switch_off_context ();
  }
     
  printf ("ipa profile dependence done\n");
  htab_delete (dr_hash);
  BITMAP_FREE(formal_checked);
  BITMAP_FREE(formal_checking);

  ipa_ssa_loop_done ();

  /* Cleanup. */
  for (node = cgraph_nodes; node; node = node->next)
  {
    /* Get rid of the aux information.      */
    if (node->aux)
    {
    free (node->aux);
    node->aux = NULL;
    }
  }


  return 0;
}

static bool 
gate_ipa_profile_alias (void) 
{
  return 0; //flag_ipa_profile_alias != 0;
}

struct simple_ipa_opt_pass pass_profile_alias = 
{  
  { 
    SIMPLE_IPA_PASS,  
    "profile-alias", /* name */ 
    gate_ipa_profile_alias, /* gate */ 
    ipa_profile_alias, /* execute */ 
    NULL, /* sub */ 
    NULL, /* next */ 
    0, /* static_pass_number */ 
    TV_TREE_PROFILE_DEPENDENCE, /* tv_id */ 
    PROP_ssa, /* properties_required */ 
    0, /* properties_provided */ 
    0, /* properties_destroyed */ 
    0, /* todo_flags_start */ 
    TODO_dump_func | TODO_rebuild_alias 
    |TODO_update_ssa /* todo_flags_finish */  
    |TODO_verify_ssa | TODO_verify_stmts  
  } 
};





