
#include "ipa-check-dependence.h"


extern "C"
{
#include "pta.h"
  extern tree canonicalize_base_object_address (tree addr);

}

#define PRDICATE_LEN 5

int myflag = 0;
bool bootstrap_flag = false;

struct pta_statistics statistics;

int dr_count = 0;
int valid_dr_count=0;


ALIAS_CLASS_MAP alias_class_map;


/* global variables that may be defined inside the current loop */
static bitmap global_write;

/* formal variables whose corresponding actual parameters may be
   defined inside the current loop */
static bitmap formal_write;

/* functions that may be invoked inside the current loop */
static bitmap call_functions;

/* functions that has been checked dependence  */
static bitmap analyzed_functions;

/* formal parameters that are being analyzed for loop-invariant definitions */
bitmap formal_checking;

/* formal variables that have been analyzed for loop-invariant definitions.
	 The analyzed results are stored in FORMAL_WIRTE */
bitmap formal_checked;

static VEC (loop_p, heap) *  loop_nest;
static VEC (ipa_data_reference_p, heap) * indirect_datarefs;

data_dependence_set   loop_carried_dependencies;
data_dependence_set   loop_independent_dependencies;
data_dependence_set   must_loop_carried_dependencies;
data_dependence_set   must_loop_independent_dependencies;



int loop_num = 0;

int bb_num = 0;

unsigned long long guid = 0;

htab_t loop_hash;

/* Compares database elements E1 and E2.  */

int eq_loop_id (const void *e1, const void *e2)
{
  const struct loop_extra_info_t *elt1 = (const struct loop_extra_info_t *) e1;
  const struct loop_extra_info_t *elt2 = (const struct loop_extra_info_t *) e2;

  return elt1->uid == elt2->uid;
}

/* Computes a hash function for element ELT.  */

hashval_t
hash_loop_id (const void *elt)
{
  const struct loop_extra_info_t *const s = (const struct loop_extra_info_t *) elt;
  int id = s->uid;
  return htab_hash_pointer ((void *) id);
}

/* Free the element E.  */

void
hash_loop_del (void *e)
{
  struct loop_extra_info_t *s = (struct loop_extra_info_t *) e;
  delete s;
}

loop_p ipa_get_loop(int loop_uid)
{
	loop_extra_info_t loop_entry;
	loop_entry.uid = loop_uid;
	loop_extra_info_t **slot = (loop_extra_info_t **) htab_find_slot (loop_hash, &loop_entry, NO_INSERT);
	gcc_assert (*slot);
	return (**slot).loop;
}



htab_t dr_hash;

/* Compares database elements E1 and E2.  */

int eq_dr_id (const void *e1, const void *e2)
{
  const struct dr_hash_entry *elt1 = (const struct dr_hash_entry *) e1;
  const struct dr_hash_entry *elt2 = (const struct dr_hash_entry *) e2;

  return elt1->id == elt2->id;
}

/* Computes a hash function for element ELT.  */

hashval_t
hash_dr_id (const void *elt)
{
  const struct dr_hash_entry *const s = (const struct dr_hash_entry *) elt;
  int id = s->id;
  return htab_hash_pointer ((void *) id);
}

/* Free the element E.  */

void
hash_dr_del (void *e)
{
  const struct dr_hash_entry *const s = (const struct dr_hash_entry *) e;
  ipa_free_data_ref (s->dr);
  free (e);
}



htab_t slice_hash;


/* Compares database elements E1 and E2.  */

int
eq_slice_id (const void *e1, const void *e2)
{
  const struct slice_hash_entry *elt1 = (const struct slice_hash_entry *) e1;
  const struct slice_hash_entry *elt2 = (const struct slice_hash_entry *) e2;

  return elt1->slice_id == elt2->slice_id;
}

/* Computes a hash function for element ELT.  */

hashval_t
hash_slice_id (const void *elt)
{
  const struct slice_hash_entry *const s =
    (const struct slice_hash_entry *) elt;
  int slice_id = s->slice_id;
  return htab_hash_pointer ((void *) slice_id);
}

/* Free the element E.  */

void
hash_slice_del (void *e)
{
  const struct slice_hash_entry *const s =
    (const struct slice_hash_entry *) e;
  s->slice->clear ();
  free (e);
}


alias_slice *
find_alias_slice (int slice_id)
{

  struct slice_hash_entry tmp;
  tmp.slice_id = slice_id;
  tmp.slice = NULL;

  slice_hash_entry *slot = (slice_hash_entry *) htab_find (slice_hash, &tmp);

  if (slot)
    return slot->slice;
  else
    return NULL;
}

alias_slice *
new_alias_slice (int slice_id)
{

  struct slice_hash_entry tmp;
  tmp.slice_id = slice_id;
  tmp.slice = NULL;

  slice_hash_entry *slice_entry;
  slice_hash_entry **slot =
    (slice_hash_entry **) htab_find_slot (slice_hash, &tmp, INSERT);

  if (*slot)
    return (*slot)->slice;
  else
    {
      /* create new callsite */
      slice_entry = XNEW (struct slice_hash_entry);
      slice_entry->slice_id = slice_id;
      slice_entry->slice = new alias_slice (slice_id);
      *slot = slice_entry;
      return slice_entry->slice;
    }


}


void
alias_slice_merge (ipa_data_reference * a, ipa_data_reference * b)
{
  int a_slice_id = a->slice_id ();
  int b_slice_id = b->slice_id ();

  alias_slice *a_slice = find_alias_slice (a_slice_id);

  if (a_slice)
    a_slice->Union (b);
  else
    {
      alias_slice *b_slice = find_alias_slice (b_slice_id);
      if (b_slice)
	b_slice->Union (a);
      else
	{
	  a_slice = new_alias_slice (a_slice_id);
	  a_slice->Union (a);
	  a_slice->Union (b);
	}
    }


}

static int
dump_slice (void **slot, void *data)
{
  slice_hash_entry *slice_entry = *(slice_hash_entry **) slot;
  slice_entry->slice->print ((FILE *) data);

}

void
print_alias_slice (FILE * fp)
{
  fprintf (fp, "Alias slice :\n");

  htab_traverse (slice_hash, dump_slice, fp);

  return;

  fprintf (fp, "Single slice :\n");

  struct cgraph_node *node;
  for (node = cgraph_nodes; node; node = node->next)
  {
    if ( !valid_function_node_p(node) )
    	continue;

    struct func_extra_info_t *finfo = func_extra_info (node);

    switch_to_context (node->decl);
    basic_block bb;
    gimple_stmt_iterator bsi;
    FOR_EACH_BB (bb)
    {

if (bb->loop_depth == 0 && !finfo->in_loop())
  continue;
for (bsi = gsi_start_bb (bb); !gsi_end_p (bsi); gsi_next (&bsi))
  {
    gimple stmt = gsi_stmt (bsi);
    enum gimple_code stmt_code = gimple_code (stmt);
    ipa_data_reference_p dr;
    tree ref, op2;
    switch (stmt_code)
      {
      case GIMPLE_ASSIGN:
	{
	  dr = tree_data_reference (stmt, 0);
	  if (dr)
	    {
	      fprintf (fp, "SLICE %d : \n", dr->slice_id ());
	      ref = DR_ORIG_FORM (dr);
	      fprintf (fp, "		REF : ");
	      print_generic_expr (fp, ref, 0);
	      fprintf (fp, "	LINE : %d", gimple_lineno (stmt));

	      fprintf (fp, "	 STMT %lld: ", gimple_uid (stmt));
	      print_gimple_stmt (fp, stmt, 0, 0);
	    }

	  dr = tree_data_reference (stmt, 1);
	  if (dr)
	    {
	      fprintf (fp, "SLICE %d : \n", dr->slice_id ());
	      ref = DR_ORIG_FORM (dr);
	      fprintf (fp, "		REF : ");
	      print_generic_expr (fp, ref, 0);
	      fprintf (fp, "	LINE : %d", gimple_lineno (stmt));

	      fprintf (fp, "	 STMT %lld: ", gimple_uid (stmt));
	      print_gimple_stmt (fp, stmt, 0, 0);
	    }

	  op2 = gimple_assign_rhs2 (stmt);
	  if (op2)
	    {
	      dr = tree_data_reference (stmt, 2);
	      if (dr)
		{
		  fprintf (fp, "SLICE %d : \n", dr->slice_id ());
		  ref = DR_ORIG_FORM (dr);
		  fprintf (fp, "		REF : ");
		  print_generic_expr (fp, ref, 0);
		  fprintf (fp, "	LINE : %d",
			   gimple_lineno (stmt));

		  fprintf (fp, "	 STMT %lld: ", gimple_uid (stmt));
		  print_gimple_stmt (fp, stmt, 0, 0);
		}
	    }

	  break;
	}

      case GIMPLE_COND:
	{
	  dr = tree_data_reference (stmt, 0);
	  if (dr)
	    {
	      fprintf (fp, "SLICE %d : \n", dr->slice_id ());
	      ref = DR_ORIG_FORM (dr);
	      fprintf (fp, "		REF : ");
	      print_generic_expr (fp, ref, 0);
	      fprintf (fp, "	LINE : %d", gimple_lineno (stmt));

	      fprintf (fp, "	 STMT %lld: ", gimple_uid (stmt));
	      print_gimple_stmt (fp, stmt, 0, 0);
	    }

	  dr = tree_data_reference (stmt, 1);
	  if (dr)
	    {
	      fprintf (fp, "SLICE %d : \n", dr->slice_id ());
	      ref = DR_ORIG_FORM (dr);
	      fprintf (fp, "		REF : ");
	      print_generic_expr (fp, ref, 0);
	      fprintf (fp, "	LINE : %d", gimple_lineno (stmt));

	      fprintf (fp, "	 STMT %lld: ", gimple_uid (stmt));
	      print_gimple_stmt (fp, stmt, 0, 0);
	    }
	  break;
	}

      case GIMPLE_CALL:


      default:
	break;


      }
  }
    }
    switch_off_context ();

  }

}


void
alias_slice::Union (ipa_data_reference * dr)
{

  if (dr->slice_id () == id ())
    {
//              gcc_assert (empty());
      push_back (dr);
    }

  alias_slice *b_slice = find_alias_slice (dr->slice_id ());
  if (!b_slice)
    {
      push_back (dr);
      dr->set_slice_id (id ());
      if (!DR_IS_READ (dr))
	_write = 1;
    }

  else
    {
      for (alias_slice::iterator iter = b_slice->begin ();
	   iter != b_slice->end (); ++iter)
	{
	  (*iter)->set_slice_id (id ());
	  if (!DR_IS_READ (*iter))
	    _write = 1;
	}
      splice (end (), *b_slice);
    }
}

void
alias_slice::print (FILE * fp) const
{
  fprintf (fp, "SLICE %d : \n", id ());
  for (alias_slice::const_iterator iter = begin (); iter != end (); ++iter)
    {
      ipa_data_reference *dr = *iter;
      gimple stmt = DR_STMT (dr);
      tree ref = DR_ORIG_FORM (dr);

      fprintf (fp, "    REF : ");
      print_generic_expr (fp, ref, 0);
      fprintf (fp, "	LINE : %d", gimple_lineno (stmt));

      fprintf (fp, "	 STMT %lld: ", gimple_uid (stmt));
      print_gimple_stmt (fp, stmt, 0, 0);

    }

}


static void
search_and_substitute (tree expr, tree lhs, tree rhs)
{

  if (TREE_CODE (expr) == ADDR_EXPR)
    return;

  int i;
  int n = TREE_OPERAND_LENGTH (expr);
  for (i = 0; i < n; i++)
    {
      tree opnd = TREE_OPERAND (expr, i);
      if (!opnd)
	continue;

      if (operand_equal_p (opnd, lhs, 0))
	{
	  TREE_OPERAND (expr, i) = unshare_expr (rhs);
	}
      else
	search_and_substitute (opnd, lhs, rhs);
    }

}


static bool
is_mem_ref (tree ref)
{
  if (TREE_CODE (ref) == VAR_DECL)
    return true;

  if (TREE_CODE (ref) == SSA_NAME)
    return true;

  if (TREE_CODE (ref) == STRING_CST)
    return false;

  if (TREE_CODE (ref) == ARRAY_REF)
    if (TREE_CODE (TREE_OPERAND (ref, 0)) == STRING_CST)
      return false;

  if (REFERENCE_CLASS_P (ref))
    return true;

  return false;

}



static tree
substitute_artifical_vars (gimple pred, tree ref)
{

  if (!is_gimple_assign (pred))
    return ref;

  tree lhs = gimple_assign_lhs (pred);
  tree rhs = gimple_assign_rhs_to_tree (pred);

  if (TREE_CODE (lhs) == SSA_NAME)
    {
      tree base = SSA_NAME_VAR (lhs);
      if (DECL_ARTIFICIAL (base))
	{
	  /* search lhs in bounds */
	  tree tmp = unshare_expr (ref);
	  search_and_substitute (tmp, lhs, rhs);
	  return tmp;
	}
    }

  return ref;

}

static tree
get_original_form (tree ref, gimple ref_stmt)
{
  basic_block bb = gimple_bb (ref_stmt);

  gimple_stmt_iterator bsi;
  bool find_pred = false;
  tree tmp = ref;

  for (bsi = gsi_last_bb (bb); !gsi_end_p (bsi); gsi_prev (&bsi))
    {
      gimple pred = gsi_stmt (bsi);
      if (find_pred)
	tmp = substitute_artifical_vars (pred, tmp);

      if (pred == ref_stmt)
	find_pred = true;

    }

  return tmp;

}


/* Match an assignment under the form:	"i = i + 1".	*/
bool
check_step_against_one (tree index, tree ref, gimple stmt, loop_p loop)
{

  index = tree_strip_nops (index);

  if (TREE_CODE (index) == SSA_NAME)
    {

      tree ev = analyze_scalar_evolution (loop, index);
      ev = tree_strip_nops (ev);
      if (TREE_CODE (ev) == POLYNOMIAL_CHREC)
	{
	  tree step = CHREC_RIGHT (ev);

	  if (TREE_CODE (step) != INTEGER_CST)
	    return false;

	  int val = int_cst_value (step);

	  if (val == 1 || val == -1)
	    return true;
	  else
	    return false;
	}

      else if (is_gimple_assign (SSA_NAME_DEF_STMT (index)))
	{

	  gimple def = SSA_NAME_DEF_STMT (index);
	  if (gimple_assign_rhs_class (def) == GIMPLE_BINARY_RHS)
	    {
	      tree rval1 = gimple_assign_rhs1 (def);
	      tree rval2 = gimple_assign_rhs2 (def);
	      if (TREE_CODE (rval1) == SSA_NAME)
		{
		  if (SSA_NAME_VAR (rval1) == SSA_NAME_VAR (index))
		    {
		      tree step = rval2;
		      if (TREE_CODE (step) == INTEGER_CST)
			{
			  int val = int_cst_value (step);

			  if (val == 1 || val == -1)
			    return true;
			}
		    }
		}

	      else if (TREE_CODE (rval2) == SSA_NAME)
		{
		  if (SSA_NAME_VAR (rval2) == SSA_NAME_VAR (index))
		    {
		      tree step = rval1;
		      if (TREE_CODE (step) == INTEGER_CST)
			{
			  int val = int_cst_value (step);
			  if (val == 1 || val == -1)
			    return true;
			}
		    }
		}
	    }
	}

#if 0
      else if (gimple_code (SSA_NAME_DEF_STMT (index)) == GIMPLE_PHI)
	{
	  /* check each phi operand defined inside loop */
	  gimple def = SSA_NAME_DEF_STMT (index);
	  int i;
	  for (i = 0; i < gimple_phi_num_args (def); i++)
	    {
	      tree opnd = gimple_phi_arg_def (def, i);
	      gimple def_opnd = SSA_NAME_DEF_STMT (opnd);
	      if (def_opnd && loop_containing_stmt (def_opnd) == loop)
		if (!check_step_against_one (opnd, ref, stmt, loop))
		  return false;
	    }
	  return true;
	}
#endif
    }
  else if (TREE_CODE (index) == MULT_EXPR)
    {
      tree rval1 = TREE_OPERAND (index, 0);
      tree rval2 = TREE_OPERAND (index, 1);
      if (TREE_CODE (rval1) == INTEGER_CST)
	{
	  int val = int_cst_value (rval1);
	  int size = int_cst_value (TYPE_SIZE (TREE_TYPE (ref))) >> 3;
	  if (val == size)
	    return check_step_against_one (rval2, ref, stmt, loop);
	}
      else if (TREE_CODE (rval2) == INTEGER_CST)
	{
	  int val = int_cst_value (rval2);
	  int size = int_cst_value (TYPE_SIZE (TREE_TYPE (ref))) >> 3;
	  if (val == size)
	    return check_step_against_one (rval1, ref, stmt, loop);
	}
    }
  else if (TREE_CODE (index) == PLUS_EXPR)
    {
      tree rval1 = TREE_OPERAND (index, 0);
      tree rval2 = TREE_OPERAND (index, 1);
      if (!ipa_ref_contains_symbols_defined_in_loop (loop, rval1, stmt))
	{
	  return check_step_against_one (rval2, ref, stmt, loop);
	}
      else if (!ipa_ref_contains_symbols_defined_in_loop (loop, rval2, stmt))
	{
	  return check_step_against_one (rval1, ref, stmt, loop);
	}
    }

  return false;

}

bool
check_continous_address (tree ref, gimple ref_stmt)
{
  struct loop *loop = loop_containing_stmt (ref_stmt);
  if (loop_depth (loop) < 1)
    return false;

  tree index = NULL_TREE;
  tree base;
  bool base_inv = false;

  switch (TREE_CODE (ref))
    {
    case ARRAY_REF:
      {
	base = TREE_OPERAND (ref, 0);
	index = TREE_OPERAND (ref, 1);
	base_inv =
	  ipa_object_address_invariant_in_loop_p (loop, base, ref_stmt);
	break;
      }

    case MEM_REF:
      {
	base = TREE_OPERAND (ref, 0);
	index = TREE_OPERAND (ref, 1);

	if (TREE_CODE (index) == INTEGER_CST)
	  {
	    if (TREE_CODE (base) == POINTER_PLUS_EXPR)
	      {
		index = TREE_OPERAND (base, 1);
		base = TREE_OPERAND (base, 0);
	      }
	  }

	base_inv =
	  !ipa_ref_contains_symbols_defined_in_loop (loop, base, ref_stmt);

	break;
      }

    default:
      return false;

    }


  if (!base_inv)
    return false;

  if (check_step_against_one (index, ref, ref_stmt, loop))
    return true;


  return false;
}

tree
get_base_pointer (tree ref)
{

  tree base;
  tree index;
  bool addressable = false;
  switch (TREE_CODE (ref))
    {

    case VAR_DECL:
    case PARM_DECL:
      addressable = TREE_ADDRESSABLE (ref);
      base = build_addr (ref, current_function_decl);
      TREE_ADDRESSABLE (ref) = addressable;
      return base;

    case SSA_NAME:
      return get_base_pointer (SSA_NAME_VAR (ref));


    case COMPONENT_REF:
      return get_base_pointer (TREE_OPERAND (ref, 0));

    case ARRAY_REF:
      return get_base_pointer (TREE_OPERAND (ref, 0));

    case MEM_REF:
    {
    	base = TREE_OPERAND (ref, 0);
    	index = TREE_OPERAND (ref, 1);

    	if (TREE_CODE (index) == INTEGER_CST)
    	  {
    	    while (TREE_CODE (base) == POINTER_PLUS_EXPR)
    	      base = TREE_OPERAND (base, 0);
    	  }
    	return base;


      break;
    }

    default:
      return NULL_TREE;

    }

}

void
access_pattern::print (FILE * fp, int indent)
{
  if (!fp)
    return;

  print_indents (fp, indent);
  fprintf (fp, "PATTERN	");

  switch (_kind)
    {
    case pk_no_pattern:
      fprintf (fp, "POINT");
      break;
    case pk_irregular:
      fprintf (fp, "IRREGULAR");
      break;
    case pk_symbolic:
      fprintf (fp, "SYMBOLIC");
      break;
    case pk_const:
      fprintf (fp, "CONST");
      break;
    default:
      gcc_assert (false);
      break;
    }
  fprintf (fp, "\n");

  if ( dimensions().empty() )
    return;

  print_indents (fp, indent);
  fprintf (fp, "BASE	");
  access_dimension_vec::iterator iter = dimensions ().begin ();
  if ( iter->var() )
    print_generic_expr (fp, iter->var (), 0);
  if (iter->offset ())
    fprintf (fp, "		OFFSET	%d", iter->offset ());
  fprintf (fp, "\n");

  int j = 0;
  ++iter;
  for (; iter != dimensions ().end (); ++iter)
    {
      j++;
      access_dimension & dimension = *iter;
      print_indents (fp, indent);
      fprintf (fp, "DIM %d	", j);
      dimension.print (fp);
      fprintf (fp, "\n");
    }



}


/* Create new indirect edges with each edge coresponding to a possible target */

void
cgraph_resolve_indirect_edge (struct cgraph_node *caller, struct cgraph_edge *iedge, FILE *fp)
{
  gimple call = iedge->call_stmt;
  if (!call)
  {  
    fprintf(fp, "no call statement\n");
    return;
  }


  tree target = gimple_call_fn (call);
  gcc_assert (TREE_CODE (target) == SSA_NAME);
  gcc_assert (iedge->indirect_info);


	struct variable_info *vi = lookup_vi_for_tree(target);
  if ( !vi )
    vi = lookup_vi_for_tree(SSA_NAME_VAR(target));
  if ( !vi )
    return;
	bitmap pta = get_pta_solution(vi->id);

  if (bitmap_empty_p (pta))
  {
    fprintf(fp, "at GIMPLE %d no points-to set \n", gimple_uid(call) );
    return;
  }
  

  iedge->indirect_info->callees = NULL;
  struct cgraph_node *node;
  for (node = cgraph_nodes; node; node = node->next)
  {
    if (!valid_function_node_p (node))
      continue;

		vi = lookup_vi_for_tree(node->decl);

    if (!bitmap_bit_p (pta, vi->id))
      continue;

    fprintf(fp, "at GIMPLE %d icall %s\n", gimple_uid(call), cgraph_node_name(node) );
    
    struct nodeList* callee = (struct nodeList*)ggc_internal_alloc_stat (sizeof(struct nodeList));      
    callee->node = node;
    callee->next = NULL;
    if ( iedge->indirect_info->callees)
     iedge->indirect_info->callees->next = callee;
    else
     iedge->indirect_info->callees = callee;    
  }
}


void
cgraph_resolve_indirect_edges ()
{
  FILE *fp = fopen("icall.info", "w");
  struct cgraph_node *node;
  for (node = cgraph_nodes; node; node = node->next)
  {
    if (!valid_function_node_p (node))
      continue;
    /* Check indirect call */
    if (!node->indirect_calls)
      continue;
 
    struct cgraph_edge *edge;
    for (edge = node->indirect_calls; edge; edge = edge->next_callee)
    {
      if (edge->indirect_unknown_callee)
        cgraph_resolve_indirect_edge (node, edge, fp);
      else
        fprintf(fp, "function %s has known callee\n", cgraph_node_name(node) );        
    }
  }
  fclose(fp);
}



bool ipa_data_reference::analyze_innermost ()
{

  if (dr_analyze_innermost ((data_reference_p) this))
    return true;

  tree
    base = get_base_pointer (ref);

  if (base)
    {
      innermost.base_address = base;
      dr_set_inner_most_p (this);
      return true;
    }

  return false;
}

bool
get_regular_index_and_step (loop_p loop, tree expr, tree & index, tree & step)
{

  if (loop->num == 0)
    return false;

  expr = tree_strip_nops (expr);

  switch (TREE_CODE (expr))
  {
    case SSA_NAME:
    {

      gimple  def_stmt = SSA_NAME_DEF_STMT (expr);
      if (is_gimple_assign (def_stmt))
      {
        tree  rhs = gimple_assign_rhs_to_tree (def_stmt);
        return get_regular_index_and_step (loop, rhs, index, step);
      }

      // check whether it is a loop-induction variable
      tree  ev = analyze_scalar_evolution (loop, expr);
      ev = tree_strip_nops (ev);
      if (TREE_CODE (ev) == POLYNOMIAL_CHREC)
      {
        step = CHREC_RIGHT (ev);
        index = expr;
        return true;
      }
      else if (operand_equal_p (ev, expr, 0))
      {
        int     i;
        loop_p  father;
        FOR_EACH_VEC_ELT (loop_p, loop->superloops, i, father)
        {
          bool 	regular =  	get_regular_index_and_step (father, ev, index, step);
          if (regular)
          	return regular;
        }
      }

      else
      {
        bool  regular = get_regular_index_and_step (loop, ev, index, step);
        if (regular)
          return regular;
      }

      return false;
    }

    case PLUS_EXPR:
    {
      tree a = TREE_OPERAND (expr, 0);
      tree  ev = analyze_scalar_evolution (loop, a);
      ev = tree_strip_nops (ev);
      if (TREE_CODE (ev) == POLYNOMIAL_CHREC)
      {
        step = CHREC_RIGHT (ev);
        index = expr;
        return true;
      }
      else if (operand_equal_p (ev, a, 0))
      {
        int     i;
        loop_p  father;
        FOR_EACH_VEC_ELT (loop_p, loop->superloops, i, father)
        {
          bool 	regular =  	get_regular_index_and_step (father, ev, index, step);
          if (regular)
          	return regular;
        }
      }

      else
      {
        bool  regular = get_regular_index_and_step (loop, ev, index, step);
        if (regular)
          return regular;
      }

      return false;
    }

    case MULT_EXPR:
    {
      tree a = TREE_OPERAND (expr, 0);
      tree b = TREE_OPERAND (expr, 1);
      bool regular = get_regular_index_and_step (loop, a, index, step);
      if (regular)
      {

        step = fold_build2 (MULT_EXPR, integer_type_node, step, b);
        if (TREE_CODE (step) != INTEGER_CST)
          regular = false;
      }
      return regular;
    }

    default:
      return false;


  }

}








ipa_data_reference::~ipa_data_reference()
{
  VEC_free (tree, heap, indices.access_fns);
  
  statement_extra_info *sinfo = gimple_extra_info (stmt);
  data_reference_vector & dr_vec = sinfo->dr_vec ();
  
  dr_vec[opnd_idx] = NULL;    

  if (_reference )
    free_reference_set (_reference);
}




// compute the pattern of a dimension and save it to dimesion
void
ipa_data_reference::compute_index_pattern (tree index, gimple index_stmt, access_dimension & dimesion)
{

  index = tree_strip_nops (index);
  index = fold (index);

  switch (TREE_CODE (index))
  {

    case INTEGER_CST:
    {
    	dimesion.set_kind (pk_const);
    	dimesion.set_var (index);
    	return;
    }

    default:
    {
    	tree var, step;
    	bool regular = get_regular_index_and_step (loop_containing_stmt (index_stmt), index, var, step);
    	if (regular)
  	  {
  	    dimesion.set_kind (pk_symbolic);
  	    dimesion.set_var (var);
  	    dimesion.set_step (step);
  	    return;
  	  }

    	// can't recognize the step
    	dimesion.set_kind (pk_irregular);
    	return;
    }


    }

}

// compute the value of base and save it
// return true if addtional dimensions are appended, e.g *(p+i) when analyzing p+i
bool ipa_data_reference::compute_base_pattern (tree base, gimple base_stmt)
{

	base = tree_strip_nops (base);

  switch (TREE_CODE (base))
  {
    case INTEGER_CST:
    case ADDR_EXPR:
    {
      access_dimension   dimension;
      dimension.set_kind (pk_const);
      dimension.set_var (base);
      _pattern.dimensions ().push_back (dimension);
      return false;
    }
    case PARM_DECL:
    case VAR_DECL:
    {
      access_dimension   dimension;
      dimension.set_kind (pk_symbolic);
      dimension.set_var (base);
      _pattern.dimensions ().push_back (dimension);
      return false;
    }

    case SSA_NAME:
    {
      // find the original form of mem                                
      /* search lhs in bounds */
      gimple def_stmt = SSA_NAME_DEF_STMT (base);
      if (is_gimple_assign (def_stmt))
      {
        tree rhs = gimple_assign_rhs_to_tree (def_stmt);
        return compute_base_pattern (rhs, def_stmt);
      }
      else
      {
        access_dimension dimension;
        dimension.set_kind (pk_symbolic);
        dimension.set_var (base);
        _pattern.dimensions ().push_back (dimension);
        return false;
      }

    }

    case COMPONENT_REF:
    case BIT_FIELD_REF:
    {
      // a.b
      tree structure = TREE_OPERAND (base, 0);
      compute_base_pattern (structure, base_stmt);

      tree field = TREE_OPERAND (base, 1);
      int offset = int_byte_position (field);
      int size = int_size_in_bytes (TREE_TYPE (field));

      access_dimension & dimension = _pattern.dimensions ().back ();
      dimension.set_offset (offset);
      dimension.set_size (size);
      return false;
    }

    case ARRAY_REF:
    {
      // a[i]
      tree array = TREE_OPERAND (base, 0);
      compute_base_pattern (array, base_stmt);

      tree index = TREE_OPERAND (base, 1);
      index = build2_stat (MULT_EXPR, size_type_node, index, array_ref_element_size (base));
      access_dimension dimension;
      compute_index_pattern (index, base_stmt, dimension);

      int size = int_cst_value (array_ref_element_size (base));
      dimension.set_size (size);
      _pattern.dimensions ().push_back (dimension);

      return false;
    }


    case MEM_REF:
    {
      // *&a
      tree scalar = is_gimple_scalar (base);
      if (scalar)
        return compute_base_pattern (scalar, base_stmt);
      // a->b
      tree structure = TREE_OPERAND (base, 0);
      bool new_dim = compute_base_pattern (structure, base_stmt);

      tree field = TREE_OPERAND (base, 1);
      int offset = int_cst_value (field);
      int size = int_size_in_bytes (TREE_TYPE (base));

      if (new_dim)
      {
        access_dimension & dimension = _pattern.dimensions ().back ();
        dimension.set_offset (offset);
        dimension.set_size (size);
      }
      else
      {
        tree index = build_int_cst (0, 0);
        access_dimension dimension;
        compute_index_pattern (index, base_stmt, dimension);
        dimension.set_offset (offset);
        dimension.set_size (size);
        _pattern.dimensions ().push_back (dimension);

      }

      return false;
    }

    case PLUS_EXPR:
    case POINTER_PLUS_EXPR:
    {
        // p+i
        tree  base_pointer = TREE_OPERAND (base, 0);
        bool  new_dim = compute_base_pattern (base_pointer, base_stmt);
        if (new_dim)
        {
          access_dimension & dimension = _pattern.dimensions ().back ();
          dimension.set_kind (pk_irregular);
        }
        else
        {
          tree index = TREE_OPERAND (base, 1);
          access_dimension dimension;
          compute_index_pattern (index, base_stmt, dimension);
          _pattern.dimensions ().push_back (dimension);
        }

        return true;
    }

    case MULT_EXPR:
    {
      access_dimension   dimension;
      dimension.set_kind (pk_irregular);
      dimension.set_var (base);
      _pattern.dimensions ().push_back (dimension);
      return false;
    }

    case BIT_AND_EXPR:
    {
      // p+i
      tree base_pointer = TREE_OPERAND (base, 0);
      return compute_base_pattern (base_pointer, base_stmt);
    }

    default:
      printf ("Unknown operator\n");
      gcc_assert (false);

  }

}


// dim[i1] + dim[i2] + ... + dim[iN]
// a[i1][i2]...[iN]
void
ipa_data_reference::compute_access_pattern (tree mem)
{

  switch (TREE_CODE (mem))
  {

    case PARM_DECL:
    case VAR_DECL:
    case RESULT_DECL:
    case SSA_NAME:
    {
      // &a[0]
      tree base = tree_build_address_expr (mem);
      compute_base_pattern (base, stmt);
      tree index = build_int_cst (0, 0);
      access_dimension dimension;
      compute_index_pattern (index, stmt, dimension);
      return;
    }


    case COMPONENT_REF:
    // a.b
    {
      tree structure = TREE_OPERAND (mem, 0);
      compute_access_pattern (structure);

      tree field = TREE_OPERAND (mem, 1);
      int offset = int_byte_position (field);
      int size = int_size_in_bytes (TREE_TYPE (field));

      access_dimension & dimension = _pattern.dimensions ().back ();
      dimension.set_offset (offset);
      dimension.set_size (size);
      return;
    }

    case BIT_FIELD_REF:
    // a.b
    {
      tree structure = TREE_OPERAND (mem, 0);
      compute_access_pattern (structure);

      int offset = int_cst_value (TREE_OPERAND (mem, 2));
      int size = int_cst_value (TREE_OPERAND (mem, 1));

      access_dimension & dimension = _pattern.dimensions ().back ();
      dimension.set_offset (offset);
      dimension.set_size (size);
      return;
    }

    case ARRAY_REF:
    {
      // a[i]
      tree array = TREE_OPERAND (mem, 0);
      compute_access_pattern (array);

      tree index = TREE_OPERAND (mem, 1);
      index = build2_stat (MULT_EXPR, size_type_node, index, array_ref_element_size (mem));
      access_dimension dimension;
      compute_index_pattern (index, stmt, dimension);

      int size = int_cst_value (array_ref_element_size (mem));
      dimension.set_size (size);
      _pattern.dimensions ().push_back (dimension);

      return;
    }


    case MEM_REF:
      // a->b or (*a).b
    {
      tree structure = TREE_OPERAND (mem, 0);
      bool new_dim = compute_base_pattern (structure, stmt);

      tree field = TREE_OPERAND (mem, 1);
      int offset = int_cst_value (field);
      int size = int_size_in_bytes (TREE_TYPE (mem));

      if (new_dim)
      {
        access_dimension & dimension = _pattern.dimensions ().back ();
        dimension.set_offset (offset);
        dimension.set_size (size);
      }
      else
      {
        tree index = build_int_cst (0, 0);
        access_dimension dimension;
        compute_index_pattern (index, stmt, dimension);
        dimension.set_offset (offset);
        dimension.set_size (size);
        _pattern.dimensions ().push_back (dimension);

      }

      return;
    }

    case VIEW_CONVERT_EXPR:
    case REALPART_EXPR:
    case IMAGPART_EXPR:
    case COMPLEX_EXPR:
    {
      tree base = TREE_OPERAND (mem, 0);
      compute_access_pattern (base);
      return;
    }


    default:
      printf ("Unknown operator\n");
      gcc_assert (false);

    }

}



/*
	The expected file format is 

	MEMOP 1 	a[i][j][k]
			FILE 1.c    FUNCTION  main    LINE 200
			PATTERN 	SYMBOLIC
			BASE	a
			DIM	1  i  STEP  1  OFFSET 0 SIZE 4
			DIM 2  j	STEP	1  OFFSET 0 SIZE 4
			DIM 3  k	STEP	1  OFFSET 0 SIZE 4			
	POSSIBLE INDEPENDENT
			LOOP 1	WAW  1 --> 5	MUST	LOOP INDEPENDENT	
			LOOP 2	RAW  1 --> 6	MAY 	LOOP INDEPENDENT
	POSSIBLE CARRIED
			LOOP 3	WAR  1 --> 7	MUST	LOOP CARRIED	
			LOOP 4	RAW  1 --> 8	MAY 	LOOP CARRIED
		
*/

void
ipa_data_reference::print (FILE * fp, int indent)
{
  if (!fp)
    return;

  if (!is_virtual())
  {    
    if (TREE_CODE (ref) == VAR_DECL && DECL_ARTIFICIAL (ref))
      return ;        
    if (TREE_CODE (ref) == SSA_NAME && DECL_ARTIFICIAL (SSA_NAME_VAR(ref)))
      return ;
  }

  print_indents (fp, indent);
  fprintf (fp, "MEMOP %d \n", slice_id());
  print_indents (fp, indent + 4);

  if (is_virtual())
    fprintf (fp, "VIRTUAL\n");
  
  print_indents (fp, indent + 4);
  if (DR_IS_READ (this))
    fprintf (fp, "READ\n");
  else
    fprintf (fp, "WRITE\n");

  //print_indents (fp, indent + 4);
  //fprintf (fp, "TYPE   ");
  //print_generic_expr(fp, TREE_TYPE(ref), 0);
  //fprintf (fp, "\n");  

  print_indents (fp, indent + 4);
  fprintf (fp, "FORM   ");
  print_generic_expr (fp, original_form, 0);

  print_indents (fp, indent + 4);
  fprintf (fp, "FILE %s    FUNCTION %s  LINE %d  BB %d\n",
            	   DECL_SOURCE_FILE (func_decl),
            	   lang_hooks.decl_printable_name (func_decl, 2),
            	   gimple_lineno (stmt),
            	   bb_uid(gimple_bb(stmt)));

  print_indents (fp, indent + 4);
  fprintf (fp, "CLASS %d \n", class_id());

  print_indents (fp, indent + 4);
  fprintf (fp, "UID %d \n", uid());

  print_indents (fp, indent + 4);
  fprintf (fp, "COUNT %.0Lf \n", count());

#if 1
  print_indents (fp, indent + 4);
  fprintf (fp, "REFERENCES  ");

  if (_reference)
  {
    if (_reference->pt.anything )
      fprintf (fp, "ANYTHING  ");
    if (_reference->pt.nonlocal )
      fprintf (fp, "NONLOCAL  ");
    if (_reference->pt.escaped )
      fprintf (fp, "ESCAPED  ");
    if (_reference->pt.ipa_escaped )
      fprintf (fp, "IPA ESCAPED  ");
    if (_reference->pt.null )
      fprintf (fp, "NOTHING  ");
      
    print_indents (fp, indent + 4);
    fprintf (fp, "references  ");
    print_var_set ( _reference->pt.vars, fp);
    fprintf (fp, "\n");
  }

  //pattern ().print (fp, 4indent + 4);
#endif

  if (!_loop_independent_deps.empty ())
  {
    fprintf (fp, "POSSIBLE INDEPENDENT\n");
  }

  // print dependencies
  for (data_dependence_set::iterator iter = _loop_independent_deps.begin ();
       iter != _loop_independent_deps.end (); ++iter)
  {
    iter->print (fp, indent + 4);
  }

  if (!_loop_carried_deps.empty ())
  {
    fprintf (fp, "POSSIBLE CARRIED\n");
  }

  // print dependencies
  for (data_dependence_set::iterator iter = _loop_carried_deps.begin ();
       iter != _loop_carried_deps.end (); ++iter)
  {
    iter->print (fp, indent + 4);
  }

  fprintf (fp, "\n");

}




void
ipa_data_reference::compute_reference_set ()
{
  if (is_virtual())
    return;
  _reference = XCNEW (ptr_info_def);
  get_reference_set (ref, _reference);
  if ( _reference->pt.vars )
  {
    bitmap_clear_bit (_reference->pt.vars, 0);  // clear nothing_id    
    bitmap_clear_bit (_reference->pt.vars, 2);  // clear readonly_id
  }
}


int
compute_access_pattern (void **slot, void *data ATTRIBUTE_UNUSED)
{

  dr_hash_entry *dr_entry = *(dr_hash_entry **) slot;

  ipa_data_reference *dr = dr_entry->dr;
  
  if ( dr->invalid() )
    return 1;
  
  switch_to_context (DR_PROC (dr));
  dr->compute_access_pattern (DR_REF (dr));
  switch_off_context ();

  int irregular = 0;
  int constant = 0;
  int symbolic = 0;
  int size = dr->pattern ().dimensions ().size () - 1;
  access_dimension_vec::iterator iter = dr->pattern ().dimensions ().begin ();
  ++iter;
  for (; iter != dr->pattern ().dimensions ().end (); ++iter)
  {
    access_dimension & dimension = *iter;
    if (dimension.kind () == pk_irregular)
      irregular++;
    else if (dimension.kind () == pk_symbolic)
      symbolic++;
    else if (dimension.kind () == pk_const)
      constant++;
  }

  pattern_kind kind = pk_no_pattern;	// not worth to be compressed
  if (constant == size)		// fully const
    kind = pk_const;
  else if (symbolic == size || irregular == 0)
    kind = pk_symbolic;
  else if (irregular > 0)
  {
    if (symbolic > 1 || constant > 1)
      kind = pk_irregular;	// try to compress
  }

  dr->pattern ().set_kind (kind);

  ALIAS_CLASS_INFO &info = alias_class_map[dr->class_id()];
  if (kind == pk_no_pattern)
    info.strided = false;

  return 1;
}


int
compute_reference_set (void **slot, void *data ATTRIBUTE_UNUSED)
{

  dr_hash_entry *dr_entry = *(dr_hash_entry **) slot;

  ipa_data_reference *dr = dr_entry->dr;
  
  if ( dr->invalid() )
    return 1;
  
  switch_to_context (DR_PROC (dr));
  dr->compute_reference_set ();
  switch_off_context ();
  return 1;
}



int
print_dr (void **slot, void *data)
{
  dr_hash_entry *dr_entry = *(dr_hash_entry **) slot;
  ipa_data_reference *dr = dr_entry->dr;
  if ( !dr->invalid() )
    dr->print ((FILE *) data);
  return 1;
}


int
count_valid_dr (void **slot, void *data ATTRIBUTE_UNUSED)
{

  dr_hash_entry *dr_entry = *(dr_hash_entry **) slot;

  ipa_data_reference *dr = dr_entry->dr;
  
  if ( !dr->invalid() )
    valid_dr_count++;
  
  return 1;
}

int
count_dr_inst (void **slot, void *data )
{

  dr_hash_entry *dr_entry = *(dr_hash_entry **) slot;

  ipa_data_reference *dr = dr_entry->dr;
  
  if ( dr->invalid() )
    return 1;

  tree ref = DR_REF(dr);
  if (TREE_CODE (ref) == VAR_DECL && DECL_ARTIFICIAL (ref))
    return 1;
      
  if (TREE_CODE (ref) == SSA_NAME && DECL_ARTIFICIAL (SSA_NAME_VAR(ref)))
    return 1;
   
  *((long double*)data) += dr->count();
  
  return 1;
}

int
count_profile_candidate (void **slot, void *data)
{

  dr_hash_entry *dr_entry = *(dr_hash_entry **) slot;

  ipa_data_reference *dr = dr_entry->dr;
  
  if ( is_profile_candidate(dr) )
  {
    dr->set_slice_id (++loop_dr_count);
    if (dr->is_read)
      bitmap_set_bit (((std::pair<bitmap, bitmap>*)data)->first, dr->uid());
    else
      bitmap_set_bit (((std::pair<bitmap, bitmap>*)data)->second, dr->uid());
  }
  
  return 1;
}



/* Frees data reference DR.  */

void
ipa_free_data_ref (ipa_data_reference_p dr)
{
  delete dr;
}

static int not_in_loop_count =0;

/* Analyzes indirect memory reference MEMREF accessed in STMT.  The reference
   is read if IS_READ is true, write otherwise.  Returns the
   ipa_data_reference description of MEMREF.  NEST is the local outermost loop of the
   loop nest in that the reference should be analyzed.  */

/* If a statement, say call, is in two sub loops simutaneously, how do we setup the loop nest vector?
   Currenly we may merge the two vectors as an UNKNOWN vector, any statement else 
   that may alias with this statement is regarded as having a dependence with it. 
   We do not perform further dependence analysis on the two. 
   We haven't finish this yet. However the merging strategy will not have any effect on the
   accuraty because we do not perform interprocedural dependence checking. */

static struct ipa_data_reference *
ipa_create_data_ref (tree memref, gimple stmt, int opnd, bool is_read,
		     tree function_decl, bool analyzable, FILE * fp)
{


  struct ipa_data_reference *dr;

  if (!is_mem_ref (memref))
    return NULL;

  switch_to_context (function_decl);


  dr = new ipa_data_reference;
  DR_STMT (dr) = stmt;
  DR_REF (dr) = memref;
  DR_IS_READ (dr) = is_read;
  DR_PROC (dr) = function_decl;
  DR_ORIG_FORM (dr) = get_original_form (memref, stmt);
  DR_OPND_IDX (dr) = opnd;

  statement_extra_info *sinfo = gimple_extra_info (stmt);
  data_reference_vector & dr_vec = sinfo->dr_vec ();

  if (dr_vec.size () != gimple_num_ops (stmt))
    dr_vec.resize (gimple_num_ops (stmt));

  dr_vec[opnd] = dr;
  dr->set_slice_id(dr->uid ());

  /* enter hash table */
  dr_hash_entry *dr_entry = XNEW (struct dr_hash_entry);
  dr_entry->id = dr->uid ();
  dr_entry->dr = NULL;
  dr_hash_entry **slot = (dr_hash_entry **) htab_find_slot (dr_hash, dr_entry, INSERT);
  gcc_assert (!*slot);
  dr_entry->dr = dr;
  *slot = dr_entry;


  if (!analyzable)
  {  
    switch_off_context ();
    return dr;
  }

  dr->analyze_innermost ();

  cgraph_node_ptr node = cgraph_get_node(function_decl);
  if ( func_extra_info(node) && func_extra_info(node)->in_loop() )
    dr->set_in_loop();
  

  struct loop *loop = loop_containing_stmt (stmt);
  if (loop_depth (loop) > 0)
    dr->set_in_loop();

  if (loop_depth (loop) > 1)
    loop = VEC_index (loop_p, loop->superloops, 1);
  
  dr_analyze_indices ((data_reference_p) dr, loop, loop_containing_stmt (stmt));

  dr_analyze_alias ((data_reference_p) dr);


  loop = loop_containing_stmt (stmt);

 
  if (bb_invalid(gimple_bb(stmt)))
  {
    dr->set_invalid();
    return dr;
  }
  else
  {
    dr->set_count( bb_count(gimple_bb(stmt)) );
  }
  
  if (loop->num)
  {
    if (is_read)
      bitmap_set_bit(loop_extra_info(loop)->dr_read, dr->uid());
    else
      bitmap_set_bit(loop_extra_info(loop)->dr_write, dr->uid());
  }

 
  if (is_read)
    bitmap_set_bit(func_extra_info(node)->dr_read, dr->uid());
  else
    bitmap_set_bit(func_extra_info(node)->dr_write, dr->uid());

  switch_off_context ();

  return dr;
}


static struct ipa_data_reference *
ipa_create_virtual_data_ref (tree memref, gimple stmt, int opnd, bool is_read, tree function_decl,  
                                    bool analyzable, FILE * fp)
{

  gcc_assert (gimple_code (stmt) == GIMPLE_CALL);

  switch_to_context (function_decl);

  struct ipa_data_reference *dr = new ipa_data_reference;

  /* read 1, write 2 */
  
  DR_STMT (dr) = stmt;
  DR_REF (dr) = memref;
  DR_IS_READ (dr) = is_read;
  DR_PROC (dr) = function_decl;
  DR_ORIG_FORM (dr) = get_original_form (memref, stmt);
  DR_OPND_IDX (dr) = opnd;
  dr->set_virtual();

  statement_extra_info *sinfo = gimple_extra_info (stmt);
  data_reference_vector & dr_vec = sinfo->dr_vec ();

  if (dr_vec.size () != gimple_num_ops (stmt))
    dr_vec.resize (gimple_num_ops (stmt));

  dr_vec[opnd] = dr;
  dr->set_slice_id(dr->uid ());

  /* enter hash table */
  dr_hash_entry *dr_entry = XNEW (struct dr_hash_entry);
  dr_entry->id = dr->uid ();
  dr_entry->dr = NULL;
  dr_hash_entry **slot = (dr_hash_entry **) htab_find_slot (dr_hash, dr_entry, INSERT);
  gcc_assert (!*slot);
  dr_entry->dr = dr;
  *slot = dr_entry;

  if (!analyzable)
  {  
    switch_off_context ();
    return dr;
  }

  cgraph_node_ptr node = cgraph_get_node(function_decl);
  if ( func_extra_info(node) && func_extra_info(node)->in_loop() )
    dr->set_in_loop();
  
  struct loop *loop = loop_containing_stmt (stmt);
  if (loop_depth (loop) > 0)
    dr->set_in_loop();

  if (loop_depth (loop) > 1)
    loop = VEC_index (loop_p, loop->superloops, 1); 

  loop = loop_containing_stmt (stmt);
 
  if (bb_invalid(gimple_bb(stmt)))
  {
    dr->set_invalid();
    return dr;
  }
  else
  {
    dr->set_count( bb_count(gimple_bb(stmt)) );
  }
  
  if (loop->num)
  {
    if (is_read)
      bitmap_set_bit(loop_extra_info(loop)->dr_read, dr->uid());
    else
      bitmap_set_bit(loop_extra_info(loop)->dr_write, dr->uid());
  }

 
  if (is_read)
    bitmap_set_bit(func_extra_info(node)->dr_read, dr->uid());
  else
    bitmap_set_bit(func_extra_info(node)->dr_write, dr->uid());

  switch_off_context ();

  return dr;
}



void 
create_implicit_state_for_lib_call(gimple stmt, bool analyzable, FILE * fp)
{

  tree decl = gimple_call_fndecl(stmt);         
  if (!decl)
    return;

  const char* name = fn_decl_name (decl);

  if ( strcmp(name, "fopen") == 0 )
  {
    tree fptr = gimple_call_arg (stmt, 0);
    ipa_create_virtual_data_ref (fptr, stmt,  1, false, current_function_decl, analyzable, fp);    
    return ;
  } 
  else if ( strcmp(name, "fclose") == 0 )
  {
    tree fptr = gimple_call_arg (stmt, 0);
    ipa_create_virtual_data_ref (fptr, stmt, 1, true, current_function_decl, analyzable, fp);    
    ipa_create_virtual_data_ref (fptr, stmt, 2, false, current_function_decl, analyzable, fp);   
    return;
  }             
  else if ( strcmp(name, "open") == 0 )
  {
    tree fd = gimple_call_lhs (stmt);
    ipa_create_virtual_data_ref (fd, stmt, 1, false, current_function_decl, analyzable, fp);    
    return;
  } 
  else if ( strcmp(name, "close") == 0 )
  {
    tree fd =gimple_call_arg (stmt, 0);
    ipa_create_virtual_data_ref (fd, stmt, 1, true, current_function_decl, analyzable, fp);    
    ipa_create_virtual_data_ref (fd, stmt, 2, false, current_function_decl, analyzable, fp);    
    return;
  }             

  /* The same declaration with __edge_ version and need to replace the original */
  
  if (DECL_FUNCTION_CODE (decl) == BUILT_IN_FWRITE ||
      DECL_FUNCTION_CODE (decl) == BUILT_IN_FPRINTF || 
      DECL_FUNCTION_CODE (decl) == BUILT_IN_FSCANF ||
      strcmp(name, "fread") == 0 || strcmp(name, "fseek") == 0 || strcmp(name, "ftell") == 0 || 
      strcmp(name, "fflush") == 0 || strcmp(name, "ferror") == 0 || strcmp(name, "feof") == 0 ||
      strcmp(name, "fgetc") == 0 || strcmp(name, "getc") == 0 || strcmp(name, "_IO_getc") == 0 ||
      strcmp(name, "rewind") == 0)
  {
    tree fptr = gimple_call_arg (stmt, 0);
    ipa_create_virtual_data_ref (fptr, stmt, 1, true, current_function_decl, analyzable, fp);    
    ipa_create_virtual_data_ref (fptr, stmt, 2, false, current_function_decl, analyzable, fp);    
  }
  else if ( strcmp(name, "fgets") == 0 )
  {
    tree fptr = gimple_call_arg (stmt, 2);
    ipa_create_virtual_data_ref (fptr, stmt, 1, true, current_function_decl, analyzable, fp);    
    ipa_create_virtual_data_ref (fptr, stmt, 2, false, current_function_decl, analyzable,  fp);    
  }
  else if (DECL_FUNCTION_CODE (decl) == BUILT_IN_VFPRINTF || 
            DECL_FUNCTION_CODE (decl) == BUILT_IN_PRINTF ||
            DECL_FUNCTION_CODE (decl) == BUILT_IN_PUTS ||
            
            DECL_FUNCTION_CODE (decl) == BUILT_IN_PUTCHAR)
  {
    // File descriptor : 0	Standard Input (stdin)
    // 1	Standard Output (stdout)
    // 2	Standard Error (stderr)
    tree fptr = integer_one_node;
    ipa_create_virtual_data_ref (fptr, stmt, 1, true, current_function_decl, analyzable, fp);    
    ipa_create_virtual_data_ref (fptr, stmt, 2, false, current_function_decl, analyzable, fp);    
  }
  else if ( DECL_FUNCTION_CODE (decl) == BUILT_IN_FPUTC ||
            DECL_FUNCTION_CODE (decl) == BUILT_IN_FPUTS ||
            strcmp(name, "ungetc") == 0 ) 
  {
    tree fptr = gimple_call_arg (stmt, 1);;
    ipa_create_virtual_data_ref (fptr, stmt, 1, true, current_function_decl, analyzable, fp);    
    ipa_create_virtual_data_ref (fptr, stmt, 2, false, current_function_decl, analyzable, fp);    
  }

  else if ( strcmp(name, "lseek") == 0 || strcmp(name, "write") == 0 || strcmp(name, "read") == 0 )
  {
    tree fd =gimple_call_arg (stmt, 0);
    ipa_create_virtual_data_ref (fd, stmt, 1, true, current_function_decl, analyzable, fp);    
    ipa_create_virtual_data_ref (fd, stmt, 2, false, current_function_decl, analyzable, fp);   
  }   

}



/* Return true when the the corresponding actual of formal parameter of callee 
	contains symbolic names defined in loop NEST.  */

static bool
ipa_loop_defines_symbols_of_callee (struct loop *nest,
				    tree callee_decl, tree formal_decl)
{

  tree actual = NULL_TREE;
  struct cgraph_node *callee;
  struct cgraph_node *caller;
  struct cgraph_edge *callsite;
  gimple call_stmt;
  unsigned count, n;
  tree parm;
  bool b;

  gcc_assert (TREE_CODE (formal_decl) == PARM_DECL);


  /* check recursion */
  if (bitmap_bit_p (formal_checked, DECL_PT_UID (formal_decl)))
    return bitmap_bit_p (formal_checked, DECL_PT_UID (formal_decl));

  if (bitmap_bit_p (formal_checking, DECL_PT_UID (formal_decl)))
    return false;

  bitmap_set_bit (formal_checking, DECL_PT_UID (formal_decl));


  /* Check from each callsite */
  callee = cgraph_get_node (callee_decl);

  for (callsite = callee->callers; callsite; callsite = callsite->next_caller)
  {

    caller = callsite->caller;

    if ( !valid_function_node_p(caller) )
      continue;

    call_stmt = callsite->call_stmt;

    /* translate formal parameter to actual */
    count = 0;
    n = gimple_call_num_args (call_stmt);

    for (parm = DECL_ARGUMENTS (callee_decl); parm;  parm = TREE_CHAIN (parm))
    {
      if ( count == n )
        break;

      int a = DECL_PT_UID(parm) ;
      int b = DECL_PT_UID(formal_decl);
      const char *formal_name = gimple_decl_printable_name(formal_decl, 2) ;
      const char *parm_name = gimple_decl_printable_name(parm, 2) ;      
      
      if ( operand_equal_p (parm, formal_decl, 0))
      {
        actual = gimple_call_arg (call_stmt, count);
        break;
      }
      
      else if ( a ==  b )
      {
        actual = gimple_call_arg (call_stmt, count);
        break;
      }

      else if ( strcmp(formal_name, parm_name) == 0  )
      {
        actual = gimple_call_arg (call_stmt, count);
        break;
      }
      count++;
    }

    if ( actual == NULL_TREE)
      return true;
    gcc_assert (actual != NULL_TREE);

    /* Check if actual is loop-invariant */
    switch_to_context (caller->decl);
    b = ipa_ref_contains_symbols_defined_in_loop (nest, actual, call_stmt);
    switch_off_context ();
    if (b)
    {
      bitmap_set_bit (formal_checked, DECL_PT_UID (formal_decl));
      bitmap_clear_bit (formal_checking, DECL_PT_UID (formal_decl));
      return b;
    }

  }

  bitmap_set_bit (formal_checked, DECL_PT_UID (formal_decl));
  bitmap_clear_bit (formal_checking, DECL_PT_UID (formal_decl));
  return false;
}



typedef struct
{
  struct loop *nest;
  bool tag;
} temp_pair;

/* DEF is a SSA_NAME.  REF is a non-aliased decl. 
	 Suppose DEF is aliased with REF.  DATA points to the 
   a loop and a tag. Check whether the DEF defines REF in loop. 
   If yes, set tag to be true. If tag is true, return */
static bool
check_def_in_loop_p (ao_ref * ref, tree def, void *data)
{
  temp_pair *p = (temp_pair *) data;
  gimple def_stmt;
  struct loop *def_loop;

  if (p->tag)
    return true;


  def_stmt = SSA_NAME_DEF_STMT (def);

  if (!def_stmt)
    return false;

  tree lhs = NULL_TREE;

  if (is_gimple_assign (def_stmt))
    lhs = gimple_assign_lhs (def_stmt);
  else if (is_gimple_call (def_stmt))
    lhs = gimple_call_lhs (def_stmt);

  if (lhs && !ipa_ref_may_alias_p (lhs, ref->ref))
    return false;

  /* If p->nest is NULL, it means checking over the whole function body */
  if (p->nest == NULL)
    {
      p->tag = true;
      return true;
    }

  def_loop = loop_containing_stmt (def_stmt);
  if (p->nest == def_loop || flow_loop_nested_p (p->nest, def_loop))
    p->tag = true;

  return p->tag;

}

static bool
ipa_check_global_defined_in_bb (basic_block bb, tree decl)
{
  gimple_stmt_iterator bsi;
  for (bsi = gsi_start_bb (bb); !gsi_end_p (bsi); gsi_next (&bsi))
  {
    gimple stmt = gsi_stmt (bsi);
    tree op0, op1, op2;

    switch (gimple_code (stmt))
    {
      case GIMPLE_ASSIGN:
      {
        op0 = gimple_assign_lhs (stmt);
        if (ipa_ref_may_alias_p (op0, decl))
          return true;

        break;
      }

      case GIMPLE_CALL:
      {

        /* return value */
        op0 = gimple_call_lhs (stmt);
        if (op0 && ipa_ref_may_alias_p (op0, decl))
          return true;

        /* call side effect */
        tree callee_decl = gimple_call_fndecl (stmt);

        // TODO: funtion pointer here
        if ( !callee_decl )
          break;

        cgraph_node_ptr node = cgraph_get_node (callee_decl);
        if ( !valid_function_node_p(node) )
          break;

        bitmap written = func_extra_info (node)->global_write;
        if (bitmap_bit_p (written, DECL_UID (decl)))
          return true;

        break;
      }

    default:
      break;
    }
  }

  return false;

}

static bool
ipa_check_global_defined_in_loop (loop_p loop, tree decl)
{
  gcc_assert (TREE_CODE (decl) == VAR_DECL);

  switch_to_context (loop_func_decl(loop));

  bool defined = false;
  basic_block bb, *bbs;
  unsigned int i;
  bbs = get_loop_body (loop);
  for (i = 0; i < loop->num_nodes; i++)
  {
    bb = bbs[i];
    if (ipa_check_global_defined_in_bb (bb, decl))
    {
      defined = true;
      break;
    }
  }

  free (bbs);

  switch_off_context();
  
  return defined;
}




/* Return true when REF contains symbolic names defined in
   NEST of func_decl.   */

bool
ipa_ref_contains_symbols_defined_in_loop (loop_p  nest, tree ref, gimple stmt)
{

  tree func_decl = loop_func_decl (nest);
  struct loop *loop = NULL;
  tree ev;
  ao_ref refd;
  gimple def_stmt;
  struct loop *def_loop;
  tree rval;
  tree base;
  int i, n;
  temp_pair tp;


  if (current_function_decl == func_decl)
    loop = nest;
  else
    loop = current_loops->tree_root;

  if (ref == NULL_TREE)
    return false;

  if (TREE_CODE (ref) == ADDR_EXPR)
    return false;

  if (is_gimple_min_invariant (ref))
    return false;

  switch (TREE_CODE (ref))
  {
    case VAR_DECL:
      if (is_global_var (ref))
        return ipa_check_global_defined_in_loop (nest, ref);
      else
      {
        if (!gimple_vuse (stmt))
          return true;
        ao_ref_init (&refd, ref);
        tp.nest = loop;
        tp.tag = false;
        walk_aliased_vdefs (&refd, gimple_vuse (stmt), check_def_in_loop_p, &tp, NULL);
        return tp.tag;
      }
      break;

    case PARM_DECL:
    {
      if (!gimple_vuse (stmt))
        return true;
      ao_ref_init (&refd, ref);
      tp.nest = loop;
      tp.tag = false;
      walk_aliased_vdefs (&refd, gimple_vuse (stmt), check_def_in_loop_p, &tp, NULL);
      if (tp.tag)
        return true;
      else
      {
        /* map ref to acutals in each callsite and look up 
           its true definition from the callsite */
        return ipa_loop_defines_symbols_of_callee (nest, func_decl, ref);
      }
    }


    case SSA_NAME:
    {
      def_stmt = SSA_NAME_DEF_STMT (ref);

      basic_block def_bb = gimple_bb (def_stmt);
      if (!def_bb)  // GIMPLE_NOP
      {
        if ( current_function_decl == func_decl )
          return false;

        if (TREE_CODE (SSA_NAME_VAR (ref)) == PARM_DECL)
          return ipa_loop_defines_symbols_of_callee (nest, func_decl, SSA_NAME_VAR (ref));
        else
          return false;
      }

      if (!flow_bb_inside_loop_p (loop, def_bb))
        return false;

      return true;
    }

    case MEM_REF:
    {
      tree base = TREE_OPERAND (ref, 0);
      if (TREE_CODE (base) == ADDR_EXPR)
      {
        base = TREE_OPERAND (base, 0);
        if (ipa_ref_contains_symbols_defined_in_loop (nest, base, stmt))
          return true;
      }
    }

    default:
    {
      n = TREE_OPERAND_LENGTH (ref);
      for (i = 0; i < n; i++)
      if (TREE_OPERAND (ref, i) &&
            ipa_ref_contains_symbols_defined_in_loop (nest,	TREE_OPERAND (ref, i), stmt))
        return true;
      return false;
      break;
    }
  }


  return true;
}



/* Returns true if the address of OBJ is invariant in LOOP.  */

bool
ipa_object_address_invariant_in_loop_p (struct loop * loop, tree obj,
					gimple stmt)
{

  loop_p ref_loop = loop_containing_stmt (stmt);
  tree func_decl = loop_func_decl (ref_loop);

  switch_to_context (func_decl);

  while (handled_component_p (obj))
    {
      if (TREE_CODE (obj) == ARRAY_REF)
	{
	  if (ipa_object_address_invariant_in_loop_p
	      (loop, TREE_OPERAND (obj, 0), stmt)
	      || ipa_ref_contains_symbols_defined_in_loop (loop,
							   TREE_OPERAND (obj,
									 1),
							   stmt))
	    {
	      switch_off_context ();
	      return false;
	    }
	}
      obj = TREE_OPERAND (obj, 0);
    }

  if (is_gimple_scalar (obj))
    {
      switch_off_context ();
      return true;
    }
  else if (TREE_CODE (obj) == MEM_REF)
    {

      bool defined_in_loop = ipa_ref_contains_symbols_defined_in_loop (loop,
								       TREE_OPERAND
								       (obj,
									0),
								       stmt);
      switch_off_context ();
      return !defined_in_loop;
    }

  gcc_assert (false);

}


void
copy_ptr_info_def (struct ptr_info_def *dst, struct ptr_info_def *src)
{
  dst->misalign = src->misalign;
  dst->align = src->align;
  dst->pt.anything = src->pt.anything;
  dst->pt.nonlocal = src->pt.nonlocal;
  dst->pt.escaped = src->pt.escaped;
  dst->pt.ipa_escaped = src->pt.ipa_escaped;
  dst->pt.null = src->pt.null;
  dst->pt.vars_contains_global = src->pt.vars_contains_global;
  dst->pt.vars_contains_restrict = src->pt.vars_contains_restrict;
  dst->pt.vars = BITMAP_ALLOC (NULL);
  bitmap_copy (dst->pt.vars, src->pt.vars);

}


/* Returns false if we can prove that data references A and B do not alias,
   true otherwise.  */

bool
ipa_ref_may_alias_p (tree ref1, tree ref2)
{

  if (operand_equal_p (ref1, ref2, 0))
    return true;

  /* It is dangerous here since we consider a and b as in one procedure. Any locals that have
     the same DECL_UIDs are regarded as the same variable */
  bool new_pt_1 = false;
  bool new_pt_2 = false;

  struct ptr_info_def *pi1 = get_reference_set (ref1);
  struct ptr_info_def *pi2 = get_reference_set (ref2);
    
  bool result = pt_solutions_intersect (&pi1->pt, &pi2->pt);

  free_reference_set (pi1);

  free_reference_set (pi2);

  return result;

}

/*kobill*/
void 
dump_statistics(FILE *file){
	if(file){
		fprintf(file, "Answered By:\n");
		fprintf(file, "\tAnderson's pta: %d\n", statistics.anderson);
		fprintf(file, "\tBootstrapping 1: %d\n", statistics.bootstrap_cnt[1]);
		fprintf(file, "\tBootstrapping 2: %d\n", statistics.bootstrap_cnt[2]);
		fprintf(file, "\tBootstrapping 3: %d\n", statistics.bootstrap_cnt[3]);
		fprintf(file, "\tBootstrapping 4: %d\n", statistics.bootstrap_cnt[4]);

		fprintf(file, "Time spend (milliseconds):\n");
		fprintf(file, "\tBootstrapping 1: %ld, \taverage = %ld/%d\n", timer[1], timer[1], cnt[1]);
		fprintf(file, "\tBootstrapping 2: %ld, \taverage = %ld/%d\n", timer[2], timer[2], cnt[2]);
		fprintf(file, "\tBootstrapping 3: %ld, \taverage = %ld/%d\n", timer[3], timer[3], cnt[3]);
		fprintf(file, "\tBootstrapping 4: %ld, \taverage = %ld/%d\n", timer[4], timer[4], cnt[4]);

		fprintf(file, "Bootstrapping answer:\n");
		fprintf(file, "\tMust_Alias: %d\n", statistics.must_alias);
		fprintf(file, "\tMust_Not_Alias: %d\n", statistics.must_not_alias);
		fprintf(file, "\tMay_Alias: %d\n", statistics.may_alias);

		fprintf(file, "varcnt = %d\n", varcnt);
	}
}

//kobill
static unsigned int
get_baseID(tree mem){
	tree base = NULL_TREE;
	switch (TREE_CODE (mem))
	{
		case VAR_DECL:
		case PARM_DECL:
		case RESULT_DECL:
        {
            base = mem;
            return look_up_var(base)+var_range;
        }  
        
		case SSA_NAME:
        {
            base = SSA_NAME_VAR (mem);
            tree lookup_p = base, p = base;
				/* For parameters, get at the points-to set for the actual parm decl.  */
            if (TREE_CODE (p) == SSA_NAME
                && (TREE_CODE (SSA_NAME_VAR (p)) == PARM_DECL  || TREE_CODE (SSA_NAME_VAR (p)) == RESULT_DECL)
                && SSA_NAME_IS_DEFAULT_DEF (p))
                lookup_p = SSA_NAME_VAR (p);
            
            return look_up_var(lookup_p)+var_range;
        }   
        
		case MEM_REF:
        {
            base = TREE_OPERAND (mem, 0);
            base = tree_strip_nops (base);
            if (TREE_CODE (base) == ADDR_EXPR)
            {
                base = TREE_OPERAND (base, 0);
                return look_up_var(base);
            }else if (TREE_CODE (base) == SSA_NAME){
                tree lookup_p = base, p = base;
					/* For parameters, get at the points-to set for the actual parm decl.  */
                if ((TREE_CODE (SSA_NAME_VAR (p)) == PARM_DECL  || TREE_CODE (SSA_NAME_VAR (p)) == RESULT_DECL)
                    && SSA_NAME_IS_DEFAULT_DEF (p))
                    lookup_p = SSA_NAME_VAR (p);

//				fprintf(stderr, "\nmem: ", TREE_CODE(mem));
//				print_tree_code(stderr, mem);
//				print_generic_expr(stderr, mem, true);
//				fprintf(stderr, "\nbase: ", TREE_CODE(base));
//				print_tree_code(stderr, base);
//				print_generic_expr(stderr, base, true);
                return look_up_var(lookup_p);
            }
            fprintf(stderr, "!!!!%d\n", TREE_CODE(base));
            print_generic_expr(stderr, base, true);
            gcc_unreachable();      
            break;
        }

		case COMPONENT_REF:
        {
				// kobill
//				fprintf(stderr, "\nmem: ", TREE_CODE(mem));
//				print_tree_code(stderr, mem);
//				print_generic_expr(stderr, mem, true);
            tree op0 = TREE_OPERAND (mem, 0);
//				fprintf(stderr, "\nop0: ", TREE_CODE(op0));
//				print_tree_code(stderr, op0);
//				print_generic_expr(stderr, op0, true);
            if (op0
                && (TREE_CODE (op0) == INDIRECT_REF
                    || (TREE_CODE (op0) == MEM_REF
                        && TREE_CODE (TREE_OPERAND (op0, 0)) != ADDR_EXPR
                        && integer_zerop (TREE_OPERAND (op0, 1))
                            /* Dump the types of INTEGER_CSTs explicitly, for we
                               can't infer them and MEM_ATTR caching will share
                               MEM_REFs with differently-typed op0s.  */
                        && TREE_CODE (TREE_OPERAND (op0, 0)) != INTEGER_CST
                            /* Same pointer types, but ignoring POINTER_TYPE vs.
                               REFERENCE_TYPE.  */
                        && (TREE_TYPE (TREE_TYPE (TREE_OPERAND (op0, 0)))
                            == TREE_TYPE (TREE_TYPE (TREE_OPERAND (op0, 1))))
                        && (TYPE_MODE (TREE_TYPE (TREE_OPERAND (op0, 0)))
                            == TYPE_MODE (TREE_TYPE (TREE_OPERAND (op0, 1))))
                        && (TYPE_REF_CAN_ALIAS_ALL (TREE_TYPE (TREE_OPERAND (op0, 0)))
                            == TYPE_REF_CAN_ALIAS_ALL (TREE_TYPE (TREE_OPERAND (op0, 1))))
                            /* Same value types ignoring qualifiers.  */
                        && (TYPE_MAIN_VARIANT (TREE_TYPE (op0))
                            == TYPE_MAIN_VARIANT
                            (TREE_TYPE (TREE_TYPE (TREE_OPERAND (op0, 1))))))))
            {
                op0 = TREE_OPERAND (op0, 0);
                if (TREE_CODE (op0) == SSA_NAME){
                    tree lookup_p = op0, p = op0;
                        /* For parameters, get at the points-to set for the actual parm decl.  */
                    if ((TREE_CODE (SSA_NAME_VAR (p)) == PARM_DECL  || TREE_CODE (SSA_NAME_VAR (p)) == RESULT_DECL)
                        && SSA_NAME_IS_DEFAULT_DEF (p))
                        lookup_p = SSA_NAME_VAR (p);
                    
                    return look_up_var(lookup_p);
                }
                return get_baseID(op0);
            }
            return get_baseID(op0);
        }
		case ARRAY_REF:
        {
//				fprintf(stderr, "\nmem: ", TREE_CODE(mem));
//				print_tree_code(stderr, mem);
//				print_generic_expr(stderr, mem, true);
            base = TREE_OPERAND (mem, 0);
//				fprintf(stderr, "\nbase: ", TREE_CODE(base));
//				print_tree_code(stderr, base);
//				print_generic_expr(stderr, base, true);
            return get_baseID(base);
        }
        
		default:
//			fprintf(stderr, "!!!!%d\n", TREE_CODE(mem));
//			print_generic_expr(stderr, mem, true);
                //gcc_unreachable();      
			return 0;
	}
}


struct checkPair{
  tree ref1, ref2;
};

inline bool
mycompare(const struct checkPair *ve1, const struct checkPair *ve2){
    if (ve1->ref1 != ve2->ref1)			
      return false;					
    if (ve1->ref2 != ve2->ref2)			
      return false;					

    return true;					
}

TB_prepare(struct checkPair, PAIR);
TB_define(PAIR, mycompare, ref1);


/* Returns false if we can prove that data references A and B do not alias,
   true otherwise.  */

bool
ipa_dr_may_alias_p (const ipa_data_reference * a, const ipa_data_reference * b)
{
  if ( a->class_id() != b->class_id() )
    return false;

  tree ref1 = DR_REF(a);
  tree ref2 = DR_REF(b);

  if (operand_equal_p (ref1, ref2, 0))
    return true;


  /* It is dangerous here since we consider a and b as in one procedure. Any locals that have
     the same DECL_UIDs are regarded as the same variable */

  struct ptr_info_def *pi1 = a->reference();
  struct ptr_info_def *pi2 = b->reference();
  struct CheckPairVar pairs;
  bool retval;

  if (!pi1 || !pi2)
    return false;  

  retval =  pt_solutions_intersect (&pi1->pt, &pi2->pt);
  
  if(bootstrap_flag && flag_ipa_pta_use_bootstrap){

  tree r1 = DR_ORIG_FORM(a);
  tree r2 = DR_ORIG_FORM(b);
  int id1 = get_baseID(ref1);
  int id2 = get_baseID(ref2);

  

  if(id1 >= var_range && id2 >= var_range)
    return retval;

  // avoid duplicate computations
  struct checkPair pair;
  if(ref1 > ref2){
    pair.ref1 = ref1;
    pair.ref2 = ref2;
  }else{
    pair.ref1 = ref2;
    pair.ref2 = ref1;
  }
  if(lookup_PAIR(&pair) == NULL){
    alloc_PAIR(&pair);
  }else{
    return retval;
  }


  FILE *comp;
  comp = fopen("mycompare.txt", "a");

  fprintf(comp, "# ");
  print_generic_expr(comp, r1, 0);
  fprintf(comp, "\t||\t");
  print_generic_expr(comp, r2, 0);
  fprintf(comp, "\t||\t");

#if(ONLY_BT4)
  // force it to execute Bootstrap4
  retval = true;
#endif

  if(retval){
	  fprintf(comp, "org: true\n");
  }else{
	  fprintf(comp, "org: false\n");
	  statistics.anderson++;
  }


  //kobill//
  if(retval){
	  pairs.num = 1;
	  if(pairs.num){
		  pairs.p1 = XNEWVEC(struct CheckPoint, pairs.num);
		  pairs.p2 = XNEWVEC(struct CheckPoint, pairs.num);
		  pairs.answer = XNEWVEC(enum alias_result, pairs.num);
	  }

	  /*	  if(pi1->pt.baseID != 0)
		  pairs.p1[0].id = pi1->pt.baseID;
	  else
		  pairs.p1[0].id = bitmap_first_set_bit(pi1->pt.vars) + var_range;
	  if(pi2->pt.baseID != 0)
		  pairs.p2[0].id = pi2->pt.baseID;
	  else
		  pairs.p2[0].id = bitmap_first_set_bit(pi2->pt.vars) + var_range;
	  */
	  pairs.p1[0].id = id1;
	  pairs.p2[0].id = id2;

	  pairs.p1[0].node = cgraph_get_node(a->func_decl);
	  pairs.p2[0].node = cgraph_get_node(b->func_decl);
	  pairs.p1[0].gsi = gsi_for_stmt(a->stmt);
	  pairs.p2[0].gsi = gsi_for_stmt(b->stmt);


	  int id;
	  id = pairs.p1[0].id;
	  if(id >= var_range)
		  fprintf(comp, "#\tcheck %s(%d), ", get_pta_name(id-var_range), id-var_range);
	  else
		  fprintf(comp, "#\tcheck *%s(%d), ", get_pta_name (id), id);
	  if(id == 0){
          fclose(comp);
		  return retval;
      }

	  id = pairs.p2[0].id;
	  if(id >= var_range)
		  fprintf(comp, "\t%s(%d)\n", get_pta_name (id-var_range), id-var_range);
	  else
		  fprintf(comp, "\t*%s(%d)\n", get_pta_name (id), id);	
	  if(id == 0){
          fclose(comp);
		  return retval;
      }

	  fprintf (comp, "#\tfunction %s, %s\n", cgraph_node_name (pairs.p1[0].node), cgraph_node_name (pairs.p2[0].node));
	  fprintf (comp, "#\tstmt1: ");
	  print_gimple_stmt(comp, a->stmt, 0, 0);
	  fprintf (comp, "#\tstmt2: ");
	  print_gimple_stmt(comp, b->stmt, 0, 0);
	  fprintf(comp, "#\tboot:\n#\t\t");

	  enum answerby ans = ipa_pta_pair_bootstrapping(&pairs, a->uid(), b->uid());
	  statistics.bootstrap_cnt[ans]++;
	  if(pairs.answer[0] != MUST_NOT_ALIAS){
		  fprintf(comp, "true\n");
		  retval = true;
	  }else{
		  fprintf(comp, "false\n");
		  retval = false;
	  }
	 
	  if(retval == false){ 
		  fprintf(comp, "#1. FILE %s  FUNCTION %s LINE %d generic_expr: \n#\t", DECL_SOURCE_FILE (a->func_decl),
				  lang_hooks.decl_printable_name (a->func_decl, 2),
				  gimple_lineno (a->stmt));
		  print_generic_expr(comp, a->original_form, 0);
		  fprintf(comp, "\n");

		  fprintf(comp, "#2. FILE %s  FUNCTION %s LINE %d generic_expr: \n#\t", DECL_SOURCE_FILE (b->func_decl),
				  lang_hooks.decl_printable_name (b->func_decl, 2),
				  gimple_lineno (b->stmt));
		  print_generic_expr(comp, b->original_form, 0);
		  fprintf(comp, "\n");
		  fprintf(comp, "%d | %d\n", a->uid(), b->uid());
	  }

	  if(ans == ANDERSON){
		  if(pairs.answer[0] == MUST_ALIAS)
			  fprintf(comp, "#(Anderson MUST_ALIAS)");
		  else
			  fprintf(comp, "#(Anderson MUST_NOT_ALIAS)");
		  statistics.anderson++;
	  }else if(pairs.answer[0] == MUST_NOT_ALIAS){
		  fprintf(comp, "#(MUST_NOT_ALIAS)");	
		  statistics.must_not_alias++;
	  } else if(pairs.answer[0] == MUST_ALIAS){
		  fprintf(comp, "#(MUST_ALIAS)");
		  statistics.must_alias++;
	  } else {
		  fprintf(comp, "#(MAY_ALIAS)");
		  statistics.may_alias++;
	  }
	  fprintf(comp, " uid: %d | %d\n", a->uid(), b->uid());

	  fprintf(comp, "#\tanswered by : %d\n", ans);

	  free(pairs.p1);
	  free(pairs.p2);
	  free(pairs.answer);
  }
  fclose(comp);
  }

  return retval;

}





/* Returns false if we can prove that data references A and B do not alias,
   true otherwise. Suppose a and b may be aliased */

static bool
ipa_dr_may_alias_in_one_iter_p (const struct ipa_data_reference *a,
				const struct ipa_data_reference *b)
{

  /* If base is not the same, then may be alised */
  tree base_a = DR_BASE_OBJECT (a);
  tree base_b = DR_BASE_OBJECT (b);

  if (!operand_equal_p (base_a, base_b, 0))
    return true;

  /* Base must be the same. Check the linear relations of array indices */

  /* Compare variable consistency. 
     1. The variable set ( variables appeard in a data reference) must be the same
     2. The SSA versions must be the same
     3. The vsym version must be the same */


  return true;


}

static bool
ipa_dr_must_not_alias_p (const struct ipa_data_reference *a,
			 const struct ipa_data_reference *b)
{
  return false;
}

static bool
ipa_dr_must_alias_p (const struct ipa_data_reference *a,
		     const struct ipa_data_reference *b)
{

  tree base_a = DR_BASE_OBJECT (a);
  tree base_b = DR_BASE_OBJECT (b);
  int i;

  tree ref_a = DR_REF (a);
  tree ref_b = DR_REF (b);

  return true;

  if (TREE_CODE (ref_a) != TREE_CODE (ref_b))
    return false;



  /* Check base */
  if (!operand_equal_p (ref_a, ref_b, 0))
    return false;

  /* Check offset */
  if (DR_NUM_DIMENSIONS (a) != DR_NUM_DIMENSIONS (b))
    return false;

  for (i = 0; i < DR_NUM_DIMENSIONS (a); i++)
    {
      if (!operand_equal_p (DR_ACCESS_FN (a, i), DR_ACCESS_FN (b, i), 0))
	return false;
    }

  /*

     RAND_DECLS;
     for (i = 0; i < 256; i++) inUse[i] = False;

     for (i = 0; i <= last; i++) {
     RAND_UPD_MASK;
     block[i] ^= RAND_MASK;
     inUse[block[i]] = True;
     }

   */


  /* Check it flow-sensitively */

  /* Symbolic check */

  /* including array arrange */

  return false;

}





/* If a is always above b in lexical order, return true; else return false */
static bool
call_lexicographic_above (tree func_decl_a, tree func_decl_b)
{

  struct cgraph_node *callee_a;
  struct cgraph_node *callee_b;
  struct cgraph_edge *callsite_a;
  struct cgraph_edge *callsite_b;
  bool order = true;

  callee_a = cgraph_get_node (func_decl_a);
  callee_b = cgraph_get_node (func_decl_b);

  for (callsite_a = callee_a->callers; callsite_a;
       callsite_a = callsite_a->next_caller)
    {
      for (callsite_b = callee_b->callers; callsite_b;
	   callsite_b = callsite_b->next_caller)
	{
	  //order = stmt_lexicographic_above (callsite_a->call_stmt, callsite_b->call_stmt);
	  if (!order)
	    return false;
	}
    }

  return true;
}

/* return true if s1 dominates s2 interprocedurally */
static bool
ipa_dominate (gimple s1, gimple s2, tree func_decl_a, tree func_decl_b)
{
  return false;
}


/* return true if s1 post dominates s2 interprocedurally */
static bool
ipa_post_dominate (gimple s1, gimple s2, tree func_decl_a, tree func_decl_b)
{
  return false;
}


/* If a is always above b in lexical order, return true; else return false */
static bool
stmt_lexicographic_above (gimple s1, gimple s2, tree func_decl_a,
			  tree func_decl_b)
{
  basic_block bb1;
  basic_block bb2;
  bool order = false;
  gimple_stmt_iterator gsi;

  if (func_decl_a != func_decl_b)
    return false;

  switch_to_context (func_decl_a);


  bb1 = gimple_bb (s1);
  bb2 = gimple_bb (s2);

  if (bb1 == bb2)
    {
      for (gsi = gsi_start_bb (bb1); !gsi_end_p (gsi); gsi_next (&gsi))
	{
	  if (gsi_stmt (gsi) == s1)
	    {
	      order = true;
	      break;
	    }
	  if (gsi_stmt (gsi) == s2)
	    {
	      order = false;
	      break;
	    }
	}
    }
  else if (dominated_by_p (CDI_DOMINATORS, bb2, bb1))
    order = true;

  switch_off_context ();
  return order;
}


/* If a is always above b in lexical order, return true; else return false */
static bool
dr_lexicographic_above (ipa_data_reference_p a, ipa_data_reference_p b)
{
  gimple s1 = DR_STMT (a);
  gimple s2 = DR_STMT (b);
  bool order = false;

  if (s1 == s2)
    return false;

  order = stmt_lexicographic_above (s1, s2, DR_PROC (a), DR_PROC (b));

  return order;

}

/* If a happens and b must happen , and vice versa */
static bool
dr_execute_simultaneous (ipa_data_reference_p a, ipa_data_reference_p b)
{
  gimple s1 = DR_STMT (a);
  gimple s2 = DR_STMT (b);
  bool order = false;

  if (s1 == s2)
    return true;

  if (ipa_dominate (s1, s2, DR_PROC (a), DR_PROC (b)) &&
      ipa_post_dominate (s2, s1, DR_PROC (b), DR_PROC (a)))
    return true;

  return false;

}


/* compute reverse dominator frontier for current_function_decl */
void
compute_control_dependence (void)
{
  basic_block bb;
  bitmap_head *dfs;
  /* Initialize reverse dominance frontier.  */
  struct func_extra_info_t *info =
    func_extra_info (cgraph_get_node (cfun->decl));
  info->reverse_dfs = XNEWVEC (bitmap_head, last_basic_block);
  dfs = info->reverse_dfs;
  FOR_EACH_BB (bb)
    bitmap_initialize (&dfs[bb->index], &bitmap_default_obstack);

  dfs = info->reverse_dfs;

  compute_reverse_dominance_frontiers (dfs);

}

void
free_control_dependence (void)
{
  /* Free allocated memory.  */
  basic_block bb;
  struct func_extra_info_t *info =
    func_extra_info ((cgraph_get_node (cfun->decl)));
  bitmap_head *dfs = info->reverse_dfs;
  FOR_EACH_BB (bb) bitmap_clear (&dfs[bb->index]);
  free (dfs);
}

/* return true if a must be executed in loop, i.e. a is on the trunk path
   of loop body */
static bool
must_execute_in_loop (loop_p loop, ipa_data_reference_p a)
{


  /* Currently do not perform interprocedure checking */
  if (loop_func_decl (loop) != DR_PROC (a))
    return false;

  switch_to_context (DR_PROC (a));

  struct func_extra_info_t *info =
    func_extra_info (cgraph_get_node (cfun->decl));

  bitmap_head *dfs = info->reverse_dfs;
  basic_block bb = gimple_bb (DR_STMT (a));
  loop_p inner = bb->loop_father;

  if (inner == loop)
    {
      switch_off_context ();
      return bitmap_bit_p (&dfs[bb->index], loop->header->index);
    }

  if (flow_loop_nested_p (loop, inner))
    {
      loop_p father = inner;
      while (bitmap_bit_p (&dfs[bb->index], father->header->index))
	{
	  if (father == loop)
	    {
	      switch_off_context ();
	      return true;
	    }
	  bb = father->header;
	  father = VEC_last (loop_p, father->superloops);
	}

    }

  switch_off_context ();
  return false;

}

/* a depends on b */
static void
enter_loop_carried_dependency (int loop, ipa_data_reference * a,
			       ipa_data_reference * b, bool must)
{

  int gid_a = a->uid ();
  int gid_b = b->uid ();
  
  ipa_dep_type type;

  if (DR_IS_WRITE (a) && DR_IS_WRITE (b))
    type = id_output_dd;

  else if (DR_IS_READ (a) && DR_IS_WRITE (b))
    type = id_flow_dd;

  else if (DR_IS_WRITE (a) && DR_IS_READ (b))
    type = id_anti_dd;

  else 
    return ;
  
  ipa_data_dependency r (gid_a, gid_b, id_loop_carried, type, loop);
  if (must)
    r.set_must (true);
  else
    r.set_must(false);
  a->loop_carried_deps ().insert (r);
  loop_carried_dependencies.insert (r);

  if (must)
    must_loop_carried_dependencies.insert (r);

}

/* a depends on b */
void
enter_loop_independent_dependency (int loop, ipa_data_reference * a,
				   ipa_data_reference * b, bool must)
{

  int gid_a = a->uid ();
  int gid_b = b->uid ();
  
  ipa_dep_type type;

  if (DR_IS_WRITE (a) && DR_IS_WRITE (b))
    type = id_output_dd;

  else if (DR_IS_READ (a) && DR_IS_WRITE (b))
    type = id_flow_dd;

  else if (DR_IS_WRITE (a) && DR_IS_READ (b))
    type = id_anti_dd;

  else 
    return ;
  
  ipa_data_dependency r (gid_a, gid_b, id_loop_independent, type, loop);
  if (must)
    r.set_must (true);
  else
    r.set_must(false);
  a->loop_independent_deps ().insert (r);
  loop_independent_dependencies.insert (r);

  if (must)
    must_loop_independent_dependencies.insert (r);

}




static tree
get_array_base (tree array)
{
  if (TREE_CODE (array) != ARRAY_REF)
    return array;

  return TREE_OPERAND (array, 0);

}

/* s1 depends on s2 */
static ddr_p
ipa_check_loop_carried_dependence (loop_p nest, const symbolic_range & s1,
				   const symbolic_range & s2)
{

  ipa_data_reference_p a = s1.dr ();
  ipa_data_reference_p b = s2.dr ();

  struct data_dependence_relation *ddr = XNEW (struct data_dependence_relation);
  DDR_A (ddr) = (data_reference_p) a;
  DDR_B (ddr) = (data_reference_p) b;
  DDR_ARE_DEPENDENT (ddr) = chrec_dont_know;


  if (DR_IS_READ (a) && DR_IS_READ (b))
  {
    DDR_ARE_DEPENDENT (ddr) = chrec_known;
    return ddr;
  }

  tree ref_a = DR_REF (a);
  tree ref_b = DR_REF (b);

  if (s1.kind () == rk_all || s2.kind () == rk_all)
  {
    if (TREE_CODE (ref_a) == ARRAY_REF && TREE_CODE (ref_b) == ARRAY_REF)
    {
      tree base_a = get_array_base (ref_a);
      tree base_b = get_array_base (ref_b);
      if (operand_equal_p (base_a, base_b, 0))
      {
        DDR_ARE_DEPENDENT (ddr) = NULL_TREE;
        return ddr;
      }
    }
  }
  else if (is_gimple_scalar (ref_a) && is_gimple_scalar (ref_b))
  {
    tree base_a = ref_a;
    tree base_b = ref_b;
    if (TREE_CODE (ref_a) == SSA_NAME && TREE_CODE (ref_b) == SSA_NAME)
    {
      base_a = SSA_NAME_VAR (ref_a);
      base_b = SSA_NAME_VAR (ref_b);
    }

    if (operand_equal_p (base_a, base_b, 0))
    {
      DDR_ARE_DEPENDENT (ddr) = NULL_TREE;
      return ddr;
    }
  }

  else				/* indirect reference */
  {
    gimple stmt_a = DR_STMT (a);
    gimple stmt_b = DR_STMT (b);
    tree orig_ref_a = DR_ORIG_FORM (a);
    tree orig_ref_b = DR_ORIG_FORM (b);

    bool inv1;
    bool inv2;
    inv1 = ipa_object_address_invariant_in_loop_p (nest, orig_ref_a, stmt_a);
    if (inv1)
    {
      inv2 = ipa_object_address_invariant_in_loop_p (nest, orig_ref_b, stmt_b);
      if (inv2)
      {
        if (operand_equal_p (orig_ref_a, orig_ref_b, 0))
      	{
      	  DDR_ARE_DEPENDENT (ddr) = NULL_TREE;
      	  return ddr;
      	}
      }
    }
  }

  /* Currently do not perform interprocedure dependence checking */
  if (loop_func_decl (nest) != DR_PROC (a)
      || loop_func_decl (nest) != DR_PROC (b))
  {
    DDR_ARE_DEPENDENT (ddr) = chrec_dont_know;
    return ddr;
  }

  if (!dr_inner_most_p (a) || !dr_inner_most_p (b))
  {
    DDR_ARE_DEPENDENT (ddr) = chrec_dont_know;
    return ddr;
  }




  switch_to_context (DR_PROC (a));

  VEC (loop_p, heap) * vloops = VEC_alloc (loop_p, heap, 3);

  /* check whether nb depends on na */

  /* If the loop nest is not well formed, or one of the data references
     is not computable, give up without spending time to compute other
     dependences.  */
  if (!find_loop_nest (nest, &vloops))
  {
    VEC_free (loop_p, heap, vloops);
    switch_off_context ();
    DDR_ARE_DEPENDENT (ddr) = chrec_dont_know;
    return ddr;
  }
  else
  {
    ddr = initialize_data_dependence_relation ((data_reference_p) a,
				     (data_reference_p) b, vloops);

    // TODO: check callsite side effect of a and b in the loop body.                
    compute_affine_dependence (ddr, nest);
    switch_off_context ();

    unsigned i, j, n = DDR_NB_LOOPS (ddr);
    lambda_vector v;
    int has_dep = 0;

    FOR_EACH_VEC_ELT (lambda_vector, DDR_DIST_VECTS (ddr), i, v)
    {
      for (j = 0; j < n; j++)
      {
        if (VEC_index (loop_p, DDR_LOOP_NEST (ddr), j) == nest && v[j] != 0)
        {
        	has_dep = 1;
        }
      }
    }

    if (!has_dep)
      DDR_ARE_DEPENDENT (ddr) = chrec_known;


    VEC_free (loop_p, heap, vloops);

    return ddr;
  }

  return ddr;

/*	Check flow-sensitively whether must or may */


/* Find a synchronized point */


/* Solve linear equation */


/* Profile accroding to dependence distance 	*/


}



/* Decide whether the loop-carried data dependences "S1 depends on S2" needs to be profiled */
static void ipa_check_loop_carried_dependences_to_be_profiled
					  (loop_p loop, const symbolic_range & s1, const symbolic_range & s2)
{

  ipa_data_reference_p a = s1.dr ();
  ipa_data_reference_p b = s2.dr ();

  bool must_alias = false;

  if (dr_profile_anytime (a) && dr_profile_anytime (b))
    return;

  bool write_a;
  bool write_b;

  alias_slice *slice_a = find_alias_slice (a->slice_id ());
  alias_slice *slice_b = find_alias_slice (b->slice_id ());

  if (!slice_a)
    write_a = !DR_IS_READ (a);
  else
    write_a = slice_a->is_write ();

  if (!slice_b)
    write_b = !DR_IS_READ (b);
  else
    write_b = slice_b->is_write ();

  if (!write_a && !write_b)
    return;


  /* If the two data references do not alias during the running of the whole program, 
     then they are independent, need not to profile.      */
  if (!ipa_dr_may_alias_p (a, b))
    return;

  struct data_dependence_relation *ddr;

  ddr = ipa_check_loop_carried_dependence (loop, s1, s2);


  /* must not dependent */
  if (DDR_ARE_DEPENDENT (ddr) == chrec_known)
  {
    XDELETE (ddr);
    return;
  }

  /* must dependent */
  if (DDR_ARE_DEPENDENT (ddr) == NULL_TREE)
  {
    XDELETE (ddr);
    enter_loop_carried_dependency (loop_uid (loop), a, b, true);
    return;
  }

  /* may dependent */
  XDELETE (ddr);
  enter_loop_carried_dependency (loop_uid (loop), a, b, false);

}




/* Entry point.  Analyze all the data references needed to be profiled.  */
static void
ipa_collect_data_references_to_be_profiled (struct loop *loop)
{

  exposed_ref_summary *exposed_refs = loop_exposed_refs (loop);
  symbolic_range_list_t::const_iterator iter1, iter2;

  // WAW
  for (iter1 = exposed_refs->up_write ().begin (); iter1 != exposed_refs->up_write ().end (); ++iter1)
  {
    for (iter2 = exposed_refs->up_write ().begin (); iter2 != exposed_refs->up_write ().end (); ++iter2)
			ipa_check_loop_carried_dependences_to_be_profiled (loop, *iter1, *iter2);
  }

  // RAW
  for (iter1 = exposed_refs->up_read ().begin (); iter1 != exposed_refs->up_read ().end (); ++iter1)
  {
    for (iter2 = exposed_refs->up_write ().begin (); iter2 != exposed_refs->up_write ().end (); ++iter2)
			ipa_check_loop_carried_dependences_to_be_profiled (loop, *iter1, *iter2);
  }

  // WAR
  for (iter1 = exposed_refs->up_write ().begin (); iter1 != exposed_refs->up_write ().end (); ++iter1)
  {
    for (iter2 = exposed_refs->up_read ().begin (); iter2 != exposed_refs->up_read ().end (); ++iter2)
			ipa_check_loop_carried_dependences_to_be_profiled (loop, *iter1, *iter2);
  }

}


void
collect_data_references_to_be_profiled (const std::set < cgraph_node_ptr >
					&scc)
{
  for (std::set < cgraph_node_ptr >::iterator siter = scc.begin ();
       siter != scc.end (); ++siter)
  {
    struct cgraph_node *cur = *siter;
    switch_to_context (cur->decl);

    loop_iterator li;
    loop_p loop;
    FOR_EACH_LOOP (li, loop, 0)
    {
			ipa_collect_data_references_to_be_profiled (loop);
			/* Clear exposed-references information */
			loop_exposed_refs (loop)->clear ();
    }
    switch_off_context ();
  }
}


void
ipa_collect_data_references_in_stmt (gimple stmt, bool analyzable, FILE * fp)
{

  tree op0, op1, op2;
  enum gimple_code stmt_code = gimple_code (stmt);
  ipa_data_reference_p dr;

  switch (stmt_code)
  {
    case GIMPLE_ASSIGN:
    {
      op0 = gimple_assign_lhs (stmt);
      op1 = gimple_assign_rhs1 (stmt);
      op2 = gimple_assign_rhs2 (stmt);

      ipa_create_data_ref (op1, stmt, 1, true, current_function_decl, analyzable, fp);
      ipa_create_data_ref (op0, stmt, 0, false, current_function_decl, analyzable, fp);

      if (op2)
        ipa_create_data_ref (op2, stmt, 2, true, current_function_decl, analyzable, fp);
      break;
    }

    case GIMPLE_COND:
    {
      op1 = gimple_cond_lhs (stmt);
      op2 = gimple_cond_rhs (stmt);
      ipa_create_data_ref (op1, stmt, 0, true, current_function_decl, analyzable, fp);
      ipa_create_data_ref (op2, stmt, 1, true, current_function_decl, analyzable, fp);
      break;
    }
    
    case GIMPLE_SWITCH:
    {
      op1 = gimple_switch_index (stmt);
      ipa_create_data_ref (op1, stmt, 0, true, current_function_decl, analyzable, fp);
      break;
    }

    case GIMPLE_CALL:
    {
      int i;
      int n = gimple_call_num_args (stmt);

      for (i = 0; i < n; i++)
      {
        op0 = gimple_call_arg (stmt, i);
        ipa_create_data_ref (op0, stmt, i + 3, true, current_function_decl, analyzable, fp);
      }

      /* return value */
      op0 = gimple_call_lhs (stmt);
      if (op0)
        ipa_create_data_ref (op0, stmt, 0, false, current_function_decl, analyzable, fp);

      create_implicit_state_for_lib_call (stmt, analyzable, fp);
      break;
    }

    
    case GIMPLE_RETURN:
    {
      op0 = gimple_return_retval (stmt);
      if (op0)
        ipa_create_data_ref (op0, stmt, 0, true, current_function_decl, analyzable, fp);
      break;
    }

    case GIMPLE_LABEL:
    case GIMPLE_PREDICT:
    case GIMPLE_DEBUG:
    CASE_GIMPLE_UPP:
      break;

    default:
      gcc_unreachable();
      break;


  }
}

static int node_in_loop = 0;

void
annotate_inside_loops ()
{

  struct cgraph_node *node;
  struct cgraph_node **order =  XCNEWVEC (struct cgraph_node *, cgraph_n_nodes);
  int order_pos = cgraph_postorder (order);
//      int order_pos = ipa_utils_reduced_inorder (order, false, true, NULL);

  int i;
  basic_block bb;
  gimple_stmt_iterator bsi;


  /* Top-down */
  for (i = 0; i < order_pos; i++)
  {
    node = order[i];

    if ( !valid_function_node_p (node) )
      continue;

    switch_to_context (node->decl);

//    printf ("function: %s\n", cgraph_node_name (node));

    func_extra_info_t *finfo = func_extra_info (node);

    std::set<loop_p>  &inner_loops = func_extra_info (node)->inner_loops;

    FOR_EACH_BB (bb)
    {
      if (inner_loops.empty() && bb->loop_depth == 0 )
        continue;

      /* inside a loop */
      for (bsi = gsi_start_bb (bb); !gsi_end_p (bsi); gsi_next (&bsi))
      {
        gimple stmt = gsi_stmt (bsi);
        if (!is_gimple_call (stmt))
          continue;

        tree callee_decl = gimple_call_fndecl (stmt);

        if (callee_decl)
        {
        	struct cgraph_node *callee = cgraph_get_node (callee_decl);
					if (func_extra_info(callee))
          {   
            if ( bb->loop_depth > 0 )
              func_extra_info (callee)->inner_loops.insert (bb->loop_father);
            else 
            {
              std::set<loop_p>	&callee_loops = func_extra_info (callee)->inner_loops;
              callee_loops.insert (inner_loops.begin(), inner_loops.end() );            
            }
          }
        }
        else
        {
        	/* Handle indirect calls.  */
        	struct cgraph_edge *e = cgraph_edge (node, stmt);
        	gcc_assert (e);
        	for (e = e->indirect_info->next; e;  e = e->indirect_info->next)
      	  {
      	    struct cgraph_node *callee = e->callee;
            if (func_extra_info(callee))
            {   
              if ( bb->loop_depth > 0 )
                func_extra_info (callee)->inner_loops.insert (bb->loop_father);
              else 
              {
                std::set<loop_p>  &callee_loops = func_extra_info (callee)->inner_loops;
                callee_loops.insert (inner_loops.begin(), inner_loops.end() );            
              }
            }
      	  }

        }

      }
    }

    switch_off_context ();

    if ( finfo->in_loop() )
      node_in_loop++;

  }

}

void
release_resouces_of_callees (const cgraph_node_ptr node)
{
  /* Release resources of callees */
  struct cgraph_edge *edge;
  for (edge = node->callees; edge; edge = edge->next_callee)
    {
      struct cgraph_node *callee = edge->callee;
      func_extra_info_t *finfo = func_extra_info (callee);
      if (!finfo)
	continue;
      if (!finfo->exposed_refs)
	continue;
      finfo->count++;
      if (finfo->count == finfo->callers)
	{
	  finfo->exposed_refs->clear ();
	  finfo->exposed_refs = NULL;
	}
    }

}






static unsigned int
collect_data_references (struct cgraph_node *node, FILE * fp)
{
  basic_block bb;
  gimple_stmt_iterator bsi;

  switch_to_context (node->decl);
  FOR_EACH_BB (bb)
  {
    for (bsi = gsi_start_bb (bb); !gsi_end_p (bsi); gsi_next (&bsi))
    {
      gimple stmt = gsi_stmt (bsi);
      ipa_collect_data_references_in_stmt (stmt, true, fp);
    }
  }

  switch_off_context ();

}


tree
ipa_create_data_references (FILE * fp)
{

  struct cgraph_node *node;
  for (node = cgraph_nodes; node; node = node->next)
  {
    if ( !valid_function_node_p(node) )
      continue;
    collect_data_references (node, fp);
  }
}





void
ipa_dump_data_references_in_stmt (gimple stmt, FILE * fp, int indent)
{

  tree op0, op1, op2;
  enum gimple_code stmt_code = gimple_code (stmt);
  ipa_data_reference_p dr;

  switch (stmt_code)
  {
	  case GIMPLE_ASSIGN:
    {
			ipa_data_reference *dr;
			dr = tree_data_reference (stmt, 1);
			if (dr)
				dr->print(fp, indent);

			dr = tree_data_reference (stmt, 2);
			if (dr)
				dr->print(fp, indent);


			dr = tree_data_reference (stmt, 0);
			if (dr)
				dr->print(fp, indent);

			break;
    }

	  case GIMPLE_COND:
    {
			ipa_data_reference *dr;
			dr = tree_data_reference (stmt, 0);
			if (dr)
				dr->print(fp, indent);

			dr = tree_data_reference (stmt, 1);
			if (dr)
				dr->print(fp, indent);


  		break;
    }

	  case GIMPLE_CALL:
    {
			int i;
			int n = gimple_call_num_args (stmt);

			for (i = 0; i < n; i++)
		  {
				dr = tree_data_reference (stmt,  i + 3);
				if (dr)
					dr->print(fp, indent);
		  }

			/* return value */
			dr = tree_data_reference (stmt, 0);
			if (dr)
				dr->print(fp, indent);

			break;
    }

	  default:
	    break;


  }
}


static unsigned int
dump_data_references (struct cgraph_node *node, FILE * fp)
{
  basic_block bb;
  gimple_stmt_iterator bsi;

  switch_to_context (node->decl);
  FOR_EACH_BB (bb)
  {
    for (bsi = gsi_start_bb (bb); !gsi_end_p (bsi); gsi_next (&bsi))
    {
			gimple stmt = gsi_stmt (bsi);
			ipa_dump_data_references_in_stmt (stmt, fp, 0);
    }
  }

  switch_off_context ();

}


void
ipa_dump_data_references (FILE * fp)
{
  if (!fp)
    return;

  struct cgraph_node *node;
  for (node = cgraph_nodes; node; node = node->next)
  {
    if ( !valid_function_node_p(node) )
      continue;
		fprintf(fp, "\n====================================\n");		
		fprintf(fp, "FUNCTION		%s\n", cgraph_node_name(node));
    dump_data_references (node, fp);
  }
}

void
ipa_dump_basic_blocks (FILE * fp)
{

  struct cgraph_node *node;
  for (node = cgraph_nodes; node; node = node->next)
  {
    if ( !valid_function_node_p(node) )
      continue;
    switch_to_context (node->decl);
    basic_block bb;
    FOR_EACH_BB (bb)
    {        
      fprintf (fp, "BB %d  in  FILE %s   FUNCTION %s  LOOP %d",
                     bb_uid(bb),
                     DECL_SOURCE_FILE (node->decl),
                     lang_hooks.decl_printable_name (node->decl, 2),
                     loop_uid (bb->loop_father) );

      gimple_seq seq = bb_seq (bb);      
      if ( gimple_seq_empty_p(seq) )
        fprintf (fp, "  empty" );
        
      if ( bb_invalid(bb) )
        fprintf (fp, "  norun" );

      fprintf (fp, "\n" );
      
    }
    switch_off_context ();
  }

}

void
ipa_dump_call_sites (FILE * fp)
{

  struct cgraph_node *node;
  for (node = cgraph_nodes; node; node = node->next)
  {
    if ( !valid_function_node_p(node) )
      continue;

    switch_to_context (node->decl);

		fprintf(fp, "\n====================================\n");		
		fprintf(fp, "FUNCTION   %s\n", cgraph_node_name(node));

    struct cgraph_edge *e, *ie;

	  /* Merge all callees */
	  for (e = node->callees; e; e = e->next_callee)
    {
      if ( !valid_function_node_p(e->callee) )
        continue;
      
      switch_to_context (e->callee->decl);
      fprintf(fp, "    calls FUNCTION   %s  at ", cgraph_node_name(e->callee));
      switch_off_context();

      loop_p loop = loop_containing_stmt(e->call_stmt);
      if (loop->num)
        fprintf (fp, "GIMPLE %lld  In LOOP %d  In FILE %s  LINE %d\n", gimple_uid(e->call_stmt), 
                    loop_uid(loop),
                    gimple_filename(e->call_stmt), gimple_lineno (e->call_stmt));
      else        
        fprintf (fp, "GIMPLE %lld   In FILE %s  LINE %d\n", gimple_uid(e->call_stmt), 
                  gimple_filename(e->call_stmt), gimple_lineno (e->call_stmt));

    }  
    
    switch_off_context();
  }
}


void
ipa_dump_loop_body (struct loop *loop, FILE *fp, int indent)
{

  print_indents (fp, indent);

  if (loop->num == 0)
  {
      fprintf (fp, "FUNCTION %s  ID  %d  In FILE %s  LINE  %d \n",
               lang_hooks.decl_printable_name (current_function_decl, 2), DECL_UID(current_function_decl),
               DECL_SOURCE_FILE (current_function_decl),
               DECL_SOURCE_LINE (current_function_decl) );
  }

  else
  {

    fprintf (fp, "LOOP %d  at  LINE  %d\n",  loop_uid (loop), loop_linenum(loop));


#if 0
  	fprintf (fp, "<<<==== START LOOP %d  In FILE %s  FUNCTION %s  LINE  %d\n ",
             loop_uid (loop), DECL_SOURCE_FILE (loop_func_decl(loop)),
        		 lang_hooks.decl_printable_name (loop_func_decl(loop), 2),
        		 loop_linenum(loop));
#endif
  }


  unsigned int i;
  basic_block bb;

  /* get loop body in post order */
  basic_block *loop_blocks;
  loop_blocks = get_loop_body_in_custom_order (loop, bb_post_order_comparator);
  loop_p inner_loop = NULL;

  bitmap visited = BITMAP_ALLOC (NULL);

  for (i = 0; i < loop->num_nodes; i++)
  {
    bb = loop_blocks[i];
    //printf("bb %d\n", bb->index);

    if (bb->loop_depth == loop_depth (loop) + 1)
    {
      inner_loop = bb->loop_father;
      if ( !bitmap_bit_p (visited, inner_loop->num) )
      {
        bitmap_set_bit (visited, inner_loop->num);    
        ipa_dump_loop_body (inner_loop, fp, indent + 4);
      }
      continue;
    }

    else // if (bb->loop_depth > loop_depth (loop) + 1)
      continue;

    gimple_stmt_iterator bsi;
    for (bsi = gsi_last_bb (bb); !gsi_end_p (bsi); gsi_prev (&bsi))
    {
      gimple stmt = gsi_stmt (bsi);

      if ( is_gimple_call(stmt) )
      {
        tree callee_decl = gimple_call_fndecl (stmt);
        if ( callee_decl )
        {
          switch_to_context (callee_decl);
          print_indents (fp, indent + 4);
          fprintf (fp, "CALLS FUNCTION %s  LINE %d\n",
                   lang_hooks.decl_printable_name (callee_decl, 2), gimple_lineno(stmt));
          switch_off_context();
        }
      }

      ipa_dump_data_references_in_stmt (stmt, fp, indent);
    }

  }


  BITMAP_FREE (visited);

  return;
  
  print_indents (fp, indent);
  
  if (loop->num == 0)
  {
    fprintf (fp, "FUNCTION ENDS\n" );
  }

  else
  {
    fprintf (fp, ">>>=== LOOP %d ENDS\n", loop_uid (loop) );
  }
}



void
ipa_dump_source_info (FILE * fp)
{

  struct cgraph_node *node;
  for (node = cgraph_nodes; node; node = node->next)
  {
    if ( !valid_function_node_p(node) )
      continue;

    switch_to_context (node->decl);

		fprintf(fp, "\n====================================\n");		

    ipa_dump_loop_body (current_loops->tree_root, fp, 0);
    
    switch_off_context();
  }
}



void ipa_update_bb_info ()
{

  struct cgraph_node *node;
  struct cgraph_node **order = XCNEWVEC (struct cgraph_node *, cgraph_n_nodes);
  int order_pos = ipa_utils_reduced_inorder (order, false, true, NULL);
  int i;

  for (i = 0; i < order_pos; i++)
  {
    node = order[i];
    if ( !valid_function_node_p (node) )
    	continue;

    switch_to_context (node->decl);

    basic_block bb;
    FOR_ALL_BB (bb)
    {
      if (bb_extra_info(bb))
        continue;
      struct bb_extra_info_t *binfo = new bb_extra_info_t();
      bb->extra_info = (unsigned long long) binfo;
      set_bb_uid(bb, ++bb_num); 
      set_bb_func(bb, node->decl);

      for (gimple_stmt_iterator gsi = gsi_start_bb (bb); !gsi_end_p (gsi); gsi_next (&gsi))
      {
        gimple stmt = gsi_stmt (gsi);
        if ( gimple_extra_info(stmt) )
          continue;
        statement_extra_info *ninfo = new statement_extra_info ();
        gimple_set_extra_info (stmt, ninfo);
        gimple_set_uid (stmt, ++guid);
      }      
    }

    switch_off_context ();
  }

  return ;
}





void ipa_update_loop_info ()
{

  struct cgraph_node *node;
  struct cgraph_node **order = XCNEWVEC (struct cgraph_node *, cgraph_n_nodes);
  int order_pos = ipa_utils_reduced_inorder (order, false, true, NULL);
  int i;

  for (i = 0; i < order_pos; i++)
  {
    node = order[i];
    if ( !valid_function_node_p (node) )
    	continue;

    switch_to_context (node->decl);

    /* Numbering loops with global ids */
    loop_iterator li;
    struct loop *loop;
    FOR_EACH_LOOP (li, loop, LI_INCLUDE_ROOT)
    {
      if (loop->num == 0)
        continue;

      if ( loop->extra_info )
        continue;
      
      struct loop_extra_info_t *info = new loop_extra_info_t;
      info->func_decl = node->decl;
      loop->extra_info = (unsigned long long) info;
      info->loop = loop;    
    
      set_loop_func_decl (loop, node->decl);
      ++loop_num;
      set_loop_uid (loop, loop_num);
      
      source_location loc = find_loop_location (loop);
      set_loop_linenum (loop, LOCATION_LINE (loc));
    
      basic_block *loop_blocks = get_loop_body(loop);
      for (int i = 0; i < loop->num_nodes; i++)
      {
        basic_block bb = loop_blocks[i];       
        for (gimple_stmt_iterator bsi = gsi_last_bb (bb); !gsi_end_p (bsi); gsi_prev (&bsi))
        {
          int line = gimple_lineno(gsi_stmt (bsi)) ;
          if ( !loop_startline(loop) )          
            set_loop_startline(loop, line);
          else if ( loop_startline(loop) > line )  
            set_loop_startline(loop, line);            
            
          if ( !loop_endline(loop) )          
            set_loop_endline(loop, line);      
          else if ( loop_endline(loop) < line )  
            set_loop_endline(loop, line);          
            
        }      
      }      
      
      /* enter hash table */            
      loop_extra_info_t **slot = (loop_extra_info_t **) htab_find_slot (loop_hash, info, INSERT);
      if (*slot)
        delete *slot;    
      *slot = info;  
    
    }

    switch_off_context ();
  }

  return ;
}



unsigned int ipa_ssa_loop_init_node (FILE * fp, cgraph_node_ptr node)
{


  gcc_assert (!current_loops);
  loop_optimizer_init (LOOPS_NORMAL | LOOPS_HAVE_RECORDED_EXITS);
  rewrite_into_loop_closed_ssa (NULL, TODO_update_ssa);
  scev_initialize ();

  /* initialize function infomation */
  gcc_assert (func_extra_info (node) == 0);
  initialize_func_extra_info (node);


  calculate_dominance_info (CDI_POST_DOMINATORS);

  struct func_extra_info_t *info = func_extra_info (node);
  info->postorder = XNEWVEC (int, last_basic_block);
  info->postorder_inverted = XNEWVEC (int, last_basic_block);
  info->n_blocks = post_order_compute (info->postorder, true, true);
  info->n_blocks_inverted = inverted_post_order_compute (info->postorder_inverted);
  gcc_assert (info->n_blocks == info->n_blocks_inverted);


  basic_block bb;
  FOR_ALL_BB (bb)
  {
    struct bb_extra_info_t *binfo = new bb_extra_info_t();
    bb->extra_info = (unsigned long long) binfo;
    set_bb_uid(bb, ++bb_num);     
    set_bb_func(bb, node->decl);
  }


  /* Build reverse function: for each basic block with BB->INDEX == K
     rev_top_order_index[K] is it's reverse topological sort number.      */
  int i;
  int bb_id;
  for (i = 0; i < info->n_blocks; i++)
  {
    bb_id = info->postorder[i];
    bb = BASIC_BLOCK (bb_id);
    bb_extra_info (bb)->postorder = i + 1;
  }
  for (i = 0; i < info->n_blocks_inverted; i++)
  {
    bb_id = info->postorder_inverted[i];
    bb = BASIC_BLOCK (bb_id);
    bb_extra_info (bb)->preorder = i + 1;
  }


  /* Numbering loops with global ids */
  loop_iterator li;
  struct loop *loop;
  FOR_EACH_LOOP (li, loop, LI_INCLUDE_ROOT)
  {
    struct loop_extra_info_t *info = new loop_extra_info_t;
    info->func_decl = node->decl;
    loop->extra_info = (unsigned long long) info;
    info->loop = loop;

    if (loop->num == 0)
      continue;

    set_loop_func_decl (loop, node->decl);
    ++loop_num;
    set_loop_uid (loop, loop_num);
    
    source_location loc = find_loop_location (loop);
    set_loop_linenum (loop, LOCATION_LINE (loc));

    basic_block *loop_blocks = get_loop_body(loop);
    for (int i = 0; i < loop->num_nodes; i++)
    {
      basic_block bb = loop_blocks[i];       
      for (gimple_stmt_iterator bsi = gsi_last_bb (bb); !gsi_end_p (bsi); gsi_prev (&bsi))
      {
        int line = gimple_lineno(gsi_stmt (bsi)) ;
        if ( !loop_startline(loop) )          
          set_loop_startline(loop, line);
        else if ( loop_startline(loop) > line )  
          set_loop_startline(loop, line);            
          
        if ( !loop_endline(loop) )          
          set_loop_endline(loop, line);      
        else if ( loop_endline(loop) < line )  
          set_loop_endline(loop, line);          
          
      }      
    }
    
    
    /* enter hash table */            
    loop_extra_info_t **slot = (loop_extra_info_t **) htab_find_slot (loop_hash, info, INSERT);
    if (*slot)
      delete *slot;

    *slot = info;

    if (fp)
    {
      fprintf (fp, "LOOP %d  FILE %s  FUNCTION  %s  LINE  %d   START %d   END %d\n ", loop_uid (loop),
             DECL_SOURCE_FILE (current_function_decl),
             lang_hooks.decl_printable_name (current_function_decl, 2),
             loop_linenum(loop), loop_startline(loop), loop_endline(loop) );
    }

  }


  
  gcc_assert (current_loops);

  
  verify_flow_info ();
  verify_dominators (CDI_DOMINATORS);
  verify_loop_structure ();
  verify_loop_closed_ssa (true);

}

unsigned int ipa_ssa_loop_init (FILE * fp)
{

  loop_num = 0;
  bb_num = 0;
//      flag_wpa = true;

  
  loop_hash = htab_create (100, hash_loop_id, eq_loop_id, hash_loop_del);

  struct cgraph_node *node;
  struct cgraph_edge *edge;
  struct cgraph_node **order = XCNEWVEC (struct cgraph_node *, cgraph_n_nodes);
  int order_pos = ipa_utils_reduced_inorder (order, false, true, NULL);
  int i;


  for (i = 0; i < order_pos; i++)
  {
    node = order[i];
    if ( !valid_function_node_p (node) )
    	continue;

    switch_to_context (node->decl);

    if (current_loops)
    {
      switch_off_context ();
      continue;
    }    

    ipa_ssa_loop_init_node (fp, node);

    switch_off_context ();
  }

  return 0;
}


unsigned int
ipa_ssa_loop_done (void)
{

  struct cgraph_node *node;
  for (node = cgraph_nodes; node; node = node->next)
  {
    if ( !valid_function_node_p(node) )
      continue;

    if (node->extra_info)
      delete (struct func_extra_info_t*)(node->extra_info);
    node->extra_info = 0;
    
    switch_to_context (node->decl);

    basic_block bb;
    FOR_ALL_BB (bb)
    {
      if ( bb->extra_info )
      {          
        delete (bb_extra_info_t*)bb->extra_info;
        bb->extra_info = 0;
      }
    }
    
    
    free_numbers_of_iterations_estimates ();
    scev_finalize ();
    loop_optimizer_finalize ();
    free_dominance_info (CDI_DOMINATORS);
    free_dominance_info (CDI_POST_DOMINATORS);
    switch_off_context ();
  }

  htab_delete (loop_hash);
  loop_hash = NULL;
  loop_num = 0;
  bb_num = 0;

  return 0;
}








unsigned int
ipa_gimple_id_assignment (FILE * fp)
{
  struct cgraph_node *node;
  basic_block bb;
  char fnname[100];
  char filename[100];


  for (node = cgraph_nodes; node; node = node->next)
  {
    if ( !valid_function_node_p(node) )
      continue;

    switch_to_context (node->decl);

    strcpy (filename, DECL_SOURCE_FILE (current_function_decl));
    strcpy (fnname, lang_hooks.decl_printable_name (current_function_decl, 2));

    FOR_EACH_BB (bb)
    {
      gimple_stmt_iterator gsi;
      for (gsi = gsi_start_bb (bb); !gsi_end_p (gsi); gsi_next (&gsi))
      {
        guid++;
        gimple stmt = gsi_stmt (gsi);
        gimple_set_uid (stmt, guid);

        statement_extra_info *info = new statement_extra_info ();
        gimple_set_extra_info (stmt, info);

        if (fp)
          fprintf (fp, "GIMPLE %lld   In FILE %s   FUNCTION  %s "
        		       "LINE %d\n", guid, gimple_filename (stmt),
        		       lang_hooks.decl_printable_name (current_function_decl, 2),
        		       gimple_lineno (stmt));

      }
    }


    switch_off_context ();
  }



  return 0;
}



void
get_reference_set (tree mem, struct ptr_info_def *pi)
{

  gcc_assert (pi != NULL);
  mem = tree_strip_nops (mem);

  tree base = NULL_TREE;
  switch (TREE_CODE (mem))
  {
    case VAR_DECL:
    case PARM_DECL:
    case RESULT_DECL:
    {
      pt_solution_reset (&pi->pt);
      pi->pt.anything = false;
      pi->pt.vars = BITMAP_ALLOC (NULL);
      base = mem;
      int bit = look_up_var(base);
      bitmap_set_bit (pi->pt.vars, bit);
      break;
    }  

    case SSA_NAME:
    {
      pt_solution_reset (&pi->pt);
      pi->pt.anything = false;
      pi->pt.vars = BITMAP_ALLOC (NULL);
      base = SSA_NAME_VAR (mem);
      int bit = look_up_var(base);

      bitmap_set_bit (pi->pt.vars, bit);
      break;
    }   

    case MEM_REF:
    {
      base = TREE_OPERAND (mem, 0);
      base = tree_strip_nops (base);

      pt_solution_reset (&pi->pt);
      pi->pt.anything = false;
      pi->pt.vars = BITMAP_ALLOC (NULL);

      if (TREE_CODE (base) == SSA_NAME)
      {
        bitmap vars = look_up_points_to_set(base);

        if ( vars )
          bitmap_copy (pi->pt.vars, vars);          
        break;
      }
      else if (TREE_CODE (base) == ADDR_EXPR)
      {
        base = TREE_OPERAND (base, 0);
        int bit = look_up_var(base);
        struct ptr_info_def base_pi;
        pt_solution_reset (&base_pi.pt);
        base_pi.pt.anything = false;
        base_pi.pt.vars = BITMAP_ALLOC (NULL);
        bitmap_set_bit (base_pi.pt.vars, bit);
        look_up_fields(mem, &base_pi, pi);  
        break;
      }      
      if (TREE_CODE (base) == INTEGER_CST)
      {
        break;
      }
      
      gcc_unreachable();      
      break;
    }
    
    case COMPONENT_REF:
    case BIT_FIELD_REF:
      {
			base = TREE_OPERAND (mem, 0);
			base = tree_strip_nops (base);
			struct ptr_info_def base_pi;
			pt_solution_reset (&base_pi.pt);
			base_pi.pt.anything = false;
			base_pi.pt.vars = BITMAP_ALLOC (NULL);
			get_reference_set (base, &base_pi);
			look_up_fields(mem, &base_pi, pi);	
			BITMAP_FREE(base_pi.pt.vars);
			break;
      }
		
    case ARRAY_REF:
    {
      base = TREE_OPERAND (mem, 0);
      get_reference_set (base, pi);
      break;
    }

   	case VIEW_CONVERT_EXPR :
	 	case REALPART_EXPR:
    case IMAGPART_EXPR:
    {
      base = TREE_OPERAND (mem, 0);
      get_reference_set (base, pi);
      break;
    }

		case STRING_CST:
			break;
    default:
      gcc_unreachable();      
      break;
  }
}




struct ptr_info_def *
get_reference_set (tree ref)
{
  ptr_info_def *_reference = XCNEW (ptr_info_def);
  get_reference_set (ref, _reference);
  if ( _reference->pt.vars )
    bitmap_clear_bit (_reference->pt.vars, 0);  // clear nothing_id
  return _reference;
}


static void
collect_global_def_use (tree ref, bitmap global)
{

  /* Get the alias set of lhs */
  switch (TREE_CODE (ref))
  {
    case MEM_REF:
    case ARRAY_REF:
    case COMPONENT_REF:
    {
      struct ptr_info_def *pi = get_reference_set (ref);
      if (pi->pt.vars)
        translate_var_set (pi->pt.vars, global);
      free_reference_set (pi);
      break;
    }
    
    case VAR_DECL:
      bitmap_set_bit (global, DECL_UID (ref));
      break;

    case SSA_NAME:
    default:
      break;

  }
}


static void
collect_global_references_in_stmt (gimple stmt, bitmap read, bitmap write)
{

  tree op0, op1, op2;
  enum gimple_code stmt_code = gimple_code (stmt);

  switch (stmt_code)
    {
    case GIMPLE_ASSIGN:
      {
	op0 = gimple_assign_lhs (stmt);
	op1 = gimple_assign_rhs1 (stmt);
	op2 = gimple_assign_rhs2 (stmt);

	collect_global_def_use (op0, write);
	collect_global_def_use (op1, read);
	if (op2)
	  collect_global_def_use (op2, read);
	break;
      }

    case GIMPLE_COND:
      {
	op1 = gimple_cond_lhs (stmt);
	op2 = gimple_cond_rhs (stmt);
	collect_global_def_use (op1, read);
	collect_global_def_use (op2, read);
	break;
      }

    case GIMPLE_CALL:
      {
	int i;
	int n = gimple_call_num_args (stmt);

	for (i = 0; i < n; i++)
	  {
	    op0 = gimple_call_arg (stmt, i);
	    collect_global_def_use (op0, read);
	  }

	/* return value */
	op0 = gimple_call_lhs (stmt);
	if (op0)
	  collect_global_def_use (op0, write);

	break;
      }

    default:
      break;
    }
}


static void
collect_global_references (cgraph_node_ptr node)
{

  basic_block bb;

  switch_to_context (node->decl);

  func_extra_info (node)->global_read = BITMAP_ALLOC (NULL);
  func_extra_info (node)->global_write = BITMAP_ALLOC (NULL);
  bitmap read = func_extra_info (node)->global_read;
  bitmap write = func_extra_info (node)->global_write;

  FOR_EACH_BB (bb)
  {
    gimple_stmt_iterator gsi;
    for (gsi = gsi_start_bb (bb); !gsi_end_p (gsi); gsi_next (&gsi))
      {
	gimple stmt = gsi_stmt (gsi);
	collect_global_references_in_stmt (stmt, read, write);
      }
  }

  switch_off_context ();
}


unsigned int
ipa_mod_ref_analysis (void)
{
  unsigned long long uid = 1;
  struct cgraph_node *node;
  char fnname[100];
  char filename[100];


  for (node = cgraph_nodes; node; node = node->next)
  {
    if ( !valid_function_node_p(node) )
      continue;

    collect_global_references (node);
  }


  /* bottom-up propagate */


  struct cgraph_node **order =
    XCNEWVEC (struct cgraph_node *, cgraph_n_nodes);
  struct cgraph_edge *e, *ie;
  int order_pos = ipa_utils_reduced_inorder (order, true, true, NULL);
  int i;


  for (int i = 0; i < order_pos ; i++)
    {
      node = order[i];

      if ( !valid_function_node_p(node) )
        continue;

      /* collect recursions */

      std::set < cgraph_node_ptr > scc;
      scc.insert (node);

      struct ipa_dfs_info *w_info = (struct ipa_dfs_info *) node->aux;
      struct cgraph_node *next = w_info->next_cycle;
      while (next)
	{
	  w_info = (struct ipa_dfs_info *) next->aux;
    if ( valid_function_node_p(next) )
	    scc.insert (next);
	  next = w_info->next_cycle;
	}

      if (scc.size () <= 1)
    	{
    	  /* Merge all callees */
    	  for (e = node->callees; e; e = e->next_callee)
        {
          if ( valid_function_node_p(e->callee) )
          {
            bitmap_ior_into (func_extra_info (node)->global_read, func_extra_info (e->callee)->global_read);
            bitmap_ior_into (func_extra_info (node)->global_write, func_extra_info (e->callee)->global_write);          
          }
        }

    	  for (e = node->indirect_calls; e; e = e->next_callee)
        {
          struct nodeList * callees = e->indirect_info->callees;
          while (callees)
          {
            if ( valid_function_node_p(callees->node) )
            {
              bitmap_ior_into (func_extra_info (node)->global_read, func_extra_info (callees->node)->global_read);
              bitmap_ior_into (func_extra_info (node)->global_write, func_extra_info (callees->node)->global_write);          
            }
            callees = callees->next;
          }
        }


    	}
      else
	{
	  /* recursive */

	  bitmap scc_read = BITMAP_ALLOC (NULL);
	  bitmap scc_write = BITMAP_ALLOC (NULL);

	  /* Merge all callees out of scc */
	  for (std::set < cgraph_node_ptr >::iterator siter = scc.begin ();
	       siter != scc.end (); ++siter)
	    {
	      struct cgraph_node *cur = *siter;
	      for (e = cur->callees; e; e = e->next_callee)
		{
      if ( !valid_function_node_p(e->callee) )
          continue;

		  bitmap_ior_into (scc_read,
				   func_extra_info (e->callee)->global_read);
		  bitmap_ior_into (scc_write,
				   func_extra_info (e->callee)->global_write);
		}
	    }


	  /* Merge all nodes inside scc */
	  for (std::set < cgraph_node_ptr >::iterator siter = scc.begin ();
	       siter != scc.end (); ++siter)
	    {
	      struct cgraph_node *cur = *siter;
	      bitmap_ior_into (scc_read, func_extra_info (cur)->global_read);
	      bitmap_ior_into (scc_write,
			       func_extra_info (cur)->global_write);
	    }


	  /* Merge the whole result to current */
	  for (std::set < cgraph_node_ptr >::iterator siter = scc.begin ();
	       siter != scc.end (); ++siter)
	    {
	      struct cgraph_node *cur = *siter;
	      bitmap_ior_into (func_extra_info (cur)->global_read, scc_read);
	      bitmap_ior_into (func_extra_info (cur)->global_write,
			       scc_write);
	    }

	}

    }

  return 0;
}

void
ipa_partition_memory_operations()
{

  const int cpuNum = 64;

  std::multimap<long long, int> weight_map;

  read_count_information ();
 	{
    unsigned long long instructions = 0;
    unsigned long long addresses = 0;


    FILE *fp = fopen ("partition.info", "w");

    /* stastistic */

    for (ALIAS_CLASS_MAP::iterator iter = alias_class_map.begin(); iter != alias_class_map.end(); ++iter )
    {
      ALIAS_CLASS_INFO &info = iter->second;  
      
      if (info.instruction_count == 0)
        continue;

      if (info.instruction_count < 0)
  			info.instruction_count = 0xffffffff;
  		
      if (info.address_count < 0)
  			info.address_count = 0xffffffff;
  			
  		instructions += info.instruction_count;
  		addresses += info.address_count;

      // sort it by instruction counts
      weight_map.insert( std::make_pair(info.address_count, iter->first) );    
    }  

    fprintf(fp, "Number of classes = %d, TOTAL INSTRUCTION COUNT=%lld   TOTAL ADDRESS COUNT=%lld\n", 
  		         (int)alias_class_map.size(), instructions, addresses );

  	int i = 1;
  	std::multimap<long long, int>::reverse_iterator iter;
    for (iter = weight_map.rbegin(); iter != weight_map.rend(); ++iter )
    {
    	if ( i == cpuNum - 1 )
  			break;
      int class_id = iter->second;
      ALIAS_CLASS_INFO &info = alias_class_map[class_id];  
      fprintf(fp, "CLASS %d   MEMOP COUNT=%d   INSTRUCTION COUNT=%lld   ADDRESS COUNT=%lld\n", 
              class_id, (int)(info.memops.size()), info.instruction_count, info.address_count);  
  		i++;
    }  

  	long long other_memops = 0;
  	long long other_instructions = 0;
  	long long Ohter_addresses = 0;
    for (; iter != weight_map.rend(); ++iter )
    {
      int class_id = iter->second;
      ALIAS_CLASS_INFO &info = alias_class_map[class_id];  
  		other_memops += info.memops.size();
  		other_instructions += info.instruction_count;
  		Ohter_addresses += info.address_count;
    }  

  	
  	if ( i == cpuNum - 1 )
  		fprintf(fp, "CLASS other 	MEMOP COUNT=%lld	 INSTRUCTION COUNT=%lld 	ADDRESS COUNT=%lld\n", 
  						 other_memops, other_instructions, Ohter_addresses);	

    fclose (fp);
  }

{
	/* sort by instrunction */

	
	unsigned long long instructions = 0;
	unsigned long long addresses = 0;
  FILE *fp = fopen ("instruction.info", "w");

  /* stastistic */

  for (ALIAS_CLASS_MAP::iterator iter = alias_class_map.begin(); iter != alias_class_map.end(); ++iter )
  {
    ALIAS_CLASS_INFO &info = iter->second;  
    
    if (info.instruction_count == 0)
      continue;

    if (info.instruction_count < 0)
			info.instruction_count = 0xffffffff;
		
    if (info.address_count < 0)
			info.address_count = 0xffffffff;
			
		if (info.address_count == 1)
			continue;

		if (info.address_count == 0)
			continue;

		instructions += info.instruction_count;
		addresses += info.address_count;


    // sort it by instruction counts
    weight_map.insert( std::make_pair(info.instruction_count, iter->first) );    
  }  

  fprintf(fp, "Number of classes = %d, TOTAL INSTRUCTION COUNT=%lld   TOTAL ADDRESS COUNT=%lld\n", 
		         (int)alias_class_map.size(), instructions, addresses );

	int i = 1;
	std::multimap<long long, int>::reverse_iterator iter;
  for (iter = weight_map.rbegin(); iter != weight_map.rend(); ++iter )
  {
  	if ( i == cpuNum - 1 )
			break;
    int class_id = iter->second;
    ALIAS_CLASS_INFO &info = alias_class_map[class_id];  
    fprintf(fp, "CLASS %d   MEMOP COUNT=%d   INSTRUCTION COUNT=%lld   ADDRESS COUNT=%lld\n", 
            class_id, (int)(info.memops.size()), info.instruction_count, info.address_count);  
		i++;
  }  

	long long other_memops = 0;
	long long other_instructions = 0;
	long long Ohter_addresses = 0;
  for (; iter != weight_map.rend(); ++iter )
  {
    int class_id = iter->second;
    ALIAS_CLASS_INFO &info = alias_class_map[class_id];  
		other_memops += info.memops.size();
		other_instructions += info.instruction_count;
		Ohter_addresses += info.address_count;
  }  

	
	if ( i == cpuNum - 1 )
		fprintf(fp, "CLASS other 	MEMOP COUNT=%lld	 INSTRUCTION COUNT=%lld 	ADDRESS COUNT=%lld\n", 
						 other_memops, other_instructions, Ohter_addresses);	

  fclose (fp);

}

}


static inline int
get_param_index (tree base, VEC(tree, heap) *parms)
{
  int i, len;

  len = VEC_length (tree, parms);
  for (i = 0; i < len; i++)
    if (VEC_index (tree, parms, i) == base)
      return i;
  gcc_unreachable ();
}

bool dereference_malloc(tree mem, std::set<tree> &points_to_malloc)
{

  mem = tree_strip_nops (mem);

  tree base = NULL_TREE;
  switch (TREE_CODE (mem))
  {
    case MEM_REF:
    {
      base = TREE_OPERAND (mem, 0);
      base = tree_strip_nops (base);
      if( points_to_malloc.find (base) != points_to_malloc.end() )
        return true;

      break;
    }
    
    case COMPONENT_REF:
    case BIT_FIELD_REF:
    {
      base = TREE_OPERAND (mem, 0);
      return dereference_malloc (base, points_to_malloc);
    }
    
    default:
      break;
  }

  return false;
}

void read_mem_allocate_func( const char *name)
{
  std::set<std::string> malloc_set, free_set;
  std::map<std::string, int> realloc_set;
  FILE *fp = fopen(name, "r");
  
  if (!fp)
    return;


  /*
     The expected file format is 

     FUNCTION sre_malloc is a malloc
     FUNCTION sre_realloc is a realloc, old pointer is 2
   */

  char *line = NULL;
  size_t len = 0;
  int bytes_read;

  while ((bytes_read = getline (&line, &len, fp)) != -1)
  {
    char str[1000];
    sscanf (line, "%s", str);

    if (strcmp (str, "FUNCTION") == 0)
    {
      // ignore "FUNCTION", 
      char name[100];
      char type[10];
      sscanf (line, "%*s %s %*s %*s %s", name, type);
      if (strcmp(type, "realloc") == 0)
      {
        int old;
        sscanf (line, "%*s %*s %*s %*s %*s %*s %*s %*s %d", &old);
        realloc_set[name] = old;        
      }
      else if (strcmp(type, "malloc") == 0)
          malloc_set.insert(name);
      else if (strcmp(type, "free") == 0)
          free_set.insert(name);
    }    

  }

  fclose(fp);

  fp = fopen("shadowmalloc.info", "w");
  struct cgraph_node *node;
  for (node = cgraph_nodes; node; node = node->next)
  {
    const char *name = cgraph_node_name(node);
    
    if (malloc_set.find(name) != malloc_set.end() )
    {
      func_extra_info(node)->flags |= FF_MALLOC;
      if (fp)
        fprintf(fp, "FUNCTION %s is a malloc\n", name);
    }
    
    else if (realloc_set.find(name) != realloc_set.end() )
    {
      func_extra_info(node)->flags |= FF_REALLOC;
      func_extra_info(node)->alloc.retalias = realloc_set[name]; 
      if (fp)
        fprintf(fp, "FUNCTION %s is a realloc, old pointer is %d\n", cgraph_node_name(node),realloc_set[name] );
    }

    else if (free_set.find(name) != free_set.end() )
    {
      func_extra_info(node)->flags |= FF_FREE;
      if (fp)
        fprintf(fp, "FUNCTION %s is a free\n", name);
    }
  }  

  fclose(fp);

}

void recognize_mem_allocate_functions(FILE *fp)
{

	struct cgraph_node **order = XCNEWVEC (struct cgraph_node *, cgraph_n_nodes);
	int order_pos = ipa_utils_reduced_inorder (order, true, true, NULL);
  for (int i = 0; i < order_pos ; i++)
	{
		struct cgraph_node *node = order[i];
    if (!valid_function_node_p (node))
			continue;

    tree fndecl = node->decl;

    tree return_decl = DECL_RESULT(fndecl);

    if (!return_decl)
      continue;

    tree return_type = TREE_TYPE(return_decl);

    if ( !POINTER_TYPE_P(return_type) )
      continue;
    
  

    switch_to_context (fndecl);

  
		int malloc_count = 0;    
    std::set<tree> points_to_malloc;
    std::set<tree> points_to_realloc;
		bool return_malloc = true;
		bool return_realloc = true;
    int realloc_parameter = -1;

    basic_block bb;
		FOR_EACH_BB (bb)
		{
			gimple_stmt_iterator gsi;

			for (gsi = gsi_start_bb (bb); !gsi_end_p (gsi); gsi_next (&gsi))
			{
				gimple stmt = gsi_stmt (gsi);
				if (is_gimple_call (stmt))
				{
					int flags = gimple_call_flags (stmt);
          tree callee_decl = gimple_call_fndecl(stmt);

       
          int n = gimple_call_num_args (stmt);          
          for (int i = 0; i < n; i++)
          {
            tree op0 = gimple_call_arg (stmt, i);
            if( points_to_malloc.find (op0) != points_to_malloc.end() )
              malloc_count++;
            else if( points_to_realloc.find (op0) != points_to_realloc.end() )
              malloc_count++;
          }       

          if (!callee_decl)
            continue;
          
					if (DECL_FUNCTION_CODE (callee_decl) == BUILT_IN_MALLOC || 
              DECL_FUNCTION_CODE (callee_decl) == BUILT_IN_CALLOC || 
              DECL_FUNCTION_CODE (callee_decl) == BUILT_IN_ALLOCA)
          {     
						malloc_count++;					                     
            tree result = gimple_call_lhs (stmt);
            points_to_malloc.insert( result );
          }
					else if (DECL_FUNCTION_CODE (callee_decl) == BUILT_IN_REALLOC)
          {     
						malloc_count++;					                     
            tree result = gimple_call_lhs (stmt);
            points_to_realloc.insert( result );
            tree oldptr = gimple_call_arg(stmt, 0);
            /* We consider directly passing a parameter to realloc only */
            if ( TREE_CODE(oldptr) == SSA_NAME )
            {
              gimple def_stmt = SSA_NAME_DEF_STMT (oldptr);
              
              basic_block def_bb = gimple_bb (def_stmt);
              if (!def_bb)  // GIMPLE_NOP
              {   
                tree parm = SSA_NAME_VAR (oldptr); 
                if (TREE_CODE (parm) == PARM_DECL)
                {
                  // record the parameter number
                  VEC (tree, heap) *parms = ipa_get_vector_of_formal_parms (fndecl);
                  realloc_parameter = get_param_index (parm, parms);
                  VEC_free (tree, heap, parms);
                }
              }
            }
          }
					else 
          {     
            cgraph_node_ptr callee = cgraph_get_node(callee_decl);
            func_extra_info_t *finfo = func_extra_info(callee);
            if (finfo && finfo->flags & FF_MALLOC)
            {     
  						malloc_count++;					            
              tree result = gimple_call_lhs (stmt);
              points_to_malloc.insert( result );
            }
            
          }

          
				}
				
				else if (is_gimple_assign(stmt))
        {
          tree rhs = gimple_assign_rhs1(stmt);
          tree lhs = gimple_assign_lhs(stmt);

          if( points_to_malloc.find (rhs) != points_to_malloc.end() )
            points_to_malloc.insert( lhs );
          else if( points_to_realloc.find (rhs) != points_to_realloc.end() )
            points_to_realloc.insert( lhs );

          if ( dereference_malloc(lhs, points_to_malloc) )
            malloc_count++;                     
          if ( dereference_malloc(lhs, points_to_realloc) )
            malloc_count++;                      

        }
        
				else if (gimple_code (stmt) == GIMPLE_RETURN && gimple_return_retval (stmt) != NULL_TREE)
        {
          tree return_val = gimple_return_retval (stmt);
          if (return_val)
          {
            if( points_to_malloc.find (return_val) == points_to_malloc.end() )
              return_malloc = false;
            if( points_to_realloc.find (return_val) == points_to_realloc.end() )
              return_realloc = false;
          }
        }       
        
			}
		}

    if (return_malloc && malloc_count == 1)
    {
      func_extra_info(node)->flags |= FF_MALLOC;
      if (fp)
        fprintf(fp, "FUNCTION %s is a malloc\n", cgraph_node_name(node));
    }

    if (return_realloc && malloc_count == 1)
    {
      func_extra_info(node)->flags |= FF_REALLOC;
      func_extra_info(node)->alloc.retalias = realloc_parameter;
      if (fp)
        fprintf(fp, "FUNCTION %s is a realloc old pointer is %d\n", cgraph_node_name(node),realloc_parameter );
    }

   
    switch_off_context();
    
	}


  // recognize free
  for (int i = 0; i < order_pos ; i++)
   {
     struct cgraph_node *node = order[i];
     if (!valid_function_node_p (node))
       continue;

     tree fndecl = node->decl;

     tree return_decl = DECL_RESULT(fndecl);

     if (return_decl)
       continue;


     switch_to_context (fndecl);

   
     bool has_free=false;

     basic_block bb;
     FOR_EACH_BB (bb)
     {
       gimple_stmt_iterator gsi;

       for (gsi = gsi_start_bb (bb); !gsi_end_p (gsi); gsi_next (&gsi))
       {
         gimple stmt = gsi_stmt (gsi);
         if (is_gimple_call (stmt))
         {
           int flags = gimple_call_flags (stmt);
           tree callee_decl = gimple_call_fndecl(stmt);         


           if (!callee_decl)
             continue;         
           
           if (DECL_FUNCTION_CODE (callee_decl) == BUILT_IN_FREE)
             has_free = true;

           cgraph_node_ptr callee = cgraph_get_node(callee_decl);
           func_extra_info_t *finfo = func_extra_info(callee);
           if (finfo && finfo->flags & FF_FREE)
             has_free = true;
           
         }
        }
     }

     if (has_free)
       func_extra_info(node)->flags |= FF_FREE;
     
     switch_off_context();
     
   }

}


extern "C"
int
func_is_malloc_p(cgraph_node_ptr node) 
{
  if (func_extra_info(node))
    return func_extra_info(node)->flags & FF_MALLOC ;
  else
    return false;
}

extern "C"
int
func_is_realloc_p(cgraph_node_ptr node) 
{
  if (func_extra_info(node))
    return func_extra_info(node)->flags & FF_REALLOC ;
  else
    return false;
}

extern "C"
int
func_realloc_src(cgraph_node_ptr node) 
{
  gcc_assert(func_is_realloc_p(node));
	return func_extra_info(node)->alloc.retalias;
}


/* s1 depends on s2 */
static ddr_p
ipa_check_loop_carried_dependence (loop_p nest, ipa_data_reference_p a,
                                      				   ipa_data_reference_p b)
{

  struct data_dependence_relation *ddr = XNEW (struct data_dependence_relation);
  DDR_A (ddr) = (data_reference_p) a;
  DDR_B (ddr) = (data_reference_p) b;
  DDR_ARE_DEPENDENT (ddr) = chrec_dont_know;


  if (DR_IS_READ (a) && DR_IS_READ (b))
  {
    DDR_ARE_DEPENDENT (ddr) = chrec_known;
    return ddr;
  }

  tree ref_a = DR_REF (a);
  tree ref_b = DR_REF (b);

    
  if (is_gimple_scalar (ref_a) && is_gimple_scalar (ref_b))
  {
    tree base_a = ref_a;
    tree base_b = ref_b;
    if (TREE_CODE (ref_a) == SSA_NAME && TREE_CODE (ref_b) == SSA_NAME)
  	{
  	  base_a = SSA_NAME_VAR (ref_a);
  	  base_b = SSA_NAME_VAR (ref_b);
  	}

    if (operand_equal_p (base_a, base_b, 0))
    {
      DDR_ARE_DEPENDENT (ddr) = NULL_TREE;
      return ddr;
    }
  }

  else				/* indirect reference */
  {
    gimple stmt_a = DR_STMT (a);
    gimple stmt_b = DR_STMT (b);
    tree orig_ref_a = DR_ORIG_FORM (a);
    tree orig_ref_b = DR_ORIG_FORM (b);

    bool inv1;
    bool inv2;
    inv1 = ipa_object_address_invariant_in_loop_p (nest, orig_ref_a, stmt_a);
    if (inv1)
    {
      inv2 = ipa_object_address_invariant_in_loop_p (nest, orig_ref_b, stmt_b);
      if (inv2)
      {
        if (operand_equal_p (orig_ref_a, orig_ref_b, 0))
      	{
      	  DDR_ARE_DEPENDENT (ddr) = NULL_TREE;
      	  return ddr;
      	}
      }
    }
  }

  /* Currently do not perform interprocedure dependence checking */
  if (loop_func_decl (nest) != DR_PROC (a)
      || loop_func_decl (nest) != DR_PROC (b))
  {
    DDR_ARE_DEPENDENT (ddr) = chrec_dont_know;
    return ddr;
  }
  

  if (!dr_inner_most_p (a) || !dr_inner_most_p (b))
  {
    DDR_ARE_DEPENDENT (ddr) = chrec_dont_know;
    return ddr;
  }

  switch_to_context (DR_PROC (a));

  
  gimple stmt_a = DR_STMT(a);
  gimple stmt_b = DR_STMT(b);

  loop_p loop_a = loop_containing_stmt(stmt_a);
  loop_p loop_b = loop_containing_stmt(stmt_b);

  if (loop_a != loop_b)
  {
    switch_off_context ();
    DDR_ARE_DEPENDENT (ddr) = chrec_dont_know;
    return ddr;
  }
    

  VEC (loop_p, heap) * vloops = VEC_alloc (loop_p, heap, 3);

  /* check whether nb depends on na */

  /* If the loop nest is not well formed, or one of the data references
     is not computable, give up without spending time to compute other
     dependences.  */
  if (!find_loop_nest (nest, &vloops))
  {
    VEC_free (loop_p, heap, vloops);
    switch_off_context ();
    DDR_ARE_DEPENDENT (ddr) = chrec_dont_know;
    return ddr;
  }
  else
  {
    ddr = initialize_data_dependence_relation ((data_reference_p) a, (data_reference_p) b, vloops);

    // TODO: check callsite side effect of a and b in the loop body.                
    compute_affine_dependence (ddr, nest);
    switch_off_context ();

    unsigned i, j, n = DDR_NB_LOOPS (ddr);
    lambda_vector v;
    int has_dep = 0;

    FOR_EACH_VEC_ELT (lambda_vector, DDR_DIST_VECTS (ddr), i, v)
    {
      for (j = 0; j < n; j++)
      {
        if (VEC_index (loop_p, DDR_LOOP_NEST (ddr), j) == nest && v[j] != 0)
        {
        	has_dep = 1;
        }
      }
    }

    if (!has_dep)
      DDR_ARE_DEPENDENT (ddr) = chrec_known;


    VEC_free (loop_p, heap, vloops);

    return ddr;
  }

  return ddr;

/*	Check flow-sensitively whether must or may */


/* Find a synchronized point */


/* Solve linear equation */


/* Profile accroding to dependence distance 	*/


}

void enter_loop_carried_dependency_with_check(loop_p loop, ipa_data_reference_p a,
				   ipa_data_reference_p b)
{
  ddr_p ddr = ipa_check_loop_carried_dependence(loop, a, b);
  /* must not dependent */
  if (DDR_ARE_DEPENDENT (ddr) == chrec_known)
  {
    XDELETE (ddr);
    return;
  }

  /* must dependent */
  if (DDR_ARE_DEPENDENT (ddr) == NULL_TREE)
  {
    XDELETE (ddr);
    enter_loop_carried_dependency (loop_uid (loop), a, b, true);
    return;
  }

  /* may dependent */
  XDELETE (ddr);
  enter_loop_carried_dependency (loop_uid (loop), a, b, false);

}

void
ipa_dr_mod_ref_analysis (void)
{
  unsigned long long uid = 1;
  struct cgraph_node *node;
  char fnname[100];
  char filename[100];


  /* bottom-up propagate */


  struct cgraph_node **order = XCNEWVEC (struct cgraph_node *, cgraph_n_nodes);
  struct cgraph_edge *e, *ie;
  int order_pos = ipa_utils_reduced_inorder (order, true, true, NULL);
  int i;


  for (int i = 0; i < order_pos ; i++)
    {
      node = order[i];

      if ( !valid_function_node_p(node) )
        continue;

      /* collect recursions */

      std::set < cgraph_node_ptr > scc;
      scc.insert (node);

      struct ipa_dfs_info *w_info = (struct ipa_dfs_info *) node->aux;
      struct cgraph_node *next = w_info->next_cycle;
      while (next)
	{
	  w_info = (struct ipa_dfs_info *) next->aux;
    if ( valid_function_node_p(next) )
	    scc.insert (next);
	  next = w_info->next_cycle;
	}

      if (scc.size () <= 1)
    	{
    	    /* Merge all callees */
    	    for (e = node->callees; e; e = e->next_callee)
    	    {
            if ( valid_function_node_p(e->callee) )
            {
      	      bitmap_ior_into (func_extra_info (node)->dr_read, func_extra_info (e->callee)->dr_read);
      	      bitmap_ior_into (func_extra_info (node)->dr_write, func_extra_info (e->callee)->dr_write);
            }
    	    }

       	  for (e = node->indirect_calls; e; e = e->next_callee)
          {
            struct nodeList * callees = e->indirect_info->callees;
            while (callees)
            {
              if ( valid_function_node_p(callees->node) )
              {
                bitmap_ior_into (func_extra_info (node)->dr_read, func_extra_info (callees->node)->dr_read);
                bitmap_ior_into (func_extra_info (node)->dr_write, func_extra_info (callees->node)->dr_write);          
              }
              callees = callees->next;
            }
          }         
          

    	}
      else
	{
	  /* recursive */

	  bitmap scc_read = BITMAP_ALLOC (NULL);
	  bitmap scc_write = BITMAP_ALLOC (NULL);

	  /* Merge all callees out of scc */
	  for (std::set < cgraph_node_ptr >::iterator siter = scc.begin ();
	       siter != scc.end (); ++siter)
	    {
	      struct cgraph_node *cur = *siter;
	      for (e = cur->callees; e; e = e->next_callee)
		{
      if ( !valid_function_node_p(e->callee) )
        continue;

		  bitmap_ior_into (scc_read,
				   func_extra_info (e->callee)->dr_read);
		  bitmap_ior_into (scc_write,
				   func_extra_info (e->callee)->dr_write);
		}
	    }


	  /* Merge all nodes inside scc */
	  for (std::set < cgraph_node_ptr >::iterator siter = scc.begin ();
	       siter != scc.end (); ++siter)
	    {
	      struct cgraph_node *cur = *siter;
	      bitmap_ior_into (scc_read, func_extra_info (cur)->dr_read);
	      bitmap_ior_into (scc_write, func_extra_info (cur)->dr_write);
	    }


	  /* Merge the whole result to current */
	  for (std::set < cgraph_node_ptr >::iterator siter = scc.begin ();
	       siter != scc.end (); ++siter)
	    {
	      struct cgraph_node *cur = *siter;
	      bitmap_ior_into (func_extra_info (cur)->dr_read, scc_read);
	      bitmap_ior_into (func_extra_info (cur)->dr_write,  scc_write);
	    }

	}

    }

}


void
ipa_collect_data_dependencies (struct loop *loop, struct cgraph_node *node, bool check, bool profile)
{
  FILE *fp = fopen("83mem", "w");

  unsigned int i;
  basic_block bb;

  /* get loop body in post order */
  basic_block *loop_blocks;
  loop_blocks = get_loop_body(loop);
  //get_loop_body_in_custom_order (loop, bb_post_order_comparator);
  loop_p inner_loop = NULL;



  bitmap visited = BITMAP_ALLOC (NULL);

  for (i = 0; i < loop->num_nodes; i++)
  {
    bb = loop_blocks[i];
    //printf("bb %d\n", bb->index);

    if (bb->loop_depth == loop_depth (loop) + 1)
    {
      inner_loop = bb->loop_father;

      /* the first time to meet this loop */
      if (!bitmap_bit_p (visited, inner_loop->num))
      {

        bitmap_set_bit (visited, inner_loop->num);
        bitmap_ior_into(loop_extra_info(loop)->dr_read, loop_extra_info(inner_loop)->dr_read);
        bitmap_ior_into(loop_extra_info(loop)->dr_write, loop_extra_info(inner_loop)->dr_write);
        bitmap_clear (loop_extra_info(inner_loop)->dr_read);
        bitmap_clear (loop_extra_info(inner_loop)->dr_write);        
      }
      continue;
    }

    else if (bb->loop_depth > loop_depth (loop) + 1)
      continue;

    gimple_stmt_iterator bsi;
    for (bsi = gsi_last_bb (bb); !gsi_end_p (bsi); gsi_prev (&bsi))
    {
      gimple stmt = gsi_stmt (bsi);

      if (!is_gimple_call(stmt))
        continue;
      
      int j;

      symbolic_range_list ranges;


      tree callee_decl = gimple_call_fndecl(stmt);         



      if (callee_decl)
      {
         cgraph_node_ptr callee = cgraph_get_node(callee_decl);
         func_extra_info_t *finfo = func_extra_info(callee);
         if (finfo)
         {
            bitmap_ior_into(loop_extra_info(loop)->dr_read, func_extra_info(callee)->dr_read);
            bitmap_ior_into(loop_extra_info(loop)->dr_write, func_extra_info(callee)->dr_write);
         }
      }
      else
      {
        /* indirect call */           
        struct cgraph_edge *e = cgraph_edge (node, stmt);        
        struct nodeList * callees = e->indirect_info->callees;
        while (callees)
        {
          if ( valid_function_node_p(callees->node) )
          {
            fprintf(fp, "%s\n", cgraph_node_name(callees->node) );
            bitmap_ior_into(loop_extra_info(loop)->dr_read, func_extra_info(callees->node)->dr_read);
            bitmap_ior_into(loop_extra_info(loop)->dr_write, func_extra_info(callees->node)->dr_write);
          }
          callees = callees->next;
        }

      }
        

    }

  }

  free (loop_blocks);
  BITMAP_FREE (visited);


  bitmap read = loop_extra_info(loop)->dr_read;
  bitmap write = loop_extra_info(loop)->dr_write;
  bitmap_iterator bi;


  //kobill//
  bootstrap_flag = true;
  TB_create(PAIR);
  FILE *comp = fopen("mycompare.txt", "w");
  fclose(comp);

  comp = fopen("mydumpfile.txt", "w");
  fclose(comp);

  if (loop->num == 0 )
  {
    bitmap_ior_into(func_extra_info(node)->dr_read, loop_extra_info(loop)->dr_read );
    bitmap_ior_into(func_extra_info(node)->dr_write, loop_extra_info(loop)->dr_write);
    bitmap_clear (loop_extra_info(loop)->dr_read);
    bitmap_clear (loop_extra_info(loop)->dr_write);        
    return;
  }

  if ( !profile )
    return;

  {
    EXECUTE_IF_SET_IN_BITMAP (write, 0, i, bi)
    {
      dr_hash_entry dr_entry;
      dr_entry.id = i;      
      dr_hash_entry **slot = (dr_hash_entry **) htab_find_slot (dr_hash, &dr_entry, NO_INSERT);
      gcc_assert (*slot);
      ipa_data_reference* dra = (**slot).dr;

      if ( TREE_CODE( DR_REF(dra) ) == SSA_NAME &&  DR_PROC(dra) != loop_func_decl(loop) )
        continue;
      
      switch_to_context(DR_PROC(dra));

      dra->print(fp,4);
      switch_off_context();
    }

  }
  fclose(fp);

  
  // RAW
  EXECUTE_IF_SET_IN_BITMAP (write, 0, i, bi)
  {

    dr_hash_entry dr_entry;
    dr_entry.id = i;      
    dr_hash_entry **slot = (dr_hash_entry **) htab_find_slot (dr_hash, &dr_entry, NO_INSERT);
    gcc_assert (*slot);
    ipa_data_reference* dra = (**slot).dr;

    if ( TREE_CODE( DR_REF(dra) ) == SSA_NAME &&  DR_PROC(dra) != loop_func_decl(loop) )
      continue;

    unsigned int j;
    bitmap_iterator vbi;
    EXECUTE_IF_SET_IN_BITMAP (read, 0, j, vbi)
    {

      dr_hash_entry dr_entry;
      dr_entry.id = j;      
      dr_hash_entry **slot = (dr_hash_entry **) htab_find_slot (dr_hash, &dr_entry, NO_INSERT);
      gcc_assert (*slot);
      ipa_data_reference* drb = (**slot).dr;

      if ( TREE_CODE( DR_REF(drb) ) == SSA_NAME &&  DR_PROC(drb) != loop_func_decl(loop) )
        continue;

      if (ipa_dr_may_alias_p (dra, drb) )
      {
         enter_loop_independent_dependency (loop_uid (loop), dra, drb, false);
         if ( check )
           enter_loop_carried_dependency_with_check (loop, dra, drb);
         else
           enter_loop_carried_dependency (loop_uid(loop), dra, drb, false);          
      }
    }
		
  }

  // WAR
  EXECUTE_IF_SET_IN_BITMAP (read, 0, i, bi)
  {

    dr_hash_entry dr_entry;
    dr_entry.id = i;      
    dr_hash_entry **slot = (dr_hash_entry **) htab_find_slot (dr_hash, &dr_entry, NO_INSERT);
    gcc_assert (*slot);
    ipa_data_reference* dra = (**slot).dr;

    if ( TREE_CODE( DR_REF(dra) ) == SSA_NAME &&  DR_PROC(dra) != loop_func_decl(loop) )
      continue;

    unsigned int j;
    bitmap_iterator vbi;
    EXECUTE_IF_SET_IN_BITMAP (write, 0, j, vbi)
    {

      dr_hash_entry dr_entry;
      dr_entry.id = j;      
      dr_hash_entry **slot = (dr_hash_entry **) htab_find_slot (dr_hash, &dr_entry, NO_INSERT);
      gcc_assert (*slot);
      ipa_data_reference* drb = (**slot).dr;

      if ( TREE_CODE( DR_REF(drb) ) == SSA_NAME &&  DR_PROC(drb) != loop_func_decl(loop) )
        continue;

      if (ipa_dr_may_alias_p (dra, drb) )
      {
        if ( check )
         enter_loop_carried_dependency_with_check (loop, dra, drb);
        else
         enter_loop_carried_dependency (loop_uid(loop), dra, drb, false);          
      }
    }
		
  }

  // WAW
  EXECUTE_IF_SET_IN_BITMAP (write, 0, i, bi)
  {

    dr_hash_entry dr_entry;
    dr_entry.id = i;      
    dr_hash_entry **slot = (dr_hash_entry **) htab_find_slot (dr_hash, &dr_entry, NO_INSERT);
    gcc_assert (*slot);
    ipa_data_reference* dra = (**slot).dr;

    if ( TREE_CODE( DR_REF(dra) ) == SSA_NAME &&  DR_PROC(dra) != loop_func_decl(loop) )
      continue;

    unsigned int j;
    bitmap_iterator vbi;
    EXECUTE_IF_SET_IN_BITMAP (write, 0, j, vbi)
    {

      dr_hash_entry dr_entry;
      dr_entry.id = j;      
      dr_hash_entry **slot = (dr_hash_entry **) htab_find_slot (dr_hash, &dr_entry, NO_INSERT);
      gcc_assert (*slot);
      ipa_data_reference* drb = (**slot).dr;

      if ( TREE_CODE( DR_REF(drb) ) == SSA_NAME &&  DR_PROC(drb) != loop_func_decl(loop) )
        continue;

      if (ipa_dr_may_alias_p (dra, drb) )
      {
         enter_loop_independent_dependency (loop_uid (loop), dra, drb, false);
         if ( check )
          enter_loop_carried_dependency_with_check (loop, dra, drb);
         else
          enter_loop_carried_dependency (loop_uid(loop), dra, drb, false);          
      }
    }
		
  }
	//kobill//
	bootstrap_flag = false;
	TB_free(PAIR);
}

extern std::set < int > loop_set;
void
ipa_collect_data_dependencies (bool check)
{

  ipa_dr_mod_ref_analysis();
  struct cgraph_node **order = XCNEWVEC (struct cgraph_node *, cgraph_n_nodes);
  int order_pos = ipa_utils_reduced_inorder (order, false, true, NULL);
  

  //struct cgraph_node **order =  XCNEWVEC (struct cgraph_node *, cgraph_n_nodes);
  //int order_pos = cgraph_postorder (order);

  int size = loop_set.size();

  bool profile_all = loop_set.find(-1) != loop_set.end();
  
  for (int i = 0; i < order_pos && size > 0 ; i++)
  {
    struct cgraph_node *node = order[i];
    if (!valid_function_node_p (node))
      continue;    

    switch_to_context(node->decl);

    loop_iterator li;
    loop_p inner_loop = NULL;
    FOR_EACH_LOOP (li, inner_loop, LI_FROM_INNERMOST)
    {

      bool profile = false;
      if ( profile_all )
        profile = true;
      else
      {    
        std::set<int>::iterator iter = loop_set.find( loop_uid(inner_loop) ) ;      
        if ( iter != loop_set.end() )
        {
          profile = true;
          size--;
        }
      }
      
      ipa_collect_data_dependencies(inner_loop, node, check, profile);        
    }

    switch_off_context();
    
  }


  free( order);

  /* kobill */
//  FILE *comp;
//  comp = fopen("mycompare.txt", "a");
 if(flag_ipa_pta_use_bootstrap)
   dump_statistics(stderr);
  //fclose(comp);
}

typedef std::vector<data_dependence_set>  edge_class_t;

int
partition_dependences (void **slot, void *data)
{
  gcc_assert( slot && data );
  
  dr_hash_entry *dr_entry = *(dr_hash_entry **) slot;
  edge_class_t  *edge_class = (edge_class_t *)data;

  data_dependence_set tmp_set;


  int id = edge_class->size();

  ipa_data_reference *dr = dr_entry->dr;

  bool indep = true;
  for (data_dependence_set::iterator iter = dr->loop_carried_deps().begin ();
       iter != dr->loop_carried_deps().end (); ++iter)
  {
    const ipa_data_dependency &dep = *iter;

    if ( dep.must() && dep.type() !=  id_flow_dd )
      continue;

    edge_class->push_back( data_dependence_set() );
    data_dependence_set &dep_set = edge_class->back();
    data_dependence_set tmp_set_1;
    if ( dep.type() ==  id_flow_dd )  // RAW
    {
      dep_set.insert (dep) ;   

      for (data_dependence_set::iterator iter2 = dr->loop_independent_deps().begin ();
           iter2 != dr->loop_independent_deps().end (); ++iter2)
      {
        const ipa_data_dependency &dep2 = *iter2;
        if ( dep2.type() ==  id_flow_dd && dep2.loop() == dep.loop() )  // RAW
        {
          dep_set.insert (dep2);
          
          if (dep2.must())
          {
            dep_set.clear();
            break;
          }
        }
      }

      if ( !dep_set.empty() )
        tmp_set.insert (dr->loop_independent_deps().begin(), dr->loop_independent_deps().end ());

      indep = false;
    }
      dep_set.insert (dep) ;
  }


  return 1; 
  
  for (data_dependence_set::iterator iter = dr->loop_independent_deps().begin ();
       iter != dr->loop_independent_deps().end (); ++iter)
  {
    const ipa_data_dependency &dep = *iter;
    if ( dep.must() )
      continue;
    if ( tmp_set.find (dep) == tmp_set.end() )
    {
      edge_class->push_back( data_dependence_set() );
      data_dependence_set &dep_set = edge_class->back();
      dep_set.insert (dep) ;
    }
  }  

  return 1;
}



// Classify one loop-carried RAW dependencies for a load and all the loop-indenpendent 
// dependencies from this load into one class. All the other dependences are classified 
// to differenct classes with one another
void
ipa_partition_dependence_edges(FILE *fp)
{

  edge_class_t  edge_class;

  /* partition_dependence_edges */
  htab_traverse (dr_hash, partition_dependences, &edge_class);

  // print
  fprintf (fp, "TOTAL %d\n", edge_class.size());
  int i=0;
  for ( edge_class_t::iterator citer = edge_class.begin(); citer != edge_class.end(); ++citer)
  {
    data_dependence_set &dep_set = *citer;
    i++;
    fprintf (fp, "CLASS %d\n", i);

    for (data_dependence_set::iterator iter = dep_set.begin(); iter != dep_set.end(); ++iter )
    {
      iter->print (fp, 4);
    }

    fprintf (fp, "\n", i);

  }  

}



void
ipa_statistic_dependence_edges()
{

  const int cpuNum = 64;

  read_count_information ();

  unsigned long long instructions = 0;
  for (ALIAS_CLASS_MAP::iterator iter = alias_class_map.begin(); iter != alias_class_map.end(); ++iter )
  {
    ALIAS_CLASS_INFO &info = iter->second;      

    if (info.instruction_count < 0)
      info.instruction_count = 0xffffffff;    
     
    instructions += info.instruction_count;  
  }  

  
 	{

    FILE *fp = fopen ("edge-indep.info", "w");

    /* stastistic */
    std::multimap<long long, std::pair<int,int> > weight_map;
    
    for (data_dependence_set::iterator iter = loop_independent_dependencies.begin(); 
          iter != loop_independent_dependencies.end(); ++iter )
    {
      const ipa_data_dependency &dep = *iter;
      if ( dep.must() )
        continue;
      ALIAS_CLASS_INFO &ainfo = alias_class_map[dep.source()];  
      ALIAS_CLASS_INFO &binfo = alias_class_map[dep.sink()];  
      // sort it by instruction counts
      weight_map.insert( std::make_pair(ainfo.address_count + binfo.address_count
                        , std::make_pair(dep.source(), dep.sink()) ) );              
    }
     

    fprintf(fp, "Number of dependence edges = %d, TOTAL INSTRUCTION COUNT=%lld \n", 
    	         (int)loop_independent_dependencies.size(), instructions );

  	std::multimap<long long, std::pair<int,int> >::reverse_iterator iter;
    for (iter = weight_map.rbegin(); iter != weight_map.rend(); ++iter )
    {
      std::pair<int,int> dep = iter->second;
      ALIAS_CLASS_INFO &ainfo = alias_class_map[dep.first];  
      ALIAS_CLASS_INFO &binfo = alias_class_map[dep.second];  
      fprintf(fp, "Edge %d  --> %d   A COUNT=%lld   B COUNT=%lld   TOTAL ADDRESS COUNT=%lld \n", 
              dep.first, dep.second, ainfo.instruction_count, binfo.instruction_count, iter->first);  
    }  

    fclose (fp);
  }

  {

    FILE *fp = fopen ("edge-carried.info", "w");

    /* stastistic */
    std::multimap<long long, std::pair<int,int> > weight_map;
    
    for (data_dependence_set::iterator iter = loop_carried_dependencies.begin(); 
          iter != loop_carried_dependencies.end(); ++iter )
    {
      const ipa_data_dependency &dep = *iter;
      if ( dep.must() )
        continue;
      ALIAS_CLASS_INFO &ainfo = alias_class_map[dep.source()];  
      ALIAS_CLASS_INFO &binfo = alias_class_map[dep.sink()];  
      // sort it by instruction counts
      weight_map.insert( std::make_pair(ainfo.address_count + binfo.address_count
                        , std::make_pair(dep.source(), dep.sink()) ) );              
    }
     

    fprintf(fp, "Number of dependence edges = %d, TOTAL INSTRUCTION COUNT=%lld \n", 
    	         (int)loop_carried_dependencies.size(), instructions );

  	std::multimap<long long, std::pair<int,int> >::reverse_iterator iter;
    for (iter = weight_map.rbegin(); iter != weight_map.rend(); ++iter )
    {
      std::pair<int,int> dep = iter->second;
      ALIAS_CLASS_INFO &ainfo = alias_class_map[dep.first];  
      ALIAS_CLASS_INFO &binfo = alias_class_map[dep.second];  
      fprintf(fp, "Edge %d  --> %d   A COUNT=%lld   B COUNT=%lld   TOTAL ADDRESS COUNT=%lld \n", 
              dep.first, dep.second, ainfo.instruction_count, binfo.instruction_count, iter->first);  
    }  

    fclose (fp);
  }


}

  
static void
collect_callees_for_proc (cgraph_node_ptr node, NODE_SET& callees )
{
  
  struct cgraph_edge *e;
  for (e = node->callees; e; e = e->next_callee)
  {
    if ( !valid_function_node_p(e->callee) )
        continue;
    if ( callees.find(e->callee) == callees.end() )
    {
      callees.insert(e->callee);
      collect_callees_for_proc (e->callee, callees);
    }    
  }

  for (e = node->indirect_calls; e; e = e->next_callee)
  {
    
    struct nodeList * possible_callees;
    for (possible_callees= e->indirect_info->callees; possible_callees; possible_callees = possible_callees->next)
    {
      if ( !valid_function_node_p(possible_callees->node) )
        continue;
      if ( callees.find(possible_callees->node) == callees.end() )
      {
        callees.insert(possible_callees->node);
        collect_callees_for_proc (possible_callees->node, callees);
      }  
    }
  }

}

int loop_dr_count=0;

void
ipa_collect_data_references_for_loop (struct loop *loop, FILE *fp)
{

  cgraph_node_ptr node = cgraph_node(loop_extra_info(loop)->func_decl);

  switch_to_context(node->decl);

  basic_block *loop_blocks;
  loop_blocks = get_loop_body(loop); 

  NODE_SET callees;
  bitmap loops = BITMAP_ALLOC (NULL);
  unsigned int i;
  for (i = 0; i < loop->num_nodes; i++)
  {    
    basic_block bb  = loop_blocks[i];

    // collect_callee;      
    for (gimple_stmt_iterator bsi = gsi_last_bb (bb); !gsi_end_p (bsi); gsi_prev (&bsi))
    {
      gimple stmt = gsi_stmt (bsi);

      if (is_gimple_call(stmt))
      {
        tree callee_decl = gimple_call_fndecl(stmt);         
        if (callee_decl)
        {
           cgraph_node_ptr callee = cgraph_get_node(callee_decl);
           if ( valid_function_node_p(callee) && callees.find(callee) == callees.end() )
           {
             callees.insert(callee);
             collect_callees_for_proc (callee, callees);           
           }
        }
        else
        {
          /* indirect call */           
          struct cgraph_edge *e = cgraph_edge (node, stmt);        
          struct nodeList * possible_callees ;
          for (possible_callees= e->indirect_info->callees; possible_callees; possible_callees = possible_callees->next)
          {
            if ( valid_function_node_p(possible_callees->node) && callees.find(possible_callees->node) == callees.end() )
            {
              callees.insert(possible_callees->node);
              collect_callees_for_proc (possible_callees->node, callees);           
            }
          }
        }
      }
    }

    if (bb->loop_depth > loop_depth (loop) )
    {
      loop_p inner_loop = bb->loop_father;    
      bitmap_set_bit (loops, inner_loop->num);
    }

  }


  free (loop_blocks);

  for (NODE_SET::iterator iter=callees.begin(); iter != callees.end(); ++iter )
  {
    func_extra_info_t *finfo = func_extra_info(*iter);
    if (finfo)
    {
       bitmap_ior_into(loop_extra_info(loop)->dr_read, finfo->dr_read);
       bitmap_ior_into(loop_extra_info(loop)->dr_write, finfo->dr_write);
    }  
  }
    

  bitmap_iterator bi;
  EXECUTE_IF_SET_IN_BITMAP (loops, 0, i, bi)
  {
    loop_extra_info_t *finfo = loop_extra_info(get_loop(i));
    if (finfo)
    {
      bitmap_ior_into(loop_extra_info(loop)->dr_read, finfo->dr_read);
      bitmap_ior_into(loop_extra_info(loop)->dr_write, finfo->dr_write);
    }

  }
  
  BITMAP_FREE (loops);  

  if (fp)
  {
    // dump dr
    fprintf(fp, "====================================================\n");
    fprintf(fp, "LOOPID  %d\n", loop_uid(loop));
    
    fprintf(fp ,"FILE %s   FUNCTION %s   LINE  %d - %d   LOOP %d\n", 
            DECL_SOURCE_FILE (current_function_decl),
            cgraph_node_name(node),
            loop_extra_info(loop)->startline,
            loop_extra_info(loop)->endline,
            loop_uid(loop));
    fprintf(fp, " CALEES\n ");
    
    for (NODE_SET::iterator iter=callees.begin(); iter != callees.end(); ++iter )
    {
      fprintf(fp, "%s   ", cgraph_node_name(*iter) );  
    }
    fprintf(fp, "\n" );  
    
    fprintf(fp, "====================================================\n");
    fprintf(fp, "READING  %d\n ", bitmap_count_bits(loop_extra_info(loop)->dr_read) );  
    EXECUTE_IF_SET_IN_BITMAP (loop_extra_info(loop)->dr_read, 0, i, bi)
    {
      ipa_data_reference *dr = ipa_get_data_ref(i);  
      if (!is_profile_candidate (dr) )
        continue;
      dr->set_slice_id(++loop_dr_count);    
      dr->print(fp, 0);
    }
    
    fprintf(fp, "====================================================\n ");
    fprintf(fp, "WRITING  %d\n ", bitmap_count_bits(loop_extra_info(loop)->dr_write) );  
    EXECUTE_IF_SET_IN_BITMAP (loop_extra_info(loop)->dr_write, 0, i, bi)
    {
      ipa_data_reference *dr = ipa_get_data_ref(i);
      if (!is_profile_candidate (dr) )
        continue;
      dr->set_slice_id(++loop_dr_count);    
      dr->print(fp, 0);
    }
  }
  
  switch_off_context();
}



void
dump_data_references_for_loop (struct loop *loop, FILE *fp)
{
  loop_dr_count = 0;
  std::pair<bitmap, bitmap> bitmap_struct = 
            std::make_pair(loop_extra_info(loop)->dr_read, loop_extra_info(loop)->dr_write);
  htab_traverse (dr_hash, count_profile_candidate, &bitmap_struct);

  cgraph_node_ptr node = cgraph_node(loop_extra_info(loop)->func_decl);
  NODE_SET callees;
  bitmap_iterator bi;
  unsigned int i;

  switch_to_context(node->decl);
    

  if (fp)
  {
    // dump dr
    fprintf(fp, "====================================================\n");
    fprintf(fp, "LOOPID  %d\n", loop_uid(loop));
    
    fprintf(fp ,"FILE %s   FUNCTION %s   LINE  %d - %d   LOOP %d\n", 
            DECL_SOURCE_FILE (current_function_decl),
            cgraph_node_name(node),
            loop_extra_info(loop)->startline,
            loop_extra_info(loop)->endline,
            loop_uid(loop));
    fprintf(fp, " CALEES\n ");
    
    for (NODE_SET::iterator iter=callees.begin(); iter != callees.end(); ++iter )
    {
      fprintf(fp, "%s   ", cgraph_node_name(*iter) );  
    }
    fprintf(fp, "\n" );  
    
    fprintf(fp, "====================================================\n");
    fprintf(fp, "READING  %d\n", bitmap_count_bits(loop_extra_info(loop)->dr_read) );  
    EXECUTE_IF_SET_IN_BITMAP (loop_extra_info(loop)->dr_read, 0, i, bi)
    {
      ipa_data_reference *dr = ipa_get_data_ref(i);  
      dr->print(fp, 0);
    }
    
    fprintf(fp, "====================================================\n ");
    fprintf(fp, "WRITING  %d\n", bitmap_count_bits(loop_extra_info(loop)->dr_write) );  
    EXECUTE_IF_SET_IN_BITMAP (loop_extra_info(loop)->dr_write, 0, i, bi)
    {
      ipa_data_reference *dr = ipa_get_data_ref(i);
      dr->print(fp, 0);
    }
  }
  
  switch_off_context();
}


const float shadow_slowdown_factor = 8;


void
ipa_update_alias_class_for_loop (struct loop *loop, FILE *fp)
{

  long double total_instruction_count = 0;
  long double loop_instruction_count = 0; 
  long double profile_candidate_instruction_count = 0;

  //extern int  count_valid_dr (void **slot, void *data ATTRIBUTE_UNUSED);
  htab_traverse (dr_hash, count_dr_inst, &total_instruction_count);    


  cgraph_node_ptr node = cgraph_node(loop_extra_info(loop)->func_decl);
  switch_to_context(node->decl);

  
  alias_class_map.clear();  

  unsigned int i;
  bitmap_iterator bi;
  EXECUTE_IF_SET_IN_BITMAP (loop_extra_info(loop)->dr_read, 0, i, bi)
  {
    ipa_data_reference *dr = ipa_get_data_ref(i);      
    tree ref = DR_REF(dr);
    if (TREE_CODE (ref) == VAR_DECL && DECL_ARTIFICIAL (ref))
      continue ;        
    if (TREE_CODE (ref) == SSA_NAME && DECL_ARTIFICIAL (SSA_NAME_VAR(ref)))
      continue ;
    loop_instruction_count += dr->count();
    if (!is_shadow_profile_candidate (dr, DR_REF(dr)) )
      continue;
    profile_candidate_instruction_count += dr->count();
    ALIAS_CLASS_INFO &info = alias_class_map[dr->class_id()];
    info.id = dr->class_id();
    info.memops.push_back (dr->slice_id());    
    info.instruction_count += dr->count();      
  }
  
  EXECUTE_IF_SET_IN_BITMAP (loop_extra_info(loop)->dr_write, 0, i, bi)
  {
    ipa_data_reference *dr = ipa_get_data_ref(i);  
    tree ref = DR_REF(dr);
    if (TREE_CODE (ref) == VAR_DECL && DECL_ARTIFICIAL (ref))
      continue ;        
    if (TREE_CODE (ref) == SSA_NAME && DECL_ARTIFICIAL (SSA_NAME_VAR(ref)))
      continue ;
    loop_instruction_count += dr->count();
    if (!is_shadow_profile_candidate (dr, DR_REF(dr)) )
      continue;
    profile_candidate_instruction_count += dr->count();
    ALIAS_CLASS_INFO &info = alias_class_map[dr->class_id()];
    info.id = dr->class_id();
    info.memops.push_back (dr->slice_id());
    info.instruction_count += dr->count()*2;
  }

  fprintf(fp, "WHOLE PROGRAM INST NUM  %Lf\n", total_instruction_count );
  fprintf(fp, "WHOLE LOOP INST NUM  %Lf\n", loop_instruction_count );
  fprintf(fp, "PROFILE CANDIDATE INST NUM  %Lf\n", profile_candidate_instruction_count );

  float slowdown = (total_instruction_count - profile_candidate_instruction_count +
                    profile_candidate_instruction_count * shadow_slowdown_factor ) / total_instruction_count;
  
  fprintf(fp, "Slowdown %0.2f\n", slowdown);

  for (ALIAS_CLASS_MAP::iterator iter = alias_class_map.begin(); iter != alias_class_map.end(); ++iter )
  {
    ALIAS_CLASS_INFO &info = iter->second;  
    fprintf(fp, "CLASS %-4d   MEMOP COUNT %-10d  INST COUNT %Lf\n", iter->first, (int)(info.memops.size()),
                  info.instruction_count);          
  }  

  fprintf(fp, "Number of classes = %d\n", alias_class_map.size());

  
  switch_off_context();
}



#if 0 
typedef std::map<tree, bitmap> TYPE_VAR_MAP;
typedef std::map<tree, tree> TYPE_TYPE_MAP;
typedef std::set<tree> TREE_SET;

TYPE_VAR_MAP type_var_map;
TREE_SET new_types;
bitmap involved_vars;
TYPE_TYPE_MAP involved_fields;


/* 
  class PROFILE
	{
    TYPE data;
    char *memops;
    int iterno;
	};
*/
static tree create_fields_of_profile (tree type)
{

  tree id1 = get_identifier ("data");
  tree fld_decl_1 = build_decl (UNKNOWN_LOCATION, FIELD_DECL, id1, ptr_type_node);

  tree id2 = get_identifier ("memops");
  tree fld_decl_2 = build_decl (UNKNOWN_LOCATION, FIELD_DECL, id2, ptr_type_node);

  tree id3 = get_identifier ("iterno");
  tree fld_decl_3 = build_decl (UNKNOWN_LOCATION, FIELD_DECL, id3, integer_type_node);

  TREE_CHAIN (fld_decl_1) = fld_decl_2;
  TREE_CHAIN (fld_decl_2) = fld_decl_3;

  return fld_decl_1;
}





/*
  Given a TYPE, promote it to a structure with additional profiling fields 
  struct {
    TYPE data;
    char *memops;
    int iterno;
  }
*/
tree promote_type_to_structure(tree scalar_type)
{


  tree name = TYPE_NAME(scalar_type);
  char buf[100];
  get_expr_string (name, buf);
  strcat(buf, "_profile");
  name = get_identifier (buf);


  tree ref = make_node (RECORD_TYPE);
  tree attributes = NULL_TREE;
  TYPE_SIZE (ref) = 0;
  decl_attributes (&ref, attributes, (int) ATTR_FLAG_TYPE_IN_PLACE);
  TYPE_PACKED (ref) = 0;


  tree fields = create_fields_of_profile ();
  for (tree x = fields; x; x = TREE_CHAIN (x))
  {
    DECL_CONTEXT (x) = ref;
    DECL_PACKED (x) |= TYPE_PACKED (ref);
  }


  TYPE_FIELDS (ref) = fields;
  layout_type (ref);
  TYPE_NAME (ref) = name;

  return ref;


}


tree promote_field_to_structure(tree field_decl)
{


  tree name = DECL_NAME(field_decl);
  tree type = TREE_TYPE(field_decl);
  char buf[100];
  get_expr_string (name, buf);
  strcat(buf, "_profile");
  name = get_identifier (buf);


  tree ref = make_node (RECORD_TYPE);
  tree attributes = NULL_TREE;
  TYPE_SIZE (ref) = 0;
  decl_attributes (&ref, attributes, (int) ATTR_FLAG_TYPE_IN_PLACE);
  TYPE_PACKED (ref) = 0;


  tree fields = create_fields_of_profile (type);
  for (tree x = fields; x; x = TREE_CHAIN (x))
  {
    DECL_CONTEXT (x) = ref;
    DECL_PACKED (x) |= TYPE_PACKED (ref);
  }


  TYPE_FIELDS (ref) = fields;
  layout_type (ref);
  TYPE_NAME (ref) = name;


  return ref;


}



/*
  If DEF=1, then REF is a write.
  
  E.g.  p->next    ==>   p->next.data
      *(p)       ==>   p->data
        p        ==>    p.data
*/  
static void
adjust_references_to_new_structure (gimple_stmt_iterator * gsi, tree ref, int opnd, int def)
{

  gimple stmt = gsi_stmt (*gsi);

  switch (TREE_CODE (ref))
  {
    case SSA_NAME:
      break;
      
    case VAR_DECL:    // a --> a.data
    {
      if ( !bitmap_bit_p(involved_vars, DECL_PT_UID(ref) ) ) 
        break;
      
      tree type = TREE_TYPE(ref);      
      if( new_types.find(type) == new_types.end() );
        break;
      tree field = TYPE_FIELDS(type);
      tree new_ref = build_component_ref( EXPR_LOCATION(ref), ref, field );
      gimple_set_op( stmt, opnd, new_ref );      
      break;
    }

    case COMPONENT_REF: // a.b --> a.b.data
    {
  
      tree field = TREE_OPERAND(ref,1);
      if( new_types.find(field) == new_types.end() );
        break;
      tree type = TREE_TYPE(field);
      tree newfield = TYPE_FIELDS(type);      
      tree new_ref = build_component_ref( EXPR_LOCATION(ref), ref, newfield );      
      gimple_set_op( stmt, opnd, new_ref );      
      break;
    }
      
    case ARRAY_REF:   // a[i] --> a[i].data
    {
      tree array = TREE_OPERAND(ref,0);
      tree type = TREE_TYPE(array);
      if( new_types.find(type) == new_types.end() );
        break;
      type = TREE_TYPE(ref);
      tree field = TYPE_FIELDS(type);
      tree new_ref = build_component_ref( EXPR_LOCATION(ref), ref, field );
      gimple_set_op( stmt, opnd, new_ref );      
      break;
    }
    //case MEM_REF:
      
    default:
      printf("MAIN:UNKNOWN TREE CODE %d\n",gimple_code(stmt));
      gcc_assert(false);
      break;
  }




}


void get_points_to_set_and_type(ipa_data_reference* dr, bitmap pt, TREE_SET involved_types,
                                          TYPE_TYPE_MAP involved_fields)
{
  switch (TREE_CODE (DR_REF(dr)))
  {
    case SSA_NAME:
      break;
  
    case 
  
  
  }
    


}

TYPE_TYPE_MAP type_to_newtype;    // map new type to old type


void
update_decl_type (tree decl)
{
  tree type = TREE_TYPE(decl);
  TYPE_TYPE_MAP::iterator iter = type_to_newtype.find(type);

  if ( iter != type_to_newtype.end() )
  {
    TREE_TYPE(decl) = 
  }

}

int
update_decl_type (void **slot, void *data)
{
  static TREE_SET updated;
  bitmap toupdate = (bitmap)data;

  dr_hash_entry *dr_entry = *(dr_hash_entry **) slot;

  ipa_data_reference *dr = dr_entry->dr;
  
  switch_to_context (DR_PROC (dr));
  tree ref = DR_REF(dr);
  switch (TREE_CODE(ref))
  {
    case VAR_DECL:  
    {
      if ( bitmap_bit_p (toupdate, DECL_PT_UID(ref) ) )
      {
        
        ;
      }
    }
      


  }



  
  dr->compute_reference_set ();
  switch_off_context ();
  return 1;
}


static int
layout_parent_type (void **slot, void *data)
{
  TREE_SET *pending_structures = (TREE_SET*)data;

  tree type = (*(struct type_hash **) slot)->type;

  ...
}


void collect_types(TREE_SET &types)
{


}


void promote_data_structures_to_profile(bitmap read, bitmap write)
{

  TREE_SET involved_types;

  /* Step 1. Scanning data types invovled in profiling (read/write).
             Create involved_types set
  */

  unsigned int i;
  bitmap_iterator bi;
  EXECUTE_IF_SET_IN_BITMAP (read, 0, i, bi)
  {
    dr_hash_entry dr_entry;
    dr_entry.id = i;      
    dr_hash_entry **slot = (dr_hash_entry **) htab_find_slot (dr_hash, &dr_entry, NO_INSERT);
    gcc_assert (*slot);
    ipa_data_reference* dr = (**slot).dr;
    get_points_to_set_and_type (dr, involved_vars, involved_types, involved_fields);    
  }
  EXECUTE_IF_SET_IN_BITMAP (write, 0, i, bi)
  {
    dr_hash_entry dr_entry;
    dr_entry.id = i;      
    dr_hash_entry **slot = (dr_hash_entry **) htab_find_slot (dr_hash, &dr_entry, NO_INSERT);
    gcc_assert (*slot);
    ipa_data_reference* dr = (**slot).dr;
    get_points_to_set_and_type (dr, involved_vars, involved_types, involved_fields);    
  }

  TREE_SET &types;
  collect_types ();

  
  /* Step 2. Create new data types */


  // scalars
  TYPE_TYPE_MAP newtype_to_type;    // map new type to old type
  for (TREE_SET::iterator iter = involved_types.begin(); iter != involved_types.end(); ++iter)
  {
    tree type = *iter;    
    tree newtype = promote_type_to_structure(type);
    type_to_newtype[type] = newtype;
      
    /* reform field as a new structure */
    new_types.insert(newtype);
  }


  // fields
  TREE_SET pending_structures;
  for (TYPE_TYPE_MAP::iterator iter = involved_fields.begin(); iter != involved_fields.end(); ++iter)
  {
    tree field = iter->first;

    /* reform field as a new structure */

    tree newtype = promote_field_to_structure(field);    
    TREE_TYPE(field) = newtype;
    new_types.insert(field);

    /* collect parent strcuture */
    tree structure = iter->second;
    pending_structures.insert(structure);
  }

  /* Build type-inclusion graph */

  /* layout all infected strcutures */

  for (TREE_SET::iterator iter = pending_structures.begin(); iter != pending_structures.end(); ++iter)
  {
    tree type = *iter;    
    layout_type (type);
  }

  
  
  //same_type_p



  /* Re */


  /* Step 3. Adjust declaration of each invovled variable (static-allocated and heap-allocated) */
	htab_traverse (dr_hash, compute_reference_set, NULL);



  /* Step 4. Alternate all references to these variables in whole program wide according to new_types set. 
             E.g.  p->next    ==>   p->next.data
                   *(p)       ==>   p->int_t.data

  */
  for (cgraph_node_ptr node = cgraph_nodes; node; node = node->next)
  {
    if (!valid_function_node_p (node))
      continue;
    switch_to_context (node->decl);
    profile_memop (node, adjust_references_to_new_structure);
    switch_off_context();
  }

  
}
#endif  


/* Convert each indirect call to a multi-case branch of normal calls */
void
ipa_convert_icall()
{

  struct cgraph_node *node;
  for (node = cgraph_nodes; node; node = node->next)
  {

    if (!valid_function_node_p (node))
      continue;

    switch_to_context(node->decl);
    basic_block bb;
    FOR_EACH_BB(bb)
    {                
      for (gimple_stmt_iterator gsi = gsi_start_bb (bb); !gsi_end_p (gsi); gsi_next (&gsi))
      {
        gimple stmt = gsi_stmt (gsi);

        if (!is_gimple_call(stmt))
          continue;

        tree callee_decl = gimple_call_fndecl(stmt);   
        if (callee_decl)
          continue;
        
        /* indirect call */           
        tree fptr = gimple_call_fn (stmt);
        gcc_assert (TREE_CODE (fptr) == SSA_NAME);     
        tree retval = gimple_call_lhs (stmt);
        tree newret = retval;
        if (retval)
          newret = create_tmp_var (TREE_TYPE(retval), NULL);

        // split bb 
        edge entry_edge = split_block (bb, stmt);
        basic_block succ_bb = entry_edge->dest;

        struct cgraph_edge *call_edge = cgraph_edge (node, stmt);        
        struct nodeList * callees = call_edge->indirect_info->callees;
        while (callees)
        {
          tree target = callees->node->decl;

          // Create condition : if ( fptr == &target )
          tree condition  = fold_build2 (EQ_EXPR, boolean_type_node, fptr, tree_build_address_expr(target));          
          create_empty_if_region_on_edge (entry_edge, condition);

          // call target in then branch
          
          edge e;
          edge_iterator ei;
          FOR_EACH_EDGE (e, ei, entry_edge->dest->succs)
          {
            if (e->flags & EDGE_TRUE_VALUE)
            {
              gimple newcall = gimple_copy (stmt);
              
              /* Clear out MEM operand vectors on COPY.  */             
              if (gimple_has_mem_ops (newcall))
              {
                gimple_set_vdef (newcall, NULL_TREE);
                gimple_set_vuse (newcall, NULL_TREE);
              }

              gimple_call_set_fndecl (newcall, target);
              gimple_call_set_lhs (newcall, newret);
              gimple_duplicate_extra_info(cfun, newcall, cfun, stmt);
              gsi_insert_before (&gsi_start_bb(e->dest), newcall, GSI_SAME_STMT);       
              mark_symbols_for_renaming (newcall);             
            }
            else if (e->flags & EDGE_FALSE_VALUE)
            {
              entry_edge = e;
            }
          }
          
          callees = callees->next;
        }

        gsi_remove (&gsi, true);

        if (retval)
        {
          gimple assign = gimple_build_assign (retval, newret);
          gsi_insert_before (&gsi_start_bb(succ_bb), assign, GSI_SAME_STMT);       
          mark_symbols_for_renaming (assign);             
        }
        break;

      }    
    }
    switch_off_context();

  }

  update_cgraph();
}




