
#include <tr1/unordered_map>
#include "ipa-check-dependence.h"
#include "ipa-union-find.h"

const char *aliasname = "alias.info";
bool  alias_profiling_p = false;

using namespace std;
class alias_class_rep;

class alias_class_member : public U_F_ELEMENT<alias_class_member> 
{
private:
   int    _base_id;  // the dr id


public:
  alias_class_member(int base_id) :
    _base_id(base_id)
      { }

  int  base_id() const
  {
    return _base_id;
  }

  void    Set_base_id(int id)
  {
    _base_id = id;
  }

  alias_class_rep *Alias_class()
  { return (alias_class_rep *) Find(); }


};



// The C++ class representing an alias class
class alias_class_rep : public U_F_REP<alias_class_member> 
{

private:
  int _id;
  std::list<int>  _memops;
  TREE_SET _types;

public:
  long double count;  //execution count

  alias_class_rep(int id) :
    _id(id),
      count(0)
   {    }
   
  int id() const { return _id; }
  std::list<int>  &memops() { return _memops; }
  TREE_SET  &types() { return _types; }


};


typedef  std::tr1::unordered_map < int, alias_class_member* > AILAS_MEMBER_HASH;
typedef  std::list< alias_class_rep* > AILAS_CLASS_LIST;

class alias_classifiction
{


private:
  
  AILAS_MEMBER_HASH   _base_id_map;
  AILAS_CLASS_LIST    _acr_list;
  AILAS_CLASS_LIST    _free_list;
  int                 _last_id_used;
    

public: 

  
  alias_classifiction() :
    _last_id_used(0)
  {}
    
  ~alias_classifiction() 
  {
    /* release alias class member */
    for ( AILAS_MEMBER_HASH::iterator iter = _base_id_map.begin(); iter != _base_id_map.end(); ++iter )
    {
      delete iter->second; 
    }

    /* release alias class */
    for ( AILAS_CLASS_LIST::iterator iter = _acr_list.begin(); iter != _acr_list.end(); ++iter )
    {
      delete *iter; 
    }

  }
  
  alias_class_rep*    New_alias_class(alias_class_member &acm) ;
  void                Free_alias_class(alias_class_rep *acr);  
  void                Classify_memops(FILE *fp);
  void                Classify_memop(ipa_data_reference *dra, ipa_data_reference * drb);
  void                Write_back();
  void                Print(FILE *fp);

};



alias_class_rep*
alias_classifiction::New_alias_class(alias_class_member &acm) 
{
  alias_class_rep *retval;

  if ( !_free_list.empty() ) 
  {
    retval = _free_list.front();
    _free_list.pop_front();

    // Destruct and reconstruct.
    retval->~alias_class_rep();
    new(retval) alias_class_rep(++_last_id_used);
  }
  else {
    retval = new alias_class_rep(++_last_id_used);
    _acr_list.push_back (retval);
  }

  acm.Put_in_set(retval);
  return retval;
}


void
alias_classifiction::Free_alias_class(alias_class_rep *acr) 
{
  _free_list.push_front(acr);
}

void
alias_classifiction::Classify_memop(ipa_data_reference *dra, ipa_data_reference * drb)
{

  int a = dra->uid();
  int b = drb->uid();

  if (a == b )
    return ;

  alias_class_member* &member_a = _base_id_map[a];
  alias_class_member* &member_b = _base_id_map[b];
  
  if ( member_a == NULL )
  {
    member_a = new alias_class_member (a);
    New_alias_class(*member_a);        
    alias_class_rep *class_a = member_a->Alias_class();
    class_a->memops().push_back(a);
    tree type = TREE_TYPE(DR_REF(dra));
    class_a->types().insert( type );
    class_a->count = dra->count();
  }

  if ( member_b == NULL )
  {
    member_b = new alias_class_member (b);
    New_alias_class(*member_b);
    alias_class_rep *class_b = member_b->Alias_class();
    class_b->memops().push_back(b);
    tree type = TREE_TYPE(DR_REF(drb));
    class_b->types().insert( type );
    class_b->count = drb->count();
  }

  alias_class_rep *class_a = member_a->Alias_class();
  alias_class_rep *class_b = member_b->Alias_class();

  if ( class_a != class_b )
  {
    if ( ipa_dr_may_alias_p (dra, drb)  )
    {
      alias_class_rep *result = (alias_class_rep *) class_a->Union(*class_b);
      alias_class_rep *non_result = (result == class_a ? class_b : class_a);
      result->memops().splice (result->memops().begin(), non_result->memops());
      result->types().insert( non_result->types().begin(), non_result->types().end() );
      result->count += non_result->count;
      Free_alias_class (non_result);
    }
  }
   
}

void
alias_classifiction::Write_back()
{

  /* write back */
  for ( AILAS_MEMBER_HASH::iterator iter = _base_id_map.begin(); iter != _base_id_map.end(); ++iter )
  {
    dr_hash_entry dr_entry;
    dr_entry.id = iter->first;
    
    dr_hash_entry *slot = (dr_hash_entry *) htab_find (dr_hash, &dr_entry);
    ipa_data_reference *dr = slot->dr;
    alias_class_rep *rep = iter->second->Alias_class();
    dr->set_class_id (rep->id());

    if ( alias_class_map.find(rep->id()) == alias_class_map.end() )
    {
      ALIAS_CLASS_INFO &info = alias_class_map[rep->id()];
      info.id = rep->id();
      info.memops.insert ( info.memops.end(), rep->memops().begin(), rep->memops().end() );
      info.types.insert ( rep->types().begin(), rep->types().end() );
      info.instruction_count = rep->count;
    }
  }
}


void
alias_classifiction::Print(FILE *fp)
{
  unsigned long long instructions = 0;
  unsigned long long addresses = 0;


  /* stastistic */

  int count = 0;
  for (ALIAS_CLASS_MAP::iterator iter = alias_class_map.begin(); iter != alias_class_map.end(); ++iter )
  {
    ALIAS_CLASS_INFO &info = iter->second;  
    if (info.memops.size())
    {
      fprintf(fp, "CLASS %-4d   MEMOP COUNT %-10d  INST COUNT %-20.0Lf", iter->first, (int)(info.memops.size()),
                    info.instruction_count);  
      fprintf(fp, "   TYPES   ");  
      set<tree> types;
      int i=1;
      for ( TREE_SET::iterator iter2 = info.types.begin(); iter2 != info.types.end(); ++iter2 )
      {
        fprintf(fp, "   (%d)  ", i++);  
        print_generic_expr(fp, *iter2, 0);
      }
        
      fprintf(fp, "\n");
      
      count++;
    }
  }  

  fprintf(fp, "Number of classes = %d\n", count);

}


static int A = 0;
static int B = 0;


int classify_memory_operation (void **slot, void *data)
{
  dr_hash_entry *dr_entry = *(dr_hash_entry **) slot;
  ipa_data_reference *a = dr_entry->dr;

  if (TREE_CODE(DR_REF(a)) == SSA_NAME )
    return 1;

  
  std::pair<ipa_data_reference*, alias_classifiction*> *arg = 
    (std::pair<ipa_data_reference*, alias_classifiction*>*) data;
  ipa_data_reference *b = arg->first;

  alias_classifiction *apc = arg->second;
  
  apc->Classify_memop (a, b);


  return 1;

}

int classify_a_memory_operation (void **slot, void *data)
{
  dr_hash_entry *dr_entry = *(dr_hash_entry **) slot;
  ipa_data_reference *dr = dr_entry->dr;

  A++;

  if (TREE_CODE(DR_REF(dr)) == SSA_NAME )
    return 1;
  
  alias_classifiction *apc = (alias_classifiction*)data;
  std::pair<ipa_data_reference*, alias_classifiction*> arg (dr, apc);

  htab_traverse (dr_hash, classify_memory_operation, &arg);  
  
  return 1;
}

int put_into_vector(void **slot, void *data)
{
  dr_hash_entry *dr_entry = *(dr_hash_entry **) slot;
  ipa_data_reference *dr = dr_entry->dr;
  if ( dr->invalid() )
    return 1;

  if (TREE_CODE(DR_REF(dr)) == SSA_NAME )
    return 1;

  std::vector<ipa_data_reference*> *dr_vec = (std::vector<ipa_data_reference*>*) data; 
    
  dr_vec->push_back(dr);

//  char *name = lang_hooks.decl_printable_name (DR_PROC(dr), 2);
  
  return 1;
}



void ipa_classify_memory_operations (FILE *fp)
{

  fprintf (stderr, "start alias classifying \n");

  alias_classifiction apc;

  std::vector<ipa_data_reference*> dr_vec;
  dr_vec.reserve((htab_size(dr_hash)));

  htab_traverse (dr_hash, put_into_vector, &dr_vec);

  for ( std::vector<ipa_data_reference*>::iterator iter = dr_vec.begin(); iter != dr_vec.end(); ++iter)
  {
    std::vector<ipa_data_reference*>::iterator iter2 = iter;
    ++iter2;
    
    for ( ; iter2 != dr_vec.end(); ++iter2)
      apc.Classify_memop (*iter, *iter2);
  }
  
  apc.Write_back();

  if (fp)
    apc.Print(fp);

}



bool
profiling_dr_not_alias_p (const ipa_data_reference *a, const ipa_data_reference *b)
{
  /* not sure */
  if ( !alias_profiling_p )
    return false;

  // sure
  if ( a->class_id() == 0 || b->class_id() == 0 )
    return true;
  
  return (a->class_id() == b->class_id() );
}


