/* Various declarations for instrumentation of GIMPLE statements and
   expressions.
   added by wang80@purdue.edu
  */

#ifndef GCCIINSTR_SOURCEC_H
#define GCC_INSTR_SOURCEC_H

//#include "ipa-check-dependence.h"

/* In instr-sourcec.c
*/
#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "tm.h"
#include "tree.h"
#include "c-family/c-common.h"
#include "langhooks.h"
#include "flags.h"
#include "cgraph.h"
#include "diagnostic.h"
#include "gimple.h"
#include "timevar.h"
#include "params.h"
#include "fibheap.h"
#include "intl.h"
#include "tree-pass.h"
#include "hashtab.h"
#include "coverage.h"
#include "ggc.h"
#include "tree-flow.h"
#include "rtl.h"
#include "ipa-prop.h"
#include "ipa-utils.h"
#include "except.h"
#include "function.h"
#include <stdio.h>



struct GTY(()) Function_Mod_Ref_Info{
  int id;
  int isInstr; // whether this function should be instrumented
  /* currently, assume there are at most 10000 functions, 
   *  if this func(id) dependent on function x, dep_chain[x]= 1;
  */
  int dep_chain[10000];
  bitmap var_read;
  bitmap var_write;
  
};


struct GTY(()) Basic_Block_Extra{
  
  int visited; // 1 indicates the BB has already been visited
};

struct GTY((chain_next ("%h.next"))) Seed_List {
  gimple id;
  struct Seed_List *next;
};

struct GTY(()) Instr_Stat {
  int total_num_of_func;
  int instr_num_of_func;
  int levels;

};

/*
struct GTY((chain_next ("%h.next"))) Instr_List {
  struct cgraph_node *func;
  struct Instr_List *next; 
  };*/



typedef struct Seed_List *seedlist;
typedef struct nodeList *instrlist;
typedef struct nodeList *funcset;

extern seedlist criteria;
extern int funcnum; //number of functions been instrumented
extern int paranum; //number of varibles in check pointing
extern int writenum; //number of global variable write (i.e, number of ___GLOBAL_COUNTER++);
extern int instrlevel; //instrument level 
extern struct Instr_Stat instr_stat;  
extern void add_gimple_node_c (gimple);


inline 
struct Function_Mod_Ref_Info *
func_mod_ref_info(const cgraph_node_ptr node)
{
  return (struct Function_Mod_Ref_Info*)(node->extra_info);
}

inline
struct Basic_Block_Extra *
bb_extra_info(basic_block bb){
  return (struct Basic_Block_Extra*)(bb->extra_info);
}

inline bool
valid_function(cgraph_node_ptr node)
{

  if ( cgraph_function_body_availability(node) < AVAIL_OVERWRITABLE
       || node->global.inlined_to )
    return false;

  /* Nodes without a body are not interesting.  */
  if (!gimple_has_body_p (node->decl)  || node->clone_of)
    return false;

  const char *name = cgraph_node_name(node);

  if ( strcmp(name, "atoi")==0 )
    return false;
  if ( strcmp(name, "strtol")==0 )
    return false;
  
  if ( strcmp(name, "atof")==0 )
    return false;
  if ( strcmp(name, "strtod")==0 )
    return false;

  if ( strcmp(name, "__strpbrk_c3")==0 )
    return false;

  if ( strcmp(name, "strtoul")==0 )
    return false;
  
  if ( strcmp(name, "printf") == 0 )
    return false;

  return true;
}


inline int
add_func2set(funcset set, cgraph_node_ptr node){
  int num = 1;
  funcset head = set;
  funcset new_node = XNEWVEC(struct nodeList, 1);
  new_node -> next = NULL;
  new_node -> node = node;

  if (head == NULL) {
    set = new_node;
    return num;
  } 
  
  while(head->next != NULL){
    num++;
    head = head->next;
  }
  
  head->next = new_node;
  return num;

}


inline void
switch_to_context_new( tree func_decl )
{
  push_cfun (DECL_STRUCT_FUNCTION (func_decl));
  current_function_decl = func_decl;
}


inline void 
switch_off_context_new (void)
{
  pop_cfun ();
  if ( cfun )
    current_function_decl = cfun->decl;
  else
    current_function_decl = NULL_TREE;
}


void initial_bb_visit( tree func_decl){

  /*clear bb -> visited*/
  switch_to_context_new(func_decl);
  struct Basic_Block_Extra *info;
  basic_block bb;
  FOR_EACH_BB(bb){
    info = XNEWVEC(struct Basic_Block_Extra, 1);
    info->visited = 0;
    bb->extra_info = info;
  }

  switch_off_context_new();
  /* enter bb, always index = 0*/
  bb = ENTRY_BLOCK_PTR_FOR_FUNCTION(DECL_STRUCT_FUNCTION(func_decl));
  info = XNEWVEC(struct Basic_Block_Extra, 1);
  info->visited = 0;
  bb->extra_info = info;
  /* exit bb, always index = 1*/
  bb = EXIT_BLOCK_PTR_FOR_FUNCTION(DECL_STRUCT_FUNCTION(func_decl));
  info = XNEWVEC(struct Basic_Block_Extra, 1);
  info->visited = 0;
  bb->extra_info = info;
 
}

/* convert an int to a string*/
char* my_itos(int a){

  int j, i = 0;
  int temp = a;

  while (temp > 0) {
    temp = temp / 10;
    i ++;
  }

  char* res = XNEWVEC(char , i+1);

  res[i] = '\0';
  for ( j = i-1; j >=0; j--){
    temp = a / 10;
    res[j]  = a % 10 + '0';
    a = temp;
  }

  return res;
}

//extern void dump_bb_new(basic_block,FILE *)
#endif /* ! GCC_INSTR_SOURCEC_H */
