#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "tm.h"
#include "tree.h"
#include "langhooks.h"
#include "flags.h"
#include "cgraph.h"
#include "diagnostic.h"
#include "gimple-pretty-print.h"
#include "gimple.h"
#include "timevar.h"
#include "params.h"
#include "fibheap.h"
#include "intl.h"
#include "tree-pass.h"
#include "hashtab.h"
#include "coverage.h"
#include "ggc.h"
#include "tree-flow.h"
#include "rtl.h"
#include "ipa-prop.h"
#include "except.h"
#include "function.h"
#include "spec-func-list.h"


FILE *dumpfile;

struct Type_List *printedtypelist;

static void init_dump(){
  char outputfile[100];
  strcpy(outputfile,main_input_filename);

  if (flag_instr_source){ 
    strcat(outputfile, "_record.c");
  }else if (flag_instr_baseline){
    strcat(outputfile, "_baseline.c");
  }else if (flag_instr_replay){ 
    strcat(outputfile, "_replay.c");
  }else if (flag_instr_non_inline){
    strcat(outputfile, "_noninline.c");
  }else if (flag_dump_source)
    strcat(outputfile, "_source.c");

  dumpfile = fopen(outputfile,"w");
  if (flag_instr_replay){
    fprintf(dumpfile, "#include \"helper_replay.h\"\n");
  }
  if (flag_instr_source){
    fprintf(dumpfile, "#include \"helper_record.h\"\n");
  }
}


static inline void
switch_to_context_new( tree func_decl )
{
  push_cfun (DECL_STRUCT_FUNCTION (func_decl));
  current_function_decl = func_decl;
}


static inline void
switch_off_context_new (void)
{
  pop_cfun ();
  if ( cfun )
    current_function_decl = cfun->decl;
  else
    current_function_decl = NULL_TREE;
}


#ifdef NO_CHANCE_THAT_THIS_SYMBOL_WILL_EVER_EXIST  
void dump_gimple_statement(gimple stmt){
  /*get the gimple code*/
  enum gimple_code stmt_code = gimple_code (stmt);  
  
  print_gimple_stmt_c (dumpfile, stmt, 0, 0); //added in gimple-pretty-print-c.c
  fprintf(dumpfile,"\n");

  
}


/*if stmt is a "printf" function call */
int isPrintf(gimple stmt){
  enum gimple_code stmt_code = gimple_code (stmt);
  if (stmt_code != GIMPLE_CALL) return 0;
  
  tree fn = gimple_call_fn(stmt);
  if (TREE_CODE (fn) == NON_LVALUE_EXPR)
    fn = TREE_OPERAND (fn, 0);

 continue_1:
  switch (TREE_CODE (fn))
    {
    case VAR_DECL:
    case PARM_DECL:
    case FUNCTION_DECL:
      goto continue_2;
      break;
      
    case ADDR_EXPR:
    case INDIRECT_REF:
    case NOP_EXPR:
      fn = TREE_OPERAND (fn, 0);
      goto continue_1;
    default:
      break;
    }
  return 0;
 continue_2:
  printf("%s\n",lang_hooks.decl_printable_name (fn, 1));
  if (strcmp(lang_hooks.decl_printable_name (fn, 1),"printf")) return 0; 
  return 1;
}

/* handle D.*="";
   printf(D.*,...);
*/
void dump_gimple_statement_1(gimple stmt, gimple stmt1){
  /*get the gimple code*/
  int flags;
  enum gimple_code stmt_code = gimple_code (stmt);
  
  if (!isPrintf(stmt))
    print_gimple_stmt_c(dumpfile, stmt1, 0, 0);

  /* if this is a printf call, the first parameter should be builted in*/
  flags = TDF_PRINT;
  print_gimple_stmt_c (dumpfile, stmt, 0, flags); //added in gimple-pretty-print-c.c                                                    
  fprintf(dumpfile,"\n");

}

void dump_bb_new(basic_block bb){
  gimple_stmt_iterator bsi; //iterator object for gimple statement sequence
  
  gimple tempstmt;
  int flag = 0;
  enum gimple_code stmt_code;
  for (bsi = gsi_start_bb (bb); !gsi_end_p (bsi); gsi_next (&bsi))
    {
      gimple stmt = gsi_stmt (bsi);
      stmt_code = gimple_code(stmt);
      if (flag ==0 && stmt_code == GIMPLE_ASSIGN) {
	tempstmt = stmt;
	flag = 1;
	continue;
      }
     
      if (flag ==0 && stmt_code != GIMPLE_ASSIGN){
	dump_gimple_statement(stmt);
	continue;
      }
	
      if (flag == 1 && stmt_code != GIMPLE_ASSIGN) {
	dump_gimple_statement_1(stmt,tempstmt);
	flag = 0;
      } else {
	dump_gimple_statement(tempstmt);
	tempstmt = stmt;
      }
	
    }

  gimple_seq seq = bb_seq (bb);
  if ( gimple_seq_empty_p(seq) )
    fprintf (dumpfile, "  empty" );

  fprintf (dumpfile, "\n" );
}
#endif

static char* create_new_name(int v, char * str){
  int len = 0;
  int len1;
  int temp = v;
  int i;
  while (v>0){
    len ++;
    v = v/10;
  }
  len1 = len + strlen(str);
  char *name =  XNEWVEC (char, len1+1);
  name[0] = 'D';
  v = temp;
  for (i = len; i > 0; i--){
    name[i] = v - v/10 *10 + '0';
    v = v / 10;
  }
  for (i = len+1; i <= len1; i++)
    name[i] = str[i - len - 1];
  name[i] = '\0'; 
  return name;
  
}
 
/*rename local vars if necessary                                                                                            
          e.g.                                                                                                                     
          if (x>0) {                                                                                                               
           int temp;                                                                                                              
           ...                                                                                                                     
          }else{                                                                                                                   
           int temp;                                                                                                               
           ...                                                                                                                     
          }                                                                                                                        
          in local var, there will be two "int temp"                                                                               
*/
static void rename_local_var(tree fn){

  unsigned ix;
  tree var;
  struct function *dsf = DECL_STRUCT_FUNCTION (fn);
  int version = 1;

  FOR_EACH_LOCAL_DECL (dsf, ix, var){
    if (TREE_CODE(var) != VAR_DECL) continue;
    if (!DECL_NAME(var)) continue;
    tree name = DECL_NAME(var);
    int ix1;
    tree var1;
    for (ix1 = ix + 1; VEC_iterate (tree, dsf->local_decls, ix1, var1);  ix1++){
      if (TREE_CODE(var1) != VAR_DECL) continue;
      if (!DECL_NAME(var1)) continue;
      tree name1 = DECL_NAME(var1);
      if (name1 == name) {
	/* if two vars have the same name, rename the later one*/
	char *str = IDENTIFIER_POINTER(name);
	char *newName = create_new_name(version, str); 
	DECL_NAME(var1) = get_identifier(newName);
	version++;
	break;
      }
    } //end of for ix1 = ix-1
  } // end of FOR_EACH_LOCAL_DECL

}
 
static void dump_sourcec_main(){
  if (!flag_dump_source) return;
  
  printf("to do: dumping c source code from gimple ...\n");

  struct cgraph_node *node;
  struct cgraph_node *node_end;
  struct SpecialFuncList *flist;  
  printedtypelist = NULL;
  init_dump();
  printf("initialization success!\n");

  //get special function list
  flist = get_list("special-func");
  
  node_end = cgraph_nodes;
  while (node_end->next != NULL) node_end = node_end->next;

  for (node = node_end; node ; node = node->previous)
    {
      
      switch_to_context_new (node->decl);
  
      if (cfun != NULL) {

	rename_local_var(node->decl);
	dump_function_decl_c(node->decl, dumpfile);
	// in replay instr for special functions, no function body is needed to dump
	if (!flag_instr_replay || !is_in_SFL(flist, cgraph_node_name(node))){
	  pre_check_bb_edge(node->decl, dumpfile);
	  basic_block bb;
	  FOR_EACH_BB (bb)
	  gimple_dump_bb_c(bb,dumpfile,2,0);
	}
	fprintf(dumpfile,"}\n\n");

      }
      switch_off_context_new();

    }
  fclose(dumpfile);
  printf("==================finished====================\n\n");
  
  exit(0);
}

struct simple_ipa_opt_pass pass_dump_sourcec =
  {
    {
      SIMPLE_IPA_PASS,
      "dump-sourcec",               /* name */
      dump_sourcec_main,             /* gate */
      NULL, /* sub */
      NULL, /* next */
      0, /* static_pass_number */
      0, /* tv_id */
      PROP_ssa, /* properties_required */
      0, /* properties_provided */
      0, /* properties_destroyed */
      0, /* todo_flags_start */
    0
    }
  };
